/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

class RemoteSystemLogListener
implements ILogListener,
Preferences.IPropertyChangeListener {
    private PrintWriter log = null;
    private File outputFile = null;

    public RemoteSystemLogListener(Plugin plugin) {
        IPath path = plugin.getStateLocation().addTrailingSeparator().append(".log");
        this.outputFile = path.toFile();
        if (this.outputFile != null && this.outputFile.exists()) {
            this.outputFile.delete();
        }
        this.initialize();
    }

    private void initialize() {
        try {
            this.freeResources();
            this.log = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.outputFile.toString(), true)), true);
        }
        catch (Exception e) {
            this.log = null;
            System.err.println("Exception in RemoteSystemLogListener.initialize(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void logging(IStatus status) {
        if (this.log == null) {
            return;
        }
        String date = new Date().toString();
        this.log.println(date);
        int severity = status.getSeverity();
        if (severity == 4) {
            this.log.print("ERROR");
        } else if (severity == 2) {
            this.log.print("WARNING");
        } else if (severity == 1) {
            this.log.print("INFO");
        } else if (severity == 0) {
            this.log.print("DEBUG");
        }
        this.log.print(" ");
        this.log.print(status.getPlugin());
        this.log.print("  ");
        this.log.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace(this.log);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.loggingChild(children[i]);
                ++i;
            }
        }
        this.log.println("--------------------------------------------");
    }

    public void logging(IStatus status, String plugin) {
        this.logging(status);
    }

    private void loggingChild(IStatus status) {
        if (this.log == null) {
            return;
        }
        this.log.print("\t\t");
        this.log.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace(this.log);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.logging(children[i]);
                ++i;
            }
        }
    }

    public synchronized void propertyChange(Preferences.PropertyChangeEvent event) {
        this.initialize();
    }

    public void freeResources() {
        if (this.log == null) {
            return;
        }
        this.log.flush();
        this.log.close();
        this.log = null;
    }
}

