/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RemoteSystemsLoggingPlugin
extends Plugin {
    private static RemoteSystemsLoggingPlugin singleton;
    private ResourceBundle resourceBundle;
    public static Logger out;

    static {
        out = null;
    }

    public RemoteSystemsLoggingPlugin() {
        singleton = this;
    }

    public static RemoteSystemsLoggingPlugin getDefault() {
        return singleton;
    }

    public static String getResourceString(String key) {
        try {
            ResourceBundle bundle = RemoteSystemsLoggingPlugin.getDefault().getResourceBundle();
            return bundle.getString(key);
        }
        catch (Exception e) {
            out.logError("could not get resource string for: " + key, e);
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                Path path = new Path("$nl$/RemoteSystemsLogging.properties");
                URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
                this.resourceBundle = new PropertyResourceBundle(url.openStream());
            }
            catch (Exception exception) {
                this.resourceBundle = null;
                out.logInfo("RemoteSystemsLoggingPlugin - unable to log resourcebundle");
            }
        }
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        out = LoggerFactory.getLogger(this);
        out.logInfo("loading RemoteSystemsLoggingPlugin class.");
    }

    public void stop(BundleContext context) throws Exception {
        LoggerFactory.freeLogger(this);
        super.stop(context);
    }
}

