/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.IRemotePath;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RemotePath
implements IRemotePath {
    protected String profileName;
    protected String connectionName;
    protected String absolutePath;

    public RemotePath(String profileName, String connectionName, String absolutePath) {
        this.setProfileName(profileName);
        this.setConnectionName(connectionName);
        this.setAbsolutePath(absolutePath);
    }

    public RemotePath(String fullyQualifiedPath) {
        int colonIndex;
        int dotIndex;
        if (fullyQualifiedPath != null && (dotIndex = fullyQualifiedPath.indexOf(46)) != -1 && dotIndex != fullyQualifiedPath.length() - 1 && (colonIndex = fullyQualifiedPath.indexOf(58, dotIndex + 1)) != -1 && colonIndex != fullyQualifiedPath.length() - 1) {
            this.setProfileName(fullyQualifiedPath.substring(0, dotIndex));
            this.setConnectionName(fullyQualifiedPath.substring(dotIndex + 1, colonIndex));
            this.setAbsolutePath(fullyQualifiedPath.substring(colonIndex + 1));
        }
    }

    protected void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    protected void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    protected void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getFullyQualifiedPath() {
        if (this.profileName == null || this.connectionName == null || this.absolutePath == null) {
            return null;
        }
        return String.valueOf(this.profileName) + "." + this.connectionName + ":" + this.absolutePath;
    }

    public String getFileExtension() {
        if (this.absolutePath == null) {
            return null;
        }
        int dotIndex = this.absolutePath.lastIndexOf(46);
        if (dotIndex != -1) {
            if (dotIndex != this.absolutePath.length() - 1) {
                return this.absolutePath.substring(dotIndex + 1);
            }
            return "";
        }
        return null;
    }

    public IRemotePath addFileExtension(String extension) {
        if (this.absolutePath == null) {
            return null;
        }
        if (this.absolutePath.endsWith("/") || this.absolutePath.endsWith("\\")) {
            return this;
        }
        String newAbsolutePath = String.valueOf(this.absolutePath) + "." + extension;
        return new RemotePath(this.profileName, this.connectionName, newAbsolutePath);
    }

    public IRemotePath removeFileExtension() {
        if (this.absolutePath == null) {
            return null;
        }
        if (this.absolutePath.endsWith("/") || this.absolutePath.endsWith("\\")) {
            return this;
        }
        int dotIndex = this.absolutePath.lastIndexOf(46);
        if (dotIndex == -1) {
            return this;
        }
        String newAbsolutePath = this.absolutePath.substring(0, dotIndex);
        return new RemotePath(this.profileName, this.connectionName, newAbsolutePath);
    }

    public boolean isVirtual() {
        return ArchiveHandlerManager.isVirtual((String)this.absolutePath);
    }

    public IRemoteFile toRemoteFile() {
        if (this.profileName == null || this.connectionName == null || this.absolutePath == null) {
            return null;
        }
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        ISystemProfile profile = registry.getSystemProfile(this.profileName);
        if (profile == null) {
            return null;
        }
        IHost conn = registry.getHost(profile, this.connectionName);
        if (conn == null) {
            return null;
        }
        IRemoteFileSubSystem subsys = RemoteFileUtility.getFileSubSystem(conn);
        IRemoteFile remoteFile = null;
        try {
            remoteFile = subsys.getRemoteFileObject(this.absolutePath);
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"Error occured trying to get remote file", (Throwable)e);
            remoteFile = null;
        }
        return remoteFile;
    }
}

