/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.subsystems.files.core.model.IRemotePath;

public class RemotePathUtil {
    private static RemotePathUtil instance;

    private RemotePathUtil() {
    }

    public static RemotePathUtil getInstance() {
        if (instance == null) {
            instance = new RemotePathUtil();
        }
        return instance;
    }

    public IPath getClientTempLocationForFile(IRemotePath remotePath) {
        String tempDirString = System.getProperty("java.io.tmpdir");
        Path tempPath = new Path(tempDirString);
        if (tempDirString == null) {
            return null;
        }
        String absolutePath = remotePath.getAbsolutePath();
        String sep = "/";
        boolean isVirtual = remotePath.isVirtual();
        Path newPath = new Path(tempPath.toOSString());
        if (!(newPath = this.appendRemoteFileNameToPath((IPath)newPath, absolutePath, sep)).equals((Object)tempPath)) {
            return newPath;
        }
        if (isVirtual) {
            return null;
        }
        sep = "\\";
        if (!(newPath = this.appendRemoteFileNameToPath((IPath)newPath, absolutePath, sep)).equals((Object)tempPath)) {
            return newPath;
        }
        return null;
    }

    private IPath appendRemoteFileNameToPath(IPath path, String absolutePath, String sep) {
        int sepIndex = absolutePath.lastIndexOf(sep);
        if (sepIndex != -1) {
            if (sepIndex != absolutePath.length() - 1) {
                return path.append(absolutePath.substring(sepIndex + 1));
            }
            return path;
        }
        return path.append(absolutePath);
    }
}

