/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.PrintWriter;

public class SystemElapsedTimer {
    private long startTime;
    private long endTime;

    public SystemElapsedTimer() {
        this.setStartTime();
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public SystemElapsedTimer setEndTime() {
        this.endTime = System.currentTimeMillis();
        return this;
    }

    public long getElapsedTime() {
        return this.endTime - this.startTime;
    }

    public String toString() {
        long deltaMillis = this.getElapsedTime();
        long millis = deltaMillis % 1000L;
        long deltaSeconds = deltaMillis / 1000L;
        long deltaMinutes = deltaSeconds / 60L;
        long hours = (int)(deltaMillis / 3600000L);
        long minutes = (int)(deltaMinutes - hours * 60L);
        long seconds = (int)(deltaSeconds - hours * 60L * 60L - minutes * 60L);
        String result = "Elapsed time: " + hours + " hours, " + minutes + " minutes, " + seconds + " seconds, " + millis + " milliseconds";
        return result;
    }

    public void writeElapsedTime(PrintWriter writer, String header) {
        writer.println(header);
        writer.println(this.toString());
        writer.flush();
    }

    public static void main(String[] args) {
        SystemElapsedTimer me = new SystemElapsedTimer();
        me.setET(5L, 4L, 3L, 100L);
        System.out.println(me);
        me.setET(25L, 14L, 53L, 999L);
        System.out.println(me);
        me.setET(25L, 0L, 53L, 0L);
        System.out.println(me);
        me.setET(0L, 0L, 13L, 0L);
        System.out.println(me);
    }

    public void setET(long h, long m, long s, long n) {
        long et = n + s * 1000L + m * 60L * 1000L + h * 60L * 60L * 1000L;
        this.setET(et);
    }

    public void setET(long givenET) {
        this.startTime = 0L;
        this.endTime = givenET;
    }
}

