/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemRemoteObjectMatcher;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.ObjectFilterTest;
import org.eclipse.ui.internal.ObjectPluginAction;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.PluginActionContributionItem;

public class SystemPopupMenuActionContributor
extends PluginActionBuilder
implements IObjectActionContributor {
    private static final String ATT_TYPE_CATEGORY_FILTER = "typecategoryfilter";
    private static final String ATT_NAME_FILTER = "namefilter";
    private static final String ATT_TYPE_FILTER = "typefilter";
    private static final String ATT_SUBTYPE_FILTER = "subtypefilter";
    private static final String ATT_SUBSUBTYPE_FILTER = "subsubtypefilter";
    private static final String ATT_SUBSYSTEM_FACTORY_ID = "subsystemconfigurationid";
    private static final String ATT_SUBSYSTEM_FACTORY_CATEGORY = "subsystemconfigurationCategory";
    private static final String ATT_SYSTEM_TYPES = "systemTypes";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_LABEL = "label";
    private static final String ATT_PATH = "path";
    private static final String TAG_OBJECT_CONTRIBUTION = "objectContribution";
    private static final String TAG_MENU = "menu";
    private static final String TAG_ACTION = "action";
    private static final String TAG_SEPARATOR = "separator";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_VISIBILITY = "visibility";
    private static final String TAG_GROUP_MARKER = "groupMarker";
    private IConfigurationElement config;
    private List cachedMenus;
    private List cachedActions;
    private boolean configRead = false;
    private ObjectFilterTest filterTest;
    private ActionExpression visibilityTest;
    private SystemRemoteObjectMatcher matcher = null;
    static /* synthetic */ Class class$0;

    public SystemPopupMenuActionContributor(IConfigurationElement element) {
        this.config = element;
        this.cachedMenus = new ArrayList();
        this.cachedActions = new ArrayList();
        String categoryfilter = element.getAttribute(ATT_TYPE_CATEGORY_FILTER);
        String namefilter = element.getAttribute(ATT_NAME_FILTER);
        String typefilter = element.getAttribute(ATT_TYPE_FILTER);
        String subtypefilter = element.getAttribute(ATT_SUBTYPE_FILTER);
        String subsubtypefilter = element.getAttribute(ATT_SUBSUBTYPE_FILTER);
        String subsystemfilter = element.getAttribute(ATT_SUBSYSTEM_FACTORY_ID);
        String subsystemCategoryFilter = element.getAttribute(ATT_SUBSYSTEM_FACTORY_CATEGORY);
        String systypes = element.getAttribute(ATT_SYSTEM_TYPES);
        this.matcher = new SystemRemoteObjectMatcher(subsystemfilter, subsystemCategoryFilter, categoryfilter, systypes, namefilter, typefilter, subtypefilter, subsubtypefilter);
    }

    public String getCategoryFilter() {
        return this.matcher.getCategoryFilter();
    }

    public String getNameFilter() {
        return this.matcher.getNameFilter();
    }

    public String getTypeFilter() {
        return this.matcher.getTypeFilter();
    }

    public String getSubTypeFilter() {
        return this.matcher.getSubTypeFilter();
    }

    public String getSubSubTypeFilter() {
        return this.matcher.getSubSubTypeFilter();
    }

    public String getSubSystemConfigurationId() {
        return this.matcher.getSubSystemConfigurationId();
    }

    public String getSubSystemConfigurationCategoryFilter() {
        return this.matcher.getSubSystemConfigurationCategoryFilter();
    }

    public String getSystemTypesFilter() {
        return this.matcher.getSystemTypesFilter();
    }

    private ISystemRemoteElementAdapter getRemoteAdapter(Object object) {
        Object adapter = null;
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = adaptable.getAdapter((Class)clazz);
        } else {
            IAdapterManager adapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = adapterManager.getAdapter(object, (Class)clazz);
        }
        return (ISystemRemoteElementAdapter)adapter;
    }

    public boolean contributeObjectActions(IWorkbenchPart part, SystemMenuManager menu, ISelectionProvider selProv, List actionIdOverrides) {
        return this.contributeObjectActions(part, menu.getMenuManager(), selProv, actionIdOverrides);
    }

    public boolean contributeObjectActions(IWorkbenchPart part, IMenuManager menu, ISelectionProvider selProv, List actionIdOverrides) {
        this.readConfigElement();
        if (this.cache == null) {
            return false;
        }
        if (this.cachedActions.size() == 0) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        boolean actualContributions = false;
        int i = 0;
        while (i < this.cachedActions.size()) {
            Object obj = this.cachedActions.get(i);
            if (obj instanceof ActionDescriptor) {
                ActionDescriptor ad = (ActionDescriptor)obj;
                this.contributeMenuAction(ad, menu, true);
                if (ad.getAction() instanceof ObjectPluginAction) {
                    ObjectPluginAction action = (ObjectPluginAction)ad.getAction();
                    action.selectionChanged((ISelection)selection);
                    action.setActivePart(part);
                }
                actualContributions = true;
            }
            ++i;
        }
        return actualContributions;
    }

    public void contributeObjectActionIdOverrides(List actionIdOverrides) {
        this.readConfigElement();
    }

    public boolean contributeObjectMenus(SystemMenuManager menu, ISelectionProvider selProv) {
        return this.contributeObjectMenus(menu.getMenuManager(), selProv);
    }

    public boolean contributeObjectMenus(IMenuManager menu, ISelectionProvider selProv) {
        this.readConfigElement();
        if (this.cache == null) {
            return false;
        }
        if (this.cachedMenus.size() == 0) {
            return false;
        }
        ISelection sel = selProv.getSelection();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return false;
        }
        boolean actualContributions = false;
        int i = 0;
        while (i < this.cachedMenus.size()) {
            Object obj = this.cachedMenus.get(i);
            if (obj instanceof IConfigurationElement) {
                IConfigurationElement menuElement = (IConfigurationElement)obj;
                this.contributeMenu(menuElement, menu, true);
                actualContributions = true;
            }
            ++i;
        }
        return actualContributions;
    }

    protected ActionDescriptor createActionDescriptor(IConfigurationElement element) {
        return new ActionDescriptor(element, 1);
    }

    public boolean isApplicableTo(Object object) {
        this.readConfigElement();
        ISystemRemoteElementAdapter adapter = this.getRemoteAdapter(object);
        boolean matches = adapter != null;
        matches = matches && (this.visibilityTest == null || this.visibilityTest.isEnabledFor(object));
        matches = matches && (this.filterTest == null || this.filterTest.matches(object, true));
        matches = matches && this.matcher.appliesTo(adapter, object);
        return matches;
    }

    private void readConfigElement() {
        if (!this.configRead) {
            this.currentContribution = this.createContribution();
            this.readElementChildren(this.config);
            if (this.cache == null) {
                this.cache = new ArrayList(4);
            }
            this.cache.add(this.currentContribution);
            this.currentContribution = null;
            this.configRead = true;
        }
    }

    protected void readContributions(String id, String tag, String extensionPoint) {
        this.cachedMenus.clear();
        this.cachedActions.clear();
        super.readContributions(id, tag, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_VISIBILITY)) {
            this.visibilityTest = new ActionExpression(element);
            return true;
        }
        if (tag.equals(TAG_FILTER)) {
            if (this.filterTest == null) {
                this.filterTest = new ObjectFilterTest();
            }
            this.filterTest.addFilterElement(element);
            return true;
        }
        if (tag.equals(TAG_OBJECT_CONTRIBUTION)) {
            return true;
        }
        if (tag.equals(this.targetContributionTag)) {
            String id;
            if (!(this.targetID == null || (id = this.getTargetID(element)) != null && id.equals(this.targetID))) {
                return true;
            }
            this.currentContribution = this.createContribution();
            this.readElementChildren(element);
            if (this.cache == null) {
                this.cache = new ArrayList(4);
            }
            this.cache.add(this.currentContribution);
            this.currentContribution = null;
            return true;
        }
        if (tag.equals(TAG_MENU)) {
            this.currentContribution.addMenu(element);
            this.cachedMenus.add(element);
            return true;
        }
        if (tag.equals(TAG_ACTION)) {
            ActionDescriptor ades = this.createActionDescriptor(element);
            this.currentContribution.addAction(ades);
            this.cachedActions.add(ades);
            return true;
        }
        return false;
    }

    public boolean canAdapt() {
        return false;
    }

    protected void contributeMenu(IConfigurationElement menuElement, IMenuManager mng, boolean appendIfMissing) {
        IMenuManager newMenu;
        IContributionItem sep;
        String id = menuElement.getAttribute(ATT_ID);
        String label = menuElement.getAttribute(ATT_LABEL);
        String path = menuElement.getAttribute(ATT_PATH);
        if (label == null) {
            SystemBasePlugin.logInfo("Invalid Menu Extension (label == null): " + id);
            return;
        }
        String group = null;
        if (path != null) {
            int loc = path.lastIndexOf(47);
            if (loc != -1) {
                group = path.substring(loc + 1);
                path = path.substring(0, loc);
            } else {
                group = path;
                path = null;
            }
        }
        IMenuManager parent = mng;
        if (path != null && (parent = mng.findMenuUsingPath(path)) == null) {
            SystemBasePlugin.logInfo("Invalid Menu Extension (Path is invalid): " + id);
            return;
        }
        if (group == null) {
            group = "additions";
        }
        if ((sep = parent.find(group)) == null) {
            if (appendIfMissing) {
                this.addGroup((IContributionManager)parent, group);
            } else {
                SystemBasePlugin.logInfo("Invalid Menu Extension (Group is invalid): " + id);
                return;
            }
        }
        if ((newMenu = parent.findMenuUsingPath(id)) == null) {
            newMenu = new MenuManager(label, id);
        }
        try {
            this.insertAfter((IContributionManager)parent, group, (IContributionItem)newMenu);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SystemBasePlugin.logInfo("Invalid Menu Extension (Group is missing): " + id);
        }
        newMenu = parent.findMenuUsingPath(id);
        if (newMenu == null) {
            SystemBasePlugin.logInfo("Could not find new menu: " + id);
        }
        IConfigurationElement[] children = menuElement.getChildren();
        int i = 0;
        while (i < children.length) {
            String childName = children[i].getName();
            if (childName.equals(TAG_SEPARATOR)) {
                this.contributeSeparator(newMenu, children[i]);
            } else if (childName.equals(TAG_GROUP_MARKER)) {
                this.contributeGroupMarker(newMenu, children[i]);
            }
            ++i;
        }
    }

    protected void contributeMenuAction(ActionDescriptor ad, IMenuManager menu, boolean appendIfMissing) {
        IContributionItem sep;
        String mpath = ad.getMenuPath();
        String mgroup = ad.getMenuGroup();
        if (mpath == null && mgroup == null) {
            return;
        }
        IMenuManager parent = menu;
        if (mpath != null && (parent = parent.findMenuUsingPath(mpath)) == null) {
            SystemBasePlugin.logInfo("Invalid Menu Extension (Path is invalid): " + ad.getId());
            return;
        }
        if (mgroup == null) {
            mgroup = "additions";
        }
        if ((sep = parent.find(mgroup)) == null) {
            if (appendIfMissing) {
                this.addGroup((IContributionManager)parent, mgroup);
            } else {
                SystemBasePlugin.logInfo("Invalid Menu Extension (Group is invalid): " + ad.getId());
                return;
            }
        }
        try {
            this.insertAfter((IContributionManager)parent, mgroup, ad.getAction());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SystemBasePlugin.logInfo("Invalid Menu Extension (Group is missing): " + ad.getId());
        }
    }

    protected void contributeSeparator(IMenuManager menu, IConfigurationElement element) {
        String id = element.getAttribute(ATT_NAME);
        if (id == null || id.length() <= 0) {
            return;
        }
        IContributionItem sep = menu.find(id);
        if (sep != null) {
            return;
        }
        this.insertMenuGroup(menu, (AbstractGroupMarker)new Separator(id));
    }

    protected void contributeGroupMarker(IMenuManager menu, IConfigurationElement element) {
        String id = element.getAttribute(ATT_NAME);
        if (id == null || id.length() <= 0) {
            return;
        }
        IContributionItem marker = menu.find(id);
        if (marker != null) {
            return;
        }
        this.insertMenuGroup(menu, (AbstractGroupMarker)new GroupMarker(id));
    }

    protected void contributeToolbarAction(ActionDescriptor ad, IToolBarManager toolbar, boolean appendIfMissing) {
        String tId = ad.getToolbarId();
        String tgroup = ad.getToolbarGroupId();
        if (tId == null && tgroup == null) {
            return;
        }
        if (tgroup == null) {
            tgroup = "additions";
        }
        IContributionItem sep = null;
        sep = toolbar.find(tgroup);
        if (sep == null) {
            if (appendIfMissing) {
                this.addGroup((IContributionManager)toolbar, tgroup);
            } else {
                SystemBasePlugin.logInfo("Invalid Toolbar Extension (Group is invalid): " + ad.getId());
                return;
            }
        }
        try {
            this.insertAfter((IContributionManager)toolbar, tgroup, ad.getAction());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SystemBasePlugin.logInfo("Invalid Toolbar Extension (Group is missing): " + ad.getId());
        }
    }

    protected void insertMenuGroup(IMenuManager menu, AbstractGroupMarker marker) {
        menu.add((IContributionItem)marker);
    }

    protected void insertAfter(IContributionManager mgr, String refId, PluginAction action) {
        this.insertAfter(mgr, refId, (IContributionItem)new PluginActionContributionItem(action));
    }

    protected void insertAfter(IContributionManager mgr, String refId, IContributionItem item) {
        mgr.insertAfter(refId, item);
    }

    protected void addGroup(IContributionManager mgr, String name) {
        mgr.add((IContributionItem)new Separator(name));
    }
}

