/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.internal.filters.SystemFilter;

public class SystemFilterContainerCommonMethods {
    private Vector filterNameVector;
    private Vector filterVector;
    private ISystemFilter[] filterArray;

    public void invalidateCache() {
        this.filterVector = null;
        this.filterNameVector = null;
        this.filterArray = null;
    }

    public ISystemFilter createSystemFilter(List filters, ISystemFilterPool parentPool, String aliasName, Vector filterStrings) {
        ISystemFilter newFilter = null;
        newFilter = this.getSystemFilter(filters, aliasName);
        if (newFilter != null) {
            return newFilter;
        }
        newFilter = this.internalCreateSystemFilter(parentPool, aliasName, filterStrings);
        if (newFilter != null) {
            this.internalAddSystemFilter(filters, newFilter);
        }
        return newFilter;
    }

    public ISystemFilter createSystemFilter(Vector filters, ISystemFilterPool parentPool, String aliasName, Vector filterStrings) {
        boolean exists;
        ISystemFilter newFilter = null;
        boolean bl = exists = this.getSystemFilter(filters, aliasName) != null;
        if (exists) {
            String msg = "Error creating filter: aliasName " + aliasName + " is not unique";
            SystemBasePlugin.logError(msg);
            return null;
        }
        newFilter = this.internalCreateSystemFilter(parentPool, aliasName, filterStrings);
        if (newFilter != null) {
            this.internalAddSystemFilter(filters, newFilter);
        }
        return newFilter;
    }

    private ISystemFilter internalCreateSystemFilter(ISystemFilterPool parentPool, String aliasName, Vector filterStrings) {
        SystemFilter newFilter = null;
        try {
            newFilter = new SystemFilter();
            newFilter.setRelease(100);
            newFilter.setName(aliasName);
            newFilter.setParentFilterPool(parentPool);
            if (filterStrings != null) {
                newFilter.setFilterStrings(filterStrings);
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError("Error creating filter: " + e.getClass().getName() + ": " + e.getMessage());
            SystemBasePlugin.logError("...Alias name.: " + aliasName);
        }
        return newFilter;
    }

    public Vector getSystemFilterNames(List filters) {
        if (this.filterNameVector == null || this.filterNameVector.size() != filters.size()) {
            this.filterNameVector = new Vector();
            if (filters == null) {
                return this.filterNameVector;
            }
            Iterator i = filters.iterator();
            while (i.hasNext()) {
                ISystemFilter next = (ISystemFilter)i.next();
                this.filterNameVector.addElement(next.getName());
            }
        }
        return this.filterNameVector;
    }

    public Vector getSystemFilterNames(Vector filters) {
        if (this.filterNameVector == null || this.filterNameVector.size() != filters.size()) {
            Vector<String> filterNameVector = new Vector<String>();
            if (filters == null || filters.size() == 0) {
                return filterNameVector;
            }
            int idx = 0;
            while (idx < filters.size()) {
                ISystemFilter next = (ISystemFilter)filters.elementAt(idx);
                filterNameVector.addElement(next.getName());
                ++idx;
            }
        }
        return this.filterNameVector;
    }

    public Vector getSystemFiltersVector(List filters) {
        if (this.filterVector == null || this.filterVector.size() != filters.size()) {
            this.filterVector = new Vector();
            Iterator i = filters.iterator();
            while (i.hasNext()) {
                this.filterVector.addElement(i.next());
            }
        }
        return this.filterVector;
    }

    public Vector getSystemFiltersVector(Vector filters) {
        return filters;
    }

    public ISystemFilter[] getSystemFilters(List filters) {
        if (this.filterArray == null || this.filterArray.length != filters.size()) {
            this.filterArray = new ISystemFilter[filters.size()];
            Iterator i = filters.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.filterArray[idx++] = (ISystemFilter)i.next();
            }
        }
        return this.filterArray;
    }

    public ISystemFilter[] getSystemFilters(Vector filters) {
        if (filters == null) {
            return null;
        }
        if (this.filterArray == null || this.filterArray.length != filters.size()) {
            this.filterArray = new ISystemFilter[filters.size()];
            int idx = 0;
            while (idx < filters.size()) {
                this.filterArray[idx] = (ISystemFilter)filters.elementAt(idx);
                ++idx;
            }
        }
        return this.filterArray;
    }

    public int getSystemFilterCount(List filters) {
        int nbrChildren = filters == null ? 0 : filters.size();
        return nbrChildren;
    }

    public int getSystemFilterCount(Vector filters) {
        int nbrChildren = filters == null ? 0 : filters.size();
        return nbrChildren;
    }

    public boolean hasSystemFilters(List filters) {
        return filters != null && filters.size() > 0;
    }

    public boolean hasSystemFilters(Vector filters) {
        return filters != null && filters.size() > 0;
    }

    public ISystemFilter getSystemFilter(List filters, String aliasName) {
        ISystemFilter filter = null;
        ISystemFilter currFilter = null;
        Iterator i = filters.iterator();
        while (i.hasNext() && filter == null) {
            currFilter = (ISystemFilter)i.next();
            if (!currFilter.getName().equalsIgnoreCase(aliasName)) continue;
            filter = currFilter;
        }
        return filter;
    }

    public ISystemFilter getSystemFilter(Vector filters, String aliasName) {
        if (filters == null || filters.size() == 0) {
            return null;
        }
        ISystemFilter filter = null;
        ISystemFilter currFilter = null;
        int idx = 0;
        while (idx < filters.size() && filter == null) {
            currFilter = (ISystemFilter)filters.elementAt(idx);
            if (currFilter.getName().equalsIgnoreCase(aliasName)) {
                filter = currFilter;
            }
            ++idx;
        }
        return filter;
    }

    public boolean addSystemFilter(List filters, ISystemFilter filter) {
        boolean exists;
        boolean bl = exists = this.getSystemFilter(filters, filter.getName()) != null;
        if (!exists) {
            return this.internalAddSystemFilter(filters, filter);
        }
        return false;
    }

    protected boolean internalAddSystemFilter(List filters, ISystemFilter filter) {
        filters.add(filter);
        this.invalidateCache();
        return true;
    }

    public boolean addSystemFilter(Vector filters, ISystemFilter filter) {
        boolean exists;
        boolean bl = exists = this.getSystemFilter(filters, filter.getName()) != null;
        if (!exists) {
            return this.internalAddSystemFilter(filters, filter);
        }
        return false;
    }

    private boolean internalAddSystemFilter(Vector filters, ISystemFilter filter) {
        filters.add(filter);
        this.invalidateCache();
        return true;
    }

    public void deleteSystemFilter(List filters, ISystemFilter filter) {
        filters.remove(filter);
        this.invalidateCache();
    }

    public void renameSystemFilter(List filters, ISystemFilter filter, String newName) {
        filter.setName(newName);
        this.invalidateCache();
    }

    public void deleteSystemFilter(Vector filters, ISystemFilter filter) {
        filters.remove(filter);
        this.invalidateCache();
    }

    public void renameSystemFilter(Vector filters, ISystemFilter filter, String newName) {
        filter.setName(newName);
        this.invalidateCache();
    }

    public void updateSystemFilter(Vector filters, ISystemFilter filter, String newName, String[] newStrings) {
        filter.setName(newName);
        filter.setFilterStrings(newStrings);
        this.invalidateCache();
    }

    public void updateSystemFilter(List filters, ISystemFilter filter, String newName, String[] newStrings) {
        filter.setName(newName);
        filter.setFilterStrings(newStrings);
        this.invalidateCache();
    }

    public ISystemFilter cloneSystemFilter(List filters, ISystemFilter filter, String aliasName) {
        ISystemFilter copy = this.createSystemFilter(filters, filter.getParentFilterPool(), aliasName, filter.getFilterStringsVector());
        this.internalAfterCloneSystemFilter(filter, copy);
        ISystemFilter[] nested = filter.getSystemFilters();
        if (nested != null && nested.length > 0) {
            int idx = 0;
            while (idx < nested.length) {
                ++idx;
            }
        }
        return copy;
    }

    public ISystemFilter cloneSystemFilter(Vector filters, ISystemFilter filter, String aliasName) {
        ISystemFilter copy = this.createSystemFilter(filters, filter.getParentFilterPool(), aliasName, filter.getFilterStringsVector());
        this.internalAfterCloneSystemFilter(filter, copy);
        ISystemFilter[] nested = filter.getSystemFilters();
        if (nested != null && nested.length > 0) {
            int idx = 0;
            while (idx < nested.length) {
                ++idx;
            }
        }
        return copy;
    }

    public void internalAfterCloneSystemFilter(ISystemFilter oldFilter, ISystemFilter newFilter) {
        newFilter.setParentFilterPool(oldFilter.getParentFilterPool());
        newFilter.setSupportsNestedFilters(oldFilter.isSupportsNestedFilters());
        newFilter.setType(oldFilter.getType());
        newFilter.setDefault(oldFilter.isDefault());
        newFilter.setRelativeOrder(oldFilter.getRelativeOrder());
    }

    public int getSystemFilterPosition(List filters, ISystemFilter filter) {
        int position = -1;
        Iterator i = filters.iterator();
        int idx = 0;
        while (position < 0 && idx < filters.size()) {
            ISystemFilter currFilter = (ISystemFilter)i.next();
            if (currFilter.getName().equals(filter.getName())) {
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public int getSystemFilterPosition(Vector filters, ISystemFilter filter) {
        int position = -1;
        int idx = 0;
        while (position < 0 && idx < filters.size()) {
            ISystemFilter currFilter = (ISystemFilter)filters.elementAt(idx);
            if (currFilter.getName().equals(filter.getName())) {
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public void moveSystemFilter(List filters, int pos, ISystemFilter filter) {
        this.invalidateCache();
    }

    public void moveSystemFilter(Vector filters, int pos, ISystemFilter filter) {
        filters.remove(filter);
        filters.insertElementAt(filter, pos);
        this.invalidateCache();
    }
}

