/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.references.IRSEBasePersistableReferencedObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.filters.SystemFilterContainerReferenceCommonMethods;
import org.eclipse.rse.internal.references.SystemPersistableReferencingObject;
import org.eclipse.rse.model.SystemRegistry;

public class SystemFilterPoolReference
extends SystemPersistableReferencingObject
implements ISystemFilterPoolReference,
ISystemFilterContainerReference,
IAdaptable {
    private SystemFilterContainerReferenceCommonMethods containerHelper = new SystemFilterContainerReferenceCommonMethods(this);
    private ISystemFilterPoolManager filterPoolManager = null;
    public static final String DELIMITER = "___";
    public static final int DELIMITER_LENGTH = 3;

    private SystemFilterPoolReference() {
    }

    public SystemFilterPoolReference(ISystemFilterPool filterPool) {
        this();
        this.setReferenceToFilterPool(filterPool);
    }

    public SystemFilterPoolReference(ISystemFilterPoolManager filterPoolManager, String filterPoolName) {
        this();
        this.filterPoolManager = filterPoolManager;
        this.setReferencedObjectName(filterPoolName);
    }

    public ISystemFilterPoolReferenceManager getFilterPoolReferenceManager() {
        return (ISystemFilterPoolReferenceManager)this.getParentReferenceManager();
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        ISystemFilterPoolReferenceManager mgr = this.getFilterPoolReferenceManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getReferencedFilterPoolName() {
        String savedName = super.getReferencedObjectName();
        String poolName = null;
        int idx = savedName.indexOf(DELIMITER);
        poolName = idx >= 0 ? savedName.substring(idx + 3) : savedName;
        return poolName;
    }

    public String getReferencedFilterPoolManagerName() {
        String savedName = super.getReferencedObjectName();
        String mgrName = null;
        int idx = savedName.indexOf(DELIMITER);
        mgrName = idx >= 0 ? savedName.substring(0, idx) : savedName;
        return mgrName;
    }

    public void resetReferencedFilterPoolName(String newName) {
        super.setReferencedObjectName(newName);
    }

    public void setReferenceToFilterPool(ISystemFilterPool pool) {
        super.setReferencedObject((IRSEBasePersistableReferencedObject)pool);
    }

    public ISystemFilterPool getReferencedFilterPool() {
        ISystemFilterPool filterPool = (ISystemFilterPool)this.getReferencedObject();
        if (filterPool == null) {
            Pattern p;
            Matcher m;
            String filterPoolName = this.getReferencedFilterPoolName();
            filterPool = this.filterPoolManager.getSystemFilterPool(filterPoolName);
            if (filterPool == null && (m = (p = Pattern.compile("(^.*):")).matcher(filterPoolName)).find()) {
                String profileName = m.group(1);
                ISystemProfile profile = SystemRegistry.getSystemRegistry().getSystemProfile(profileName);
                if (profile != null) {
                    ISystemFilterPool[] pools = profile.getFilterPools();
                    int i = 0;
                    while (i < pools.length && filterPool == null) {
                        ISystemFilterPool pool = pools[i];
                        if (filterPoolName.equals(pool.getName())) {
                            filterPool = pool;
                        }
                        ++i;
                    }
                }
            }
            if (filterPool != null) {
                this.setReferenceToFilterPool(filterPool);
            }
        }
        this.setReferenceBroken(filterPool == null);
        return filterPool;
    }

    public ISystemFilterContainer getReferencedSystemFilterContainer() {
        return this.getReferencedFilterPool();
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        return this.containerHelper.getSystemFilterReferences(subSystem);
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.generateAndRecordFilterReference(subSystem, filter);
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return this.containerHelper.getExistingSystemFilterReference(subSystem, filter);
    }

    public boolean hasFilters() {
        return this.containerHelper.hasFilters();
    }

    public int getFilterCount() {
        return this.containerHelper.getFilterCount();
    }

    public String getName() {
        return this.getReferencedFilterPoolName();
    }

    public String getFullName() {
        return super.getReferencedObjectName();
    }

    public boolean commit() {
        return false;
    }
}

