/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public class SystemProfile
extends RSEModelObject
implements ISystemProfile,
IAdaptable {
    private ISystemProfileManager mgr;
    private boolean active;
    private String name = null;
    private boolean defaultPrivate = false;

    protected SystemProfile() {
    }

    public void setProfileManager(ISystemProfileManager mgr) {
        this.mgr = mgr;
    }

    public ISystemProfileManager getProfileManager() {
        return this.mgr;
    }

    public IHost createHost(String systemType, String connectionName, String hostName, String description) throws Exception {
        return RSEUIPlugin.getTheSystemRegistry().createHost(this.getName(), systemType, connectionName, hostName, description);
    }

    public IHost[] getHosts() {
        return RSEUIPlugin.getTheSystemRegistry().getHostsByProfile(this);
    }

    public ISystemFilterPool[] getFilterPools() {
        ISubSystemConfiguration[] ssFactories = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfigurations();
        Vector<ISystemFilterPool> poolsVector = new Vector<ISystemFilterPool>();
        int idx = 0;
        while (idx < ssFactories.length) {
            ISystemFilterPoolManager poolMgr = ssFactories[idx].getFilterPoolManager((ISystemProfile)this);
            ISystemFilterPool[] pools = poolMgr.getSystemFilterPools();
            int ydx = 0;
            while (ydx < pools.length) {
                poolsVector.add(pools[ydx]);
                ++ydx;
            }
            ++idx;
        }
        ISystemFilterPool[] allPools = new ISystemFilterPool[poolsVector.size()];
        int idx2 = 0;
        while (idx2 < allPools.length) {
            allPools[idx2] = (ISystemFilterPool)poolsVector.elementAt(idx2);
            ++idx2;
        }
        return allPools;
    }

    public ISystemFilterPool[] getFilterPools(ISubSystemConfiguration ssf) {
        ISystemFilterPoolManager poolMgr = ssf.getFilterPoolManager((ISystemProfile)this);
        return poolMgr.getSystemFilterPools();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String toString() {
        String result = this.getName();
        if (result == null) {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append("Profile(name: ");
            buf.append(this.name);
            buf.append(", defaultPrivate: ");
            buf.append(this.defaultPrivate);
            buf.append(')');
            result = buf.toString();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_PROFILE_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isDefaultPrivate() {
        return this.defaultPrivate;
    }

    public void setDefaultPrivate(boolean newDefaultPrivate) {
        this.defaultPrivate = newDefaultPrivate;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit((ISystemProfile)this);
    }
}

