/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.IRSESystemTypeConstants;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.RSEAdapter;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.osgi.framework.Bundle;

public class RSESystemTypeAdapter
extends RSEAdapter
implements IRSESystemTypeConstants {
    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor img = this.getImage(object, "icon");
        if (img == null) {
            img = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionIcon");
        }
        return img;
    }

    public ImageDescriptor getLiveImageDescriptor(Object object) {
        ImageDescriptor img = this.getImage(object, "iconLive");
        if (img == null) {
            img = this.getImage(object, "icon");
        }
        if (img == null) {
            img = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemconnectionliveIcon");
        }
        return img;
    }

    private ImageDescriptor getImage(Object object, String propertyKey) {
        if (object != null && object instanceof IRSESystemType) {
            IRSESystemType sysType = (IRSESystemType)object;
            String property = sysType.getProperty(propertyKey);
            if (property != null) {
                return RSESystemTypeAdapter.getImage(property, sysType.getDefiningBundle());
            }
            return null;
        }
        return null;
    }

    public static ImageDescriptor getImage(String value, Bundle definingBundle) {
        URL url = RSESystemTypeAdapter.getUrl(value, definingBundle);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public static URL getUrl(String value, Bundle definingBundle) {
        URL result;
        block3: {
            result = null;
            try {
                if (value != null) {
                    result = new URL(value);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (definingBundle == null) break block3;
                Path path = new Path(value);
                result = FileLocator.find((Bundle)definingBundle, (IPath)path, null);
            }
        }
        return result;
    }

    public String getLabel(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getName();
        }
        return super.getLabel(object);
    }

    public String getDescription(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getDescription();
        }
        return super.getDescription(object);
    }

    public boolean isEnableOffline(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            String property = ((IRSESystemType)object).getProperty("enableOffline");
            if (property != null) {
                return Boolean.valueOf(property);
            }
            return false;
        }
        return false;
    }

    public boolean isEnabled(Object object) {
        boolean result = false;
        IRSESystemType systemType = this.getSystemType(object);
        if (systemType != null) {
            String key;
            Preferences prefs = RSECorePlugin.getDefault().getPluginPreferences();
            if (!prefs.contains(key = this.getPreferencesKey(systemType, "systemType.enabled"))) {
                prefs.setDefault(key, true);
            }
            result = prefs.getBoolean(key);
        }
        return result;
    }

    public void setIsEnabled(Object object, boolean isEnabled) {
        IRSESystemType systemType = this.getSystemType(object);
        if (systemType != null) {
            RSECorePlugin core = RSECorePlugin.getDefault();
            Preferences prefs = core.getPluginPreferences();
            String key = this.getPreferencesKey(systemType, "systemType.enabled");
            prefs.setValue(key, isEnabled);
            core.savePluginPreferences();
        }
    }

    public String getDefaultUserId(Object object) {
        String result = null;
        IRSESystemType systemType = this.getSystemType(object);
        if (systemType != null) {
            String key;
            Preferences prefs = RSECorePlugin.getDefault().getPluginPreferences();
            if (!prefs.contains(key = this.getPreferencesKey(systemType, "systemType.defaultUserId"))) {
                prefs.setDefault(key, System.getProperty("user.name"));
            }
            result = prefs.getString(key);
        }
        return result;
    }

    public void setDefaultUserId(Object object, String defaultUserId) {
        IRSESystemType systemType = this.getSystemType(object);
        if (systemType != null) {
            RSECorePlugin core = RSECorePlugin.getDefault();
            Preferences prefs = core.getPluginPreferences();
            String key = this.getPreferencesKey(systemType, "systemType.defaultUserId");
            prefs.setValue(key, defaultUserId);
            core.savePluginPreferences();
        }
    }

    private String getPreferencesKey(IRSESystemType systemType, String preference) {
        String key = String.valueOf(systemType.getName()) + "." + preference;
        return key;
    }

    private IRSESystemType getSystemType(Object systemTypeCandidate) {
        IRSESystemType result = null;
        if (systemTypeCandidate instanceof IRSESystemType) {
            result = (IRSESystemType)systemTypeCandidate;
        }
        return result;
    }
}

