/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SystemSortableSelection
implements Comparable {
    private Object selectedObject;
    private int position;

    public SystemSortableSelection(Object selectedObject) {
        this.selectedObject = selectedObject;
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public int compareTo(Object other) {
        SystemSortableSelection otherSelectableObject = (SystemSortableSelection)other;
        int otherPosition = otherSelectableObject.getPosition();
        if (this.position < otherPosition) {
            return -1;
        }
        if (this.position == otherPosition) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SystemSortableSelection)) {
            return super.equals(other);
        }
        SystemSortableSelection otherSelectableObject = (SystemSortableSelection)other;
        int otherPosition = otherSelectableObject.getPosition();
        return this.position == otherPosition;
    }

    public static SystemSortableSelection[] makeSortableArray(IStructuredSelection selection) {
        SystemSortableSelection[] array = new SystemSortableSelection[selection.size()];
        Iterator i = selection.iterator();
        int idx = 0;
        while (i.hasNext()) {
            array[idx++] = new SystemSortableSelection(i.next());
        }
        return array;
    }

    public static void sortArray(SystemSortableSelection[] sortableArray) {
        Arrays.sort(sortableArray);
    }

    public static Object[] getSortedObjects(SystemSortableSelection[] sortedArray, Object[] outputArray) {
        int idx = 0;
        while (idx < outputArray.length) {
            outputArray[idx] = sortedArray[idx].getSelectedObject();
            ++idx;
        }
        return outputArray;
    }
}

