/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.jface.action.IAction;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.widgets.InheritableEntryField;
import org.eclipse.rse.ui.widgets.SystemHistoryCombo;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class SystemWidgetHelpers {
    public static boolean traceHelpIDs = false;
    public static Label previousLabel;
    private static char STANDARD_COLON;
    private static char WIDE_COLON;

    static {
        STANDARD_COLON = (char)58;
        WIDE_COLON = (char)65306;
    }

    public static Composite createComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize) {
        return SystemWidgetHelpers.createAlignedComposite(parent, parentSpan, numColumns, border, label, marginSize, spacingSize, 4);
    }

    public static Composite createVerticalBeginComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize) {
        return SystemWidgetHelpers.createAlignedComposite(parent, parentSpan, numColumns, border, label, marginSize, spacingSize, 2);
    }

    private static Composite createAlignedComposite(Composite parent, int parentSpan, int numColumns, boolean border, String label, int marginSize, int spacingSize, int verticalAlignment) {
        boolean borderNeeded = border;
        if (label != null) {
            borderNeeded = true;
        }
        int style = 0;
        if (borderNeeded) {
            style |= 0x10;
        }
        Group composite = null;
        if (borderNeeded) {
            composite = new Group(parent, style);
            if (label != null) {
                composite.setText(label);
            }
        } else {
            composite = new Composite(parent, style);
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (marginSize != -1) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        if (spacingSize != -1) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = parentSpan;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = verticalAlignment;
        data.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        boolean testing = false;
        if (testing) {
            return SystemWidgetHelpers.createComposite(parent, 1, numColumns, true, Integer.toString(numColumns), -1, -1);
        }
        return SystemWidgetHelpers.createComposite(parent, 1, numColumns, false, null, -1, -1);
    }

    public static Group createGroupComposite(Composite parent, int numColumns, String label) {
        return (Group)SystemWidgetHelpers.createComposite(parent, 1, numColumns, true, label, -1, -1);
    }

    public static Composite createTightComposite(Composite parent, int numColumns) {
        return SystemWidgetHelpers.createComposite(parent, 1, numColumns, false, null, 0, 0);
    }

    public static Composite createFlushComposite(Composite parent, int numColumns) {
        return SystemWidgetHelpers.createComposite(parent, 1, numColumns, false, null, 0, -1);
    }

    public static Label createRigidFillerLabel(Composite parent, int span, int widthHint) {
        Label label = new Label(parent, 0x1000000);
        label.setText(" ");
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        if (widthHint != -1) {
            data.widthHint = widthHint;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createLabel(Composite parent, String text) {
        return SystemWidgetHelpers.createLabel(parent, text, 1);
    }

    public static Label createLabel(Composite parent, String text, int span) {
        return SystemWidgetHelpers.createLabel(parent, text, span, false);
    }

    public static Label createLabel(Composite parent, String text, int span, boolean wantBorder) {
        int style = 16384;
        if (wantBorder) {
            style |= 0x800;
        }
        if (span > 1) {
            style |= 0x40;
        }
        Label label = new Label(parent, style);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createLabel(Composite parent, String text, String tooltip) {
        Label label = SystemWidgetHelpers.createLabel(parent, text);
        SystemWidgetHelpers.setToolTipText((Control)label, tooltip);
        return label;
    }

    public static Label createLabel(Composite parent, String text, String tooltip, int span, boolean wantBorder) {
        Label label = SystemWidgetHelpers.createLabel(parent, text, span, wantBorder);
        SystemWidgetHelpers.setToolTipText((Control)label, tooltip);
        return label;
    }

    public static Label createLabeledLabel(Composite parent, String label, String tooltip, boolean wantBorder) {
        previousLabel = SystemWidgetHelpers.createLabel(parent, label);
        String text = previousLabel.getText();
        previousLabel.setText(SystemWidgetHelpers.appendColon(text));
        ((GridData)SystemWidgetHelpers.previousLabel.getLayoutData()).grabExcessHorizontalSpace = false;
        Label label2 = SystemWidgetHelpers.createLabel(parent, "", 1, wantBorder);
        ((GridData)label2.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)label2.getLayoutData()).widthHint = 100;
        SystemWidgetHelpers.setToolTipText((Control)label2, tooltip);
        return label2;
    }

    public static Label getLastLabel() {
        return previousLabel;
    }

    public static void createSpacerLine(Composite parent, int columnSpan, boolean wantBorder) {
        int style = 16384;
        if (wantBorder) {
            style |= 0x801;
        }
        if (columnSpan > 1) {
            style |= 0x40;
        }
        Label label = new Label(parent, style);
        GridData data = new GridData();
        data.horizontalSpan = columnSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
    }

    public static Label createVerbiage(Composite parent, String text, int span, boolean border, int widthHint) {
        Label widget = new Label(parent, border ? 18496 : 16448);
        widget.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.widthHint = widthHint;
        data.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)data);
        return widget;
    }

    public static Label createLabeledVerbage(Composite parent, String labelText, String tooltip, int span, boolean border, int widthHint) {
        previousLabel = SystemWidgetHelpers.createLabel(parent, SystemWidgetHelpers.appendColon(labelText));
        Label verbage = SystemWidgetHelpers.createVerbiage(parent, labelText, span, border, widthHint);
        SystemWidgetHelpers.setToolTipText((Control)previousLabel, tooltip);
        SystemWidgetHelpers.setToolTipText((Control)verbage, tooltip);
        return verbage;
    }

    public static Label createCommandStatusLine(Composite parent, int horizontalSpan) {
        return SystemWidgetHelpers.createCommandStatusLine(parent, horizontalSpan, 3);
    }

    public static Label createCommandStatusLine(Composite parent, int horizontalSpan, int heightInLines) {
        Label commandSoFar = new Label(parent, 16448);
        int dx = commandSoFar.getBounds().height;
        if (dx == 0) {
            dx = 15;
        }
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.heightHint = heightInLines * dx;
        data.verticalAlignment = 2;
        commandSoFar.setLayoutData((Object)data);
        return commandSoFar;
    }

    public static Text createTextField(Composite parent, Listener listener) {
        Text text = new Text(parent, 2052);
        if (listener != null) {
            text.addListener(24, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 150;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createTextField(Composite parent, Listener listener, String toolTip) {
        Text text = SystemWidgetHelpers.createTextField(parent, listener);
        SystemWidgetHelpers.setToolTipText((Control)text, toolTip);
        return text;
    }

    public static Text createLabeledTextField(Composite parent, Listener listener, String labelText, String tooltip) {
        previousLabel = SystemWidgetHelpers.createLabel(parent, SystemWidgetHelpers.appendColon(labelText));
        Text entry = SystemWidgetHelpers.createTextField(parent, listener, tooltip);
        SystemWidgetHelpers.setToolTipText((Control)previousLabel, tooltip);
        return entry;
    }

    public static Text createReadonlyTextField(Composite parent) {
        Text text = new Text(parent, 2060);
        text.setEnabled(false);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 150;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createReadonlyTextField(Composite parent, String toolTip) {
        Text text = SystemWidgetHelpers.createReadonlyTextField(parent);
        SystemWidgetHelpers.setToolTipText((Control)text, toolTip);
        return text;
    }

    public static Text createLabeledReadonlyTextField(Composite parent, String text, String tooltip) {
        previousLabel = SystemWidgetHelpers.createLabel(parent, SystemWidgetHelpers.appendColon(text));
        Text entry = SystemWidgetHelpers.createReadonlyTextField(parent, tooltip);
        SystemWidgetHelpers.setToolTipText((Control)previousLabel, tooltip);
        return entry;
    }

    public static Text createMultiLineTextField(Composite parent, Listener listener, int heightHint) {
        Text text = new Text(parent, 2626);
        if (listener != null) {
            text.addListener(24, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = heightHint;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createMultiLineLabeledTextField(Composite parent, Listener listener, String labelString, String tooltip, int heightHint) {
        Label label = SystemWidgetHelpers.createLabel(parent, SystemWidgetHelpers.appendColon(labelString));
        Text text = SystemWidgetHelpers.createMultiLineTextField(parent, listener, heightHint);
        SystemWidgetHelpers.setToolTipText((Control)label, tooltip);
        return text;
    }

    public static Button createCheckBox(Composite group, String label, Listener listener) {
        return SystemWidgetHelpers.createCheckBox(group, 1, label, listener);
    }

    public static Button createCheckBox(Composite group, int horizontalSpan, String label, Listener listener) {
        Button button = new Button(group, 16416);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createCheckBox(Composite group, Listener listener, String label, String tooltip) {
        Button button = SystemWidgetHelpers.createCheckBox(group, label, listener);
        SystemWidgetHelpers.setToolTipText((Control)button, tooltip);
        return button;
    }

    public static Button createCheckBox(Composite group, int horizontalSpan, Listener listener, String label, String tooltip) {
        Button button = SystemWidgetHelpers.createCheckBox(group, horizontalSpan, label, listener);
        SystemWidgetHelpers.setToolTipText((Control)button, tooltip);
        return button;
    }

    public static Button createRadioButton(Composite group, String label, Listener listener) {
        Button button = new Button(group, 16400);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createRadioButton(Composite group, Listener listener, String label, String tooltip) {
        Button button = SystemWidgetHelpers.createRadioButton(group, label, listener);
        SystemWidgetHelpers.setToolTipText((Control)button, tooltip);
        return button;
    }

    public static Button createRadioButton(Composite group, Listener listener, String label) {
        Button button = SystemWidgetHelpers.createRadioButton(group, label, listener);
        return button;
    }

    public static Button createImageButton(Composite group, Image image, Listener listener) {
        Button button = new Button(group, 8);
        button.setImage(image);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createPushButton(Composite group, String label, Listener listener) {
        Button button = new Button(group, 8);
        button.setText(label);
        if (listener != null) {
            button.addListener(13, listener);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createPushButton(Composite group, String label, Listener listener, String tooltip) {
        Button button = SystemWidgetHelpers.createPushButton(group, label, listener);
        SystemWidgetHelpers.setToolTipText((Control)button, tooltip);
        return button;
    }

    public static Button createPushButton(Composite group, Listener listener, String label, String tooltip) {
        Button button = SystemWidgetHelpers.createPushButton(group, label, listener);
        SystemWidgetHelpers.setToolTipText((Control)button, tooltip);
        return button;
    }

    public static Button createBrowseButton(Composite group, Listener listener) {
        String label = SystemResources.BUTTON_BROWSE;
        return SystemWidgetHelpers.createPushButton(group, label, listener);
    }

    public static Button createBrowseButton(Composite group, Listener listener, String tooltip) {
        String label = SystemResources.BUTTON_BROWSE;
        return SystemWidgetHelpers.createPushButton(group, label, listener, tooltip);
    }

    public static List createSystemTypeListBox(Composite group, Listener listener) {
        return SystemWidgetHelpers.createSystemTypeListBox(group, listener, null);
    }

    public static List createSystemTypeListBox(Composite group, Listener listener, String[] systemTypes) {
        int i;
        String[] typeItems;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = SystemWidgetHelpers.createListBox(group, listener, false, null, SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
        String[] stringArray = typeItems = systemTypes == null ? RSECorePlugin.getDefault().getRegistry().getSystemTypeNames() : systemTypes;
        if (systemTypes == null) {
            i = 0;
            while (i < typeItems.length) {
                ISubSystemConfiguration[] configurations = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfigurationsBySystemType(typeItems[i]);
                if (configurations != null && configurations.length > 0) {
                    arrayList.add(typeItems[i]);
                }
                ++i;
            }
            systemTypes = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(systemTypes);
        }
        i = 0;
        while (i < systemTypes.length) {
            list.add(systemTypes[i]);
            ++i;
        }
        if (list.getItemCount() > 0) {
            list.select(0);
        }
        return list;
    }

    public static List createListBox(Composite group, String label, Listener listener, boolean multiSelect) {
        return SystemWidgetHelpers.createListBox(group, label, listener, multiSelect, 1);
    }

    public static List createListBox(Composite group, String label, Listener listener, boolean multiSelect, int columnSpan) {
        Composite composite_list = null;
        if (label != null) {
            composite_list = SystemWidgetHelpers.createComposite(group, 1);
            ((GridLayout)composite_list.getLayout()).marginWidth = 0;
            GridData data = new GridData();
            data.horizontalSpan = columnSpan;
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            composite_list.setLayoutData((Object)data);
            previousLabel = SystemWidgetHelpers.createLabel(composite_list, label);
        }
        int styles = 2816;
        List list = new List(composite_list != null ? composite_list : group, multiSelect ? 2 | styles : 4 | styles);
        if (listener != null) {
            list.addListener(13, listener);
        }
        GridData data = new GridData();
        data.widthHint = 100;
        data.heightHint = 150;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        return list;
    }

    public static List createListBox(Composite group, String label, Listener listener, boolean multiSelect, String tooltip) {
        List list = SystemWidgetHelpers.createListBox(group, label, listener, multiSelect);
        SystemWidgetHelpers.setToolTipText((Control)list, tooltip);
        return list;
    }

    public static List createListBox(Composite group, Listener listener, boolean multiSelect, String label, String tooltip) {
        List list = SystemWidgetHelpers.createListBox(group, label, listener, multiSelect);
        SystemWidgetHelpers.setToolTipText((Control)list, tooltip);
        return list;
    }

    public static Combo createCombo(Composite parent, Listener listener) {
        Combo combo = SystemWidgetHelpers.createCombo(parent, 4);
        if (listener != null) {
            combo.addListener(13, listener);
        }
        return combo;
    }

    private static Combo createCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 150;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public static Combo createCombo(Composite parent, Listener listener, String toolTip) {
        Combo combo = SystemWidgetHelpers.createCombo(parent, listener);
        SystemWidgetHelpers.setToolTipText((Control)combo, toolTip);
        return combo;
    }

    public static Combo createLabeledCombo(Composite parent, Listener listener, String label, String tooltip) {
        previousLabel = SystemWidgetHelpers.createLabel(parent, SystemWidgetHelpers.appendColon(label));
        Combo entry = SystemWidgetHelpers.createCombo(parent, listener, tooltip);
        SystemWidgetHelpers.setToolTipText((Control)previousLabel, tooltip);
        return entry;
    }

    public static Combo createReadonlyCombo(Composite parent, Listener listener) {
        Combo combo = SystemWidgetHelpers.createCombo(parent, 12);
        if (listener != null) {
            combo.addListener(13, listener);
        }
        return combo;
    }

    public static Combo createReadonlyCombo(Composite parent, Listener listener, String tooltip) {
        Combo combo = SystemWidgetHelpers.createReadonlyCombo(parent, listener);
        SystemWidgetHelpers.setToolTipText((Control)combo, tooltip);
        return combo;
    }

    public static Combo createLabeledReadonlyCombo(Composite parent, Listener listener, String labelText, String tooltip) {
        labelText = SystemWidgetHelpers.appendColon(labelText);
        previousLabel = SystemWidgetHelpers.createLabel(parent, labelText);
        Combo entry = SystemWidgetHelpers.createReadonlyCombo(parent, listener, tooltip);
        SystemWidgetHelpers.setToolTipText((Control)previousLabel, tooltip);
        return entry;
    }

    public static SystemHistoryCombo createHistoryCombo(Composite parent, SelectionListener listener, String historyKey, boolean readonly, String tooltip) {
        SystemHistoryCombo combo = new SystemHistoryCombo(parent, 0, historyKey, readonly);
        if (listener != null) {
            combo.addSelectionListener(listener);
        }
        boolean hasGridData = combo.getLayoutData() != null && combo.getLayoutData() instanceof GridData;
        int minwidth = 150;
        if (!hasGridData) {
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.widthHint = minwidth;
            data.verticalAlignment = 2;
            data.grabExcessVerticalSpace = false;
            combo.setLayoutData(data);
        } else {
            ((GridData)combo.getLayoutData()).horizontalAlignment = 4;
            ((GridData)combo.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)combo.getLayoutData()).widthHint = minwidth;
        }
        SystemWidgetHelpers.setToolTipText((Control)combo, tooltip);
        return combo;
    }

    public static SystemHostCombo createConnectionCombo(Composite parent, SelectionListener listener, String[] systemTypes, ISubSystemConfiguration factory, String factoryId, String factoryCategory, IHost defaultConnection, int horizontalSpan, boolean newButton) {
        SystemHostCombo combo = null;
        if (systemTypes != null) {
            combo = new SystemHostCombo(parent, 0, systemTypes, defaultConnection, newButton);
        } else if (factory != null) {
            combo = new SystemHostCombo(parent, 0, factory, defaultConnection, newButton);
        } else if (factoryId != null) {
            combo = new SystemHostCombo(parent, 0, defaultConnection, factoryId, newButton);
        } else if (factoryCategory != null) {
            combo = new SystemHostCombo(parent, 0, defaultConnection, newButton, factoryCategory);
        }
        if (listener != null) {
            combo.addSelectionListener(listener);
        }
        boolean hasGridData = combo.getLayoutData() != null && combo.getLayoutData() instanceof GridData;
        int minwidth = 250;
        if (!hasGridData) {
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.widthHint = minwidth;
            data.verticalAlignment = 2;
            data.grabExcessVerticalSpace = false;
            data.horizontalSpan = horizontalSpan;
            combo.setLayoutData(data);
        } else {
            ((GridData)combo.getLayoutData()).horizontalSpan = horizontalSpan;
            ((GridData)combo.getLayoutData()).horizontalAlignment = 4;
            ((GridData)combo.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)combo.getLayoutData()).widthHint = minwidth;
        }
        return combo;
    }

    public static Combo createSystemTypeCombo(Composite parent, Listener listener) {
        return SystemWidgetHelpers.createSystemTypeCombo(parent, listener, null);
    }

    public static Combo createSystemTypeCombo(Composite parent, Listener listener, String[] systemTypes) {
        int i;
        Combo combo = SystemWidgetHelpers.createReadonlyCombo(parent, listener, SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
        String[] typeItems = systemTypes == null ? RSECorePlugin.getDefault().getRegistry().getSystemTypeNames() : systemTypes;
        ArrayList<String> list = new ArrayList<String>();
        if (systemTypes == null) {
            i = 0;
            while (i < typeItems.length) {
                ISubSystemConfiguration[] configurations = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfigurationsBySystemType(typeItems[i]);
                if (configurations != null && configurations.length > 0) {
                    list.add(typeItems[i]);
                }
                ++i;
            }
        }
        typeItems = new String[list.size()];
        i = 0;
        while (i < list.size()) {
            typeItems[i] = (String)list.get(i);
            ++i;
        }
        combo.setItems(typeItems);
        combo.select(0);
        return combo;
    }

    public static Combo createHostNameCombo(Composite parent, Listener listener, String systemType) {
        Combo combo = SystemWidgetHelpers.createCombo(parent, listener, SystemResources.RESID_CONNECTION_HOSTNAME_TIP);
        combo.setItems(RSEUIPlugin.getTheSystemRegistry().getHostNames(systemType));
        combo.select(0);
        return combo;
    }

    public static InheritableEntryField createInheritableTextField(Composite parent, String toggleToolTip, String entryToolTip) {
        InheritableEntryField entryField = new InheritableEntryField(parent, 0);
        if (toggleToolTip != null) {
            entryField.setToggleToolTipText(toggleToolTip);
        }
        if (entryToolTip != null) {
            entryField.setTextFieldToolTipText(entryToolTip);
        }
        return entryField;
    }

    public static void lineUpPrompts(Composite composite) {
        composite.layout(true);
        Label firstLabel = SystemWidgetHelpers.getFirstColumnOneLabel(composite);
        int nbrColumns = ((GridLayout)composite.getLayout()).numColumns;
        Control[] childControls = composite.getChildren();
        int maxNestedLabelWidth = 0;
        int currColumn = 0;
        if (childControls != null && childControls.length > 0) {
            int idx = 0;
            while (idx < childControls.length) {
                Label firstNestedLabel;
                int rem = currColumn % nbrColumns;
                if ((currColumn == 0 || rem == 0) && childControls[idx] instanceof Composite && (firstNestedLabel = SystemWidgetHelpers.getFirstColumnOneLabel((Composite)childControls[idx])) != null && firstNestedLabel.getSize().x > maxNestedLabelWidth) {
                    maxNestedLabelWidth = firstNestedLabel.getSize().x;
                }
                currColumn += ((GridData)childControls[idx].getLayoutData()).horizontalSpan;
                ++idx;
            }
        }
        int columnOneWidth = 0;
        if (firstLabel != null) {
            columnOneWidth = firstLabel.getSize().x;
        }
        if (maxNestedLabelWidth > columnOneWidth) {
            columnOneWidth = maxNestedLabelWidth;
        }
        if (firstLabel != null) {
            ((GridData)firstLabel.getLayoutData()).widthHint = columnOneWidth;
        }
        currColumn = 0;
        if (childControls != null && childControls.length > 0) {
            int idx = 0;
            while (idx < childControls.length) {
                Label firstNestedLabel;
                int rem = currColumn % nbrColumns;
                if ((currColumn == 0 || rem == 0) && childControls[idx] instanceof Composite && (firstNestedLabel = SystemWidgetHelpers.getFirstColumnOneLabel((Composite)childControls[idx])) != null) {
                    ((GridData)firstNestedLabel.getLayoutData()).widthHint = columnOneWidth;
                }
                currColumn += ((GridData)childControls[idx].getLayoutData()).horizontalSpan;
                ++idx;
            }
        }
        composite.layout(true);
    }

    public static Label getFirstColumnOneLabel(Composite composite) {
        int nbrColumns = ((GridLayout)composite.getLayout()).numColumns;
        Control[] childControls = composite.getChildren();
        Label firstLabel = null;
        int currColumn = 0;
        if (childControls != null && childControls.length > 0) {
            int idx = 0;
            while (firstLabel == null && idx < childControls.length) {
                int rem = currColumn % nbrColumns;
                if ((currColumn == 0 || rem == 0) && childControls[idx] instanceof Label && (firstLabel = (Label)childControls[idx]).getText().trim().length() == 0) {
                    firstLabel = null;
                }
                currColumn += ((GridData)childControls[idx].getLayoutData()).horizontalSpan;
                ++idx;
            }
        }
        return firstLabel;
    }

    public static Mnemonics setMnemonics(Composite parent) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setMnemonics(Composite parent, boolean applyToPrecedingLabels) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setApplyMnemonicsToPrecedingLabels(applyToPrecedingLabels);
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setWizardPageMnemonics(Composite parent) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setOnWizardPage(true);
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setWizardPageMnemonics(Composite parent, boolean applyToPrecedingLabels) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setOnWizardPage(true);
        mnemonics.setApplyMnemonicsToPrecedingLabels(applyToPrecedingLabels);
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setPreferencePageMnemonics(Composite parent) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setOnPreferencePage(true);
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setPreferencePageMnemonics(Composite parent, boolean applyToPrecedingLabels) {
        Mnemonics mnemonics = new Mnemonics();
        mnemonics.setOnPreferencePage(true);
        mnemonics.setApplyMnemonicsToPrecedingLabels(applyToPrecedingLabels);
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static Mnemonics setMnemonics(Mnemonics mnemonics, Composite parent) {
        mnemonics.setMnemonics(parent);
        return mnemonics;
    }

    public static void setMnemonics(Menu menu) {
        Mnemonics mnemonics = new Mnemonics();
        MenuItem[] menuItems = menu.getItems();
        int idx = 0;
        while (idx < menuItems.length) {
            MenuItem currMenuItem = menuItems[idx];
            currMenuItem.setText(mnemonics.setUniqueMnemonic(currMenuItem.getText()));
            Menu nestedMenu = currMenuItem.getMenu();
            if (nestedMenu != null) {
                SystemWidgetHelpers.setMnemonics(nestedMenu);
            }
            ++idx;
        }
    }

    public static void setCompositeHelp(Composite parent, String helpID) {
        SystemWidgetHelpers.setHelp((Control)parent, helpID);
    }

    public static void setHelp(Control c, IViewPart view, Object id) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, id.toString());
        if (traceHelpIDs) {
            SystemBasePlugin.logInfo("Setting help id: " + id);
        }
    }

    public static void setHelp(Control c, String id) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, id);
    }

    public static void setHelp(IAction c, String id) {
        String[] ids = new String[]{id};
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, id);
    }

    public static void setHelp(MenuItem c, String id) {
        String[] ids = new String[]{id};
        PlatformUI.getWorkbench().getHelpSystem().setHelp(c, id);
    }

    public static String appendColon(String label) {
        String result = label;
        boolean append = false;
        boolean strip = false;
        Locale currentLocale = Locale.getDefault();
        String language = currentLocale.getLanguage();
        boolean cjk = language.equals("zh") || language.equals("ja") || language.equals("ko");
        int n = result.length();
        if (n > 0) {
            char lastCharacter = label.charAt(n - 1);
            if (cjk) {
                strip = lastCharacter == STANDARD_COLON;
                append = lastCharacter != WIDE_COLON;
            } else {
                strip = lastCharacter == WIDE_COLON;
                append = lastCharacter != STANDARD_COLON;
            }
        } else {
            strip = false;
            append = true;
        }
        if (strip) {
            result = result.substring(0, n - 1);
        }
        if (append) {
            result = String.valueOf(result) + (cjk ? WIDE_COLON : STANDARD_COLON);
        }
        return result;
    }

    private static void setToolTipText(Control widget, String tooltip) {
        if (tooltip != null) {
            widget.setToolTipText(tooltip);
        }
    }
}

