/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class SystemAbstractPopupMenuExtensionAction
implements IObjectActionDelegate {
    protected IWorkbenchPart viewPart = null;
    protected IStructuredSelection sel = null;
    protected IAction proxyAction;
    protected Shell shell;
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    static /* synthetic */ Class class$0;

    public abstract void run();

    public boolean getEnabled(Object[] currentlySelected) {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.viewPart = part;
        this.proxyAction = action;
        this.shell = part.getSite().getShell();
    }

    public IWorkbenchPart getActivePart() {
        return this.viewPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (!action.isEnabled()) {
            return;
        }
        if (sel instanceof IStructuredSelection) {
            this.sel = (IStructuredSelection)sel;
            action.setEnabled(this.getEnabled(this.getSelectedRemoteObjects()));
        } else {
            this.sel = null;
            action.setEnabled(false);
        }
    }

    public void setChecked(boolean checked) {
        this.proxyAction.setChecked(checked);
    }

    public void setEnabled(boolean enabled) {
        this.proxyAction.setEnabled(enabled);
    }

    public IAction getProxyAction() {
        return this.proxyAction;
    }

    public Shell getShell() {
        return this.shell;
    }

    public IStructuredSelection getSelection() {
        return this.sel;
    }

    public int getSelectionCount() {
        return this.sel == null ? 0 : this.sel.size();
    }

    public Object[] getSelectedRemoteObjects() {
        Object[] seld = new Object[this.sel != null ? this.sel.size() : 0];
        if (this.sel == null) {
            return seld;
        }
        Iterator i = this.sel.iterator();
        int idx = 0;
        while (i.hasNext()) {
            seld[idx++] = i.next();
        }
        return seld;
    }

    public Object getFirstSelectedRemoteObject() {
        if (this.sel == null) {
            return null;
        }
        return this.sel.getFirstElement();
    }

    public ISystemRemoteElementAdapter[] getSelectedRemoteObjectAdapters() {
        ISystemRemoteElementAdapter[] seld = new ISystemRemoteElementAdapter[this.sel != null ? this.sel.size() : 0];
        if (this.sel == null) {
            return seld;
        }
        Iterator i = this.sel.iterator();
        int idx = 0;
        while (i.hasNext()) {
            seld[idx++] = this.getRemoteAdapter(i.next());
        }
        return seld;
    }

    public ISystemRemoteElementAdapter getFirstSelectedRemoteObjectAdapter() {
        if (this.sel == null) {
            return null;
        }
        return this.getRemoteAdapter(this.sel.getFirstElement());
    }

    public ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public String getRemoteObjectName(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getName(obj);
    }

    public String getRemoteObjectSubSystemConfigurationId(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getSubSystemConfigurationId(obj);
    }

    public String getRemoteObjectTypeCategory(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getRemoteTypeCategory(obj);
    }

    public String getRemoteObjectType(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getRemoteType(obj);
    }

    public String getRemoteObjectSubType(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getRemoteSubType(obj);
    }

    public String getRemoteObjectSubSubType(Object obj, ISystemRemoteElementAdapter adapter) {
        return adapter.getRemoteSubSubType(obj);
    }

    public ISubSystem getSubSystem() {
        ISystemRemoteElementAdapter ra = this.getFirstSelectedRemoteObjectAdapter();
        if (ra != null) {
            return ra.getSubSystem(this.getFirstSelectedRemoteObject());
        }
        return null;
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        ISubSystem ss = this.getSubSystem();
        if (ss != null) {
            return ss.getSubSystemConfiguration();
        }
        return null;
    }

    public IHost getSystemConnection() {
        ISubSystem ss;
        IHost conn = null;
        ISystemRemoteElementAdapter ra = this.getFirstSelectedRemoteObjectAdapter();
        if (ra != null && (ss = ra.getSubSystem(this.getFirstSelectedRemoteObject())) != null) {
            conn = ss.getHost();
        }
        return conn;
    }

    public void printTest() {
        System.out.println("Testing. Number of selected objects = " + this.getSelectionCount());
        Object obj = this.getFirstSelectedRemoteObject();
        if (obj == null) {
            System.out.println("selected obj is null");
        } else {
            ISystemRemoteElementAdapter adapter = this.getRemoteAdapter(obj);
            System.out.println();
            System.out.println("REMOTE INFORMATION FOR FIRST SELECTION");
            System.out.println("--------------------------------------");
            System.out.println("Remote object name................: " + this.getRemoteObjectName(obj, adapter));
            System.out.println("Remote object subsystem factory id: " + this.getRemoteObjectSubSystemConfigurationId(obj, adapter));
            System.out.println("Remote object type category.......: " + this.getRemoteObjectTypeCategory(obj, adapter));
            System.out.println("Remote object type ...............: " + this.getRemoteObjectType(obj, adapter));
            System.out.println("Remote object subtype ............: " + this.getRemoteObjectSubType(obj, adapter));
            System.out.println("Remote object subsubtype .........: " + this.getRemoteObjectSubSubType(obj, adapter));
            System.out.println();
        }
        System.out.println();
    }
}

