/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemClearPasswordAction
extends SystemBaseAction {
    public SystemClearPasswordAction(Shell shell) {
        super(SystemResources.ACTION_CLEARPASSWORD_LABEL, SystemResources.ACTION_CLEARPASSWORD_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.setHelp("org.eclipse.rse.ui.actn0049");
    }

    public boolean checkObjectType(Object obj) {
        boolean result = false;
        if (obj instanceof ISubSystem) {
            ISubSystem subsystem = (ISubSystem)obj;
            IConnectorService cs = subsystem.getConnectorService();
            result = !cs.isConnected() && cs.isPasswordCached(true);
        }
        return result;
    }

    public void run() {
        ISubSystem ss = (ISubSystem)this.getFirstSelection();
        try {
            IConnectorService system = ss.getConnectorService();
            system.clearPasswordCache(true);
            RSEUIPlugin.getTheSystemRegistry().fireEvent(new SystemResourceChangeEvent(ss, 86, (Object)ss.getHost()));
        }
        catch (Exception exception) {}
    }
}

