/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemPropertyPageExtensionManager;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class SystemRemotePropertiesAction
extends SystemBaseAction {
    public SystemRemotePropertiesAction(Shell shell) {
        super(SystemResources.ACTION_REMOTE_PROPERTIES_LABEL, SystemResources.ACTION_REMOTE_PROPERTIES_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.properties");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        return enable;
    }

    private String getName(Object element) {
        return this.getAdapter(element).getName(element);
    }

    public boolean hasPropertyPagesFor(Object object) {
        return this.getOurPropertyPageManager().hasContributorsFor(this.getRemoteAdapter(object), object);
    }

    private SystemPropertyPageExtensionManager getOurPropertyPageManager() {
        return SystemPropertyPageExtensionManager.getManager();
    }

    public boolean isApplicableForSelection() {
        return this.hasPropertyPagesFor(this.getFirstSelection());
    }

    public void run() {
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        IAdaptable element = (IAdaptable)this.getFirstSelection();
        if (element == null) {
            return;
        }
        ISystemRemoteElementAdapter adapter = this.getRemoteAdapter(element);
        if (adapter == null) {
            return;
        }
        this.getOurPropertyPageManager().contribute(pageManager, this.getRemoteAdapter(element), element);
        Shell shell = this.getShell();
        Iterator pages = pageManager.getElements(0).iterator();
        String name = this.getName(element);
        if (!pages.hasNext()) {
            MessageDialog.openInformation((Shell)shell, (String)GenericMessages.PropertyDialog_messageTitle, (String)MessageFormat.format(GenericMessages.PropertyDialog_noPropertyMessage, name));
            return;
        }
        title = MessageFormat.format(GenericMessages.PropertyDialog_propertyMessage, name);
        PropertyDialog propertyDialog = new PropertyDialog(shell, (PreferenceManager)pageManager, (ISelection)this.getSelection());
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        String id = "org.eclipse.ui.property_dialog_context";
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), id);
        propertyDialog.open();
    }
}

