/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.SystemView;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemViewExpandToBaseAction
extends SystemBaseAction {
    public SystemViewExpandToBaseAction(String label, String tooltip, ImageDescriptor image, Shell parent) {
        super(label, tooltip, image, parent);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.expandto");
        this.setChecked(false);
    }

    public boolean checkObjectType(Object selectedObject) {
        SystemView sv = this.getSystemView();
        if (sv == null) {
            return false;
        }
        String currentFilter = sv.getExpandToFilter(selectedObject);
        String thisFilter = this.getFilterString(selectedObject);
        if (currentFilter != null) {
            if (thisFilter != null && currentFilter.equals(thisFilter)) {
                this.setChecked(true);
            }
        } else if (thisFilter == null) {
            this.setChecked(true);
        }
        return true;
    }

    public void run() {
        Object element = this.getFirstSelection();
        if (element != null) {
            SystemView view = (SystemView)this.getCurrentTreeView();
            view.expandTo(this.getFilterString(element));
        }
    }

    protected abstract String getFilterString(Object var1);

    protected SystemView getSystemView() {
        ISystemTree tree = this.getCurrentTreeView();
        if (tree instanceof SystemView && ((SystemView)tree).getSystemViewPart() != null) {
            return (SystemView)tree;
        }
        return null;
    }
}

