/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.List;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SystemPasswordPersistencePrompt
extends SystemPromptDialog
implements ModifyListener {
    private Text hostname;
    private Text userid;
    private Text password;
    private Text passwordVerify;
    private Combo systemType;
    private SystemSignonInformation signonInfo;
    private boolean change;
    private String originalHostname;
    private String originalUserid;
    private String originalSystemType;
    private List existingEntries;

    public SystemPasswordPersistencePrompt(Shell shell, String title, List existingEntries, boolean change) {
        super(shell, title);
        this.change = change;
        this.existingEntries = existingEntries;
        this.setInitialOKButtonEnabledState(false);
    }

    protected Control createInner(Composite parent) {
        Composite page = SystemWidgetHelpers.createComposite(parent, 2);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_PREF_SIGNON_HOSTNAME_LABEL);
        this.hostname = SystemWidgetHelpers.createTextField(page, null, SystemResources.RESID_PREF_SIGNON_HOSTNAME_TOOLTIP);
        if (this.originalHostname != null) {
            this.hostname.setText(this.originalHostname);
        }
        this.hostname.addModifyListener((ModifyListener)this);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_PREF_SIGNON_SYSTYPE_LABEL, SystemResources.RESID_PREF_SIGNON_SYSTYPE_TOOLTIP);
        this.systemType = SystemWidgetHelpers.createReadonlyCombo(page, null);
        this.systemType.setItems(PasswordPersistenceManager.getInstance().getRegisteredSystemTypes());
        if (this.originalSystemType != null) {
            this.systemType.setText(this.originalSystemType);
        }
        this.systemType.addModifyListener((ModifyListener)this);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_PREF_SIGNON_USERID_LABEL);
        this.userid = SystemWidgetHelpers.createTextField(page, null, SystemResources.RESID_PREF_SIGNON_USERID_TOOLTIP);
        if (this.originalUserid != null) {
            this.userid.setText(this.originalUserid);
        }
        this.userid.addModifyListener((ModifyListener)this);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_PREF_SIGNON_PASSWORD_LABEL);
        this.password = SystemWidgetHelpers.createTextField(page, null, SystemResources.RESID_PREF_SIGNON_PASSWORD_TOOLTIP);
        this.password.setEchoChar('*');
        this.password.addModifyListener((ModifyListener)this);
        SystemWidgetHelpers.createLabel(page, SystemResources.RESID_PREF_SIGNON_PASSWORD_VERIFY_LABEL);
        this.passwordVerify = SystemWidgetHelpers.createTextField(page, null, SystemResources.RESID_PREF_SIGNON_PASSWORD_TOOLTIP);
        this.passwordVerify.setEchoChar('*');
        this.passwordVerify.addModifyListener((ModifyListener)this);
        return page;
    }

    protected Control getInitialFocusControl() {
        return this.hostname;
    }

    public SystemSignonInformation getSignonInformation() {
        return this.signonInfo;
    }

    protected boolean processOK() {
        String sHostName = this.hostname.getText();
        if (sHostName == null || sHostName.trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.okButton.setEnabled(false);
            this.hostname.setFocus();
            return false;
        }
        String sSystemType = this.systemType.getText();
        if (sSystemType == null || sSystemType.trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.okButton.setEnabled(false);
            this.systemType.setFocus();
            return false;
        }
        String sUserID = this.userid.getText();
        if (sUserID == null || sUserID.trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.okButton.setEnabled(false);
            this.userid.setFocus();
            return false;
        }
        String sPwd1 = this.password.getText();
        if (sPwd1 == null || sPwd1.trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.okButton.setEnabled(false);
            this.password.setFocus();
            return false;
        }
        String sPwd2 = this.passwordVerify.getText();
        if (sPwd2 == null || sPwd2.trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.okButton.setEnabled(false);
            this.passwordVerify.setFocus();
            return false;
        }
        if (!sPwd1.equals(sPwd2)) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2102"));
            this.okButton.setEnabled(false);
            this.password.setFocus();
            this.password.setSelection(0, sPwd1.length());
            return false;
        }
        this.signonInfo = new SystemSignonInformation(this.hostname.getText(), this.userid.getText(), this.password.getText(), this.systemType.getText());
        if (this.change) {
            if (!(!this.exists(this.signonInfo.getHostname(), this.signonInfo.getUserid(), this.signonInfo.getSystemType()) || this.signonInfo.getSystemType().equals(this.originalSystemType) && this.signonInfo.getHostname().equalsIgnoreCase(this.originalHostname) && this.signonInfo.getUserid().equals(this.originalUserid))) {
                SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC2101");
                msg.makeSubstitution((Object)sUserID, (Object)sHostName);
                this.setErrorMessage(msg);
                this.okButton.setEnabled(false);
                this.hostname.setFocus();
                return false;
            }
        } else if (this.exists(this.signonInfo.getHostname(), this.signonInfo.getUserid(), this.signonInfo.getSystemType())) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC2101");
            msg.makeSubstitution((Object)sUserID, (Object)sHostName);
            this.setErrorMessage(msg);
            this.okButton.setEnabled(false);
            this.hostname.setFocus();
            return false;
        }
        return super.processOK();
    }

    private boolean exists(String hostname, String userID, String systemType) {
        PasswordPersistenceManager manager = PasswordPersistenceManager.getInstance();
        boolean found = false;
        int i = 0;
        while (!found && i < this.existingEntries.size()) {
            SystemSignonInformation info = (SystemSignonInformation)this.existingEntries.get(i);
            if (hostname.equalsIgnoreCase(info.getHostname()) && systemType.equals(info.getSystemType())) {
                found = !manager.isUserIDCaseSensitive(info.getSystemType()) ? userID.equalsIgnoreCase(info.getUserid()) : userID.equals(info.getUserid());
            }
            ++i;
        }
        return found;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.change) {
            SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.pwdi0002");
            this.password.setFocus();
        } else {
            SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.pwdi0001");
            this.hostname.setFocus();
        }
    }

    public void setInputData(String systemtype, String hostname, String userid) {
        this.originalSystemType = systemtype;
        this.originalHostname = hostname;
        this.originalUserid = userid;
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.hostname && this.hostname.getText().trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.hostname.setFocus();
            this.okButton.setEnabled(false);
        } else if (e.getSource() == this.userid && this.userid.getText().trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.userid.setFocus();
            this.okButton.setEnabled(false);
        } else if (e.getSource() == this.systemType && this.systemType.getText().trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.systemType.setFocus();
            this.okButton.setEnabled(false);
        } else if (e.getSource() == this.password && this.password.getText().trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.password.setFocus();
            this.okButton.setEnabled(false);
        } else if (e.getSource() == this.passwordVerify && this.passwordVerify.getText().trim().equals("")) {
            this.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEC2103"));
            this.passwordVerify.setFocus();
            this.okButton.setEnabled(false);
        } else {
            this.clearErrorMessage();
            if (this.hostname.getText().trim().equals("") || this.userid.getText().trim().equals("") || this.systemType.getText().trim().equals("") || this.password.getText().trim().equals("") || this.passwordVerify.getText().trim().equals("")) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    public int open() {
        return super.open();
    }
}

