/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.view.SystemTestFilterStringAPIProviderImpl;
import org.eclipse.rse.ui.view.SystemViewForm;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SystemTestFilterStringDialog
extends SystemPromptDialog
implements ISelectionChangedListener,
SelectionListener {
    protected ISubSystem subsystem = null;
    protected ISystemRegistry sr = null;
    protected String subsystemFactoryId = null;
    protected String filterString = null;
    protected SystemTestFilterStringAPIProviderImpl inputProvider = null;
    protected Label prompt;
    protected Label promptValue;
    protected SystemViewForm tree;
    protected SystemHostCombo connectionCombo;

    public SystemTestFilterStringDialog(Shell shell, ISubSystem subsystem, String filterString) {
        this(shell, SystemResources.RESID_TESTFILTERSTRING_TITLE, subsystem, filterString);
    }

    public SystemTestFilterStringDialog(Shell shell, String title, ISubSystem subsystem, String filterString) {
        super(shell, title);
        this.setCancelButtonLabel(SystemResources.BUTTON_CLOSE);
        this.setShowOkButton(false);
        this.setBlockOnOpen(true);
        this.subsystem = subsystem;
        this.filterString = filterString;
        this.subsystemFactoryId = subsystem.getSubSystemConfiguration().getId();
        this.sr = RSEUIPlugin.getTheSystemRegistry();
        this.setNeedsProgressMonitor(true);
    }

    protected Control getInitialFocusControl() {
        return this.connectionCombo.getCombo();
    }

    protected Control createInner(Composite parent) {
        int gridColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, gridColumns);
        SystemHostCombo promptComposite = this.connectionCombo = SystemWidgetHelpers.createConnectionCombo(composite_prompts, null, null, this.subsystem.getSubSystemConfiguration(), null, null, this.subsystem.getHost(), gridColumns, false);
        this.prompt = SystemWidgetHelpers.createLabel((Composite)promptComposite, SystemResources.RESID_TESTFILTERSTRING_PROMPT_LABEL, SystemResources.RESID_TESTFILTERSTRING_PROMPT_TOOLTIP);
        this.promptValue = SystemWidgetHelpers.createLabel((Composite)promptComposite, SystemResources.RESID_TESTFILTERSTRING_PROMPT_LABEL, SystemResources.RESID_TESTFILTERSTRING_PROMPT_TOOLTIP);
        this.promptValue.setToolTipText(this.filterString);
        String label = this.filterString;
        if (label.length() > 30) {
            label = String.valueOf(label.substring(0, 30)) + " ...";
        }
        this.promptValue.setText(label);
        GridData data = new GridData();
        data.widthHint = 200;
        this.promptValue.setLayoutData((Object)data);
        this.inputProvider = new SystemTestFilterStringAPIProviderImpl(this.subsystem, this.filterString);
        this.tree = new SystemViewForm(this.getShell(), composite_prompts, 0, this.inputProvider, false, this.getMessageLine(), gridColumns, 1);
        this.connectionCombo.addSelectionListener(this);
        return composite_prompts;
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
    }

    public void reset(ISubSystem subsystem, String filterString) {
        this.subsystem = subsystem;
        this.filterString = filterString;
        this.inputProvider.setSubSystem(subsystem);
        this.inputProvider.setFilterString(filterString);
        this.tree.reset(this.inputProvider);
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        IHost newConnection = this.connectionCombo.getHost();
        ISubSystem[] newSubSystems = this.sr.getSubSystems(this.subsystemFactoryId, newConnection);
        ISubSystem newSubSystem = null;
        if (newSubSystems != null && newSubSystems.length > 0) {
            newSubSystem = newSubSystems[0];
            this.subsystemFactoryId = this.subsystem.getSubSystemConfiguration().getId();
        }
        this.inputProvider.setSubSystem(newSubSystem);
        this.tree.reset(this.inputProvider);
    }
}

