/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.dialogs.SystemSimpleSelectDialog;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogInterface;
import org.eclipse.rse.ui.filters.SystemFilterUIHelpers;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterSelectFilterPoolsAction
extends SystemFilterAbstractFilterPoolAction {
    public SystemFilterSelectFilterPoolsAction(Shell parent) {
        super(parent, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.selectpoolIcon"), SystemResources.ACTION_SELECTFILTERPOOLS_LABEL, SystemResources.ACTION_SELECTFILTERPOOLS_TOOLTIP);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.actn0043");
        this.setDialogHelp("org.eclipse.rse.ui.dsfp0000");
    }

    public SystemFilterSelectFilterPoolsAction(Shell parent, String title) {
        super(parent, title);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.actn0043");
        this.setDialogHelp("org.eclipse.rse.ui.dsfp0000");
    }

    public SystemFilterSelectFilterPoolsAction(Shell parent, String title, String tooltip) {
        super(parent, title, tooltip);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.actn0043");
        this.setDialogHelp("org.eclipse.rse.ui.dsfp0000");
    }

    protected void init() {
        super.init();
        this.dlgInputs.prompt = SystemResources.RESID_SELECTFILTERPOOLS_PROMPT;
        this.dlgInputs.title = SystemResources.RESID_SELECTFILTERPOOLS_TITLE;
    }

    protected Dialog createDialog(Shell parent) {
        SystemSimpleContentElement initialElementSelection;
        ISystemFilterPoolManager initialSelection;
        SystemSimpleSelectDialog dialog = new SystemSimpleSelectDialog(parent, this.getDialogTitle(), this.getDialogPrompt());
        ISystemFilterPoolManager[] mgrs = this.getFilterPoolManagers();
        ISystemFilterPoolReferenceManagerProvider sprmp = this.getReferenceManagerProviderSelection();
        ISystemFilterPoolManager[] additionalMgrs = null;
        if (sprmp != null) {
            additionalMgrs = sprmp.getSystemFilterPoolReferenceManager().getAdditionalSystemFilterPoolManagers();
        }
        if (additionalMgrs != null) {
            ISystemFilterPoolManager[] allmgrs = new ISystemFilterPoolManager[mgrs.length + additionalMgrs.length];
            int allidx = 0;
            int idx = 0;
            while (idx < mgrs.length) {
                allmgrs[allidx++] = mgrs[idx];
                ++idx;
            }
            idx = 0;
            while (idx < additionalMgrs.length) {
                allmgrs[allidx++] = additionalMgrs[idx];
                ++idx;
            }
            mgrs = allmgrs;
        }
        SystemSimpleContentElement input = SystemFilterUIHelpers.getFilterPoolModel(this.getFilterPoolManagerProvider(), mgrs);
        this.preSelect(input);
        this.setValue(input);
        if (sprmp != null && (initialSelection = sprmp.getSystemFilterPoolReferenceManager().getDefaultSystemFilterPoolManager()) != null && (initialElementSelection = SystemFilterUIHelpers.getDataElement(input, initialSelection)) != null) {
            dialog.setRootToPreselect(initialElementSelection);
        }
        return dialog;
    }

    public SystemFilterPoolDialogInterface createFilterPoolDialog(Shell parent) {
        return null;
    }

    protected void preSelect(SystemSimpleContentElement inputElement) {
        super.preSelect(inputElement);
    }

    protected boolean getFilterPoolPreSelection(ISystemFilterPool pool) {
        ISystemFilterPoolReferenceManagerProvider refMgrProvider = this.getReferenceManagerProviderSelection();
        if (refMgrProvider != null) {
            ISystemFilterPoolReferenceManager refMgr = refMgrProvider.getSystemFilterPoolReferenceManager();
            if (refMgr != null) {
                return refMgr.isSystemFilterPoolReferenced(pool);
            }
            return false;
        }
        return false;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemSimpleSelectDialog dialog = (SystemSimpleSelectDialog)dlg;
        if (!dialog.wasCancelled()) {
            Vector<Object> selectedFilterPools = new Vector<Object>();
            SystemSimpleContentElement inputElement = dialog.getUpdatedContent();
            SystemSimpleContentElement[] mgrElements = inputElement.getChildren();
            int idx = 0;
            while (idx < mgrElements.length) {
                SystemSimpleContentElement[] poolElements = mgrElements[idx].getChildren();
                int jdx = 0;
                while (jdx < poolElements.length) {
                    if (poolElements[jdx].isSelected()) {
                        selectedFilterPools.addElement(poolElements[jdx].getData());
                    }
                    ++jdx;
                }
                ++idx;
            }
            ISystemFilterPool[] selectedPoolArray = new ISystemFilterPool[selectedFilterPools.size()];
            int idx2 = 0;
            while (idx2 < selectedFilterPools.size()) {
                selectedPoolArray[idx2] = (ISystemFilterPool)selectedFilterPools.elementAt(idx2);
                ++idx2;
            }
            return selectedPoolArray;
        }
        return null;
    }

    public void doOKprocessing(Object dlgOutput) {
        ISystemFilterPool[] selectedPools = (ISystemFilterPool[])dlgOutput;
        ISystemFilterPoolReferenceManagerProvider sfprmp = this.getReferenceManagerProviderSelection();
        if (sfprmp != null) {
            sfprmp.getSystemFilterPoolReferenceManager().setSystemFilterPoolReferences(selectedPools, true);
        }
    }
}

