/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

public class SystemDialogPageMessageLine
implements ISystemMessageLine,
MouseListener {
    private Label msgTextLabel;
    private Label msgIconLabel;
    private CLabel msgIconCLabel;
    private DialogPage dlgPage;
    private SystemMessage sysErrorMessage;
    private SystemMessage sysMessage;
    private boolean stringErrorMessageShowing = false;

    public static SystemDialogPageMessageLine createWizardMsgLine(WizardPage wizardPage) {
        SystemDialogPageMessageLine msgLine = null;
        Composite pageContainer = wizardPage.getControl().getParent();
        Object pageContainerData = null;
        if (pageContainerData == null) {
            Composite dialogAreaComposite = pageContainer.getParent();
            Composite workAreaComposite = dialogAreaComposite.getParent();
            Composite mainComposite = workAreaComposite.getParent();
            Control[] list = mainComposite.getChildren();
            Label msgImageLabel = null;
            Label msgLabel = null;
            if (list[2] instanceof Label) {
                msgImageLabel = (Label)list[2];
            }
            if (list[3] instanceof Label) {
                msgLabel = (Label)list[3];
            } else if (list[4] instanceof Label) {
                msgLabel = (Label)list[4];
            }
            msgLine = new SystemDialogPageMessageLine((DialogPage)wizardPage, msgImageLabel, msgLabel);
            pageContainer.setData((Object)msgLine);
        } else {
            msgLine = pageContainerData;
        }
        return msgLine;
    }

    public static SystemDialogPageMessageLine createPropertyPageMsgLine(PropertyPage propertyPage) {
        SystemDialogPageMessageLine msgLine = null;
        Composite pageContainer = propertyPage.getControl().getParent();
        Composite dialogAreaComposite = pageContainer.getParent();
        Composite titleAreaParentComposite = (Composite)dialogAreaComposite.getChildren()[1];
        Composite titleAreaComposite = (Composite)titleAreaParentComposite.getChildren()[0];
        Composite listContainer = (Composite)titleAreaComposite.getChildren()[0];
        Control[] list = listContainer.getChildren();
        Label label1 = null;
        Label label2 = null;
        if (list.length > 0) {
            label1 = (Label)list[0];
            label2 = (Label)list[1];
        }
        msgLine = new SystemDialogPageMessageLine((DialogPage)propertyPage, label1, label2);
        pageContainer.setData((Object)msgLine);
        return msgLine;
    }

    private SystemDialogPageMessageLine(DialogPage dialogPage, Label msgIconLabel, Label msgTextLabel) {
        this.msgIconLabel = msgIconLabel;
        this.msgTextLabel = msgTextLabel;
        this.dlgPage = dialogPage;
        msgIconLabel.addMouseListener((MouseListener)this);
        msgTextLabel.addMouseListener((MouseListener)this);
    }

    protected SystemMessage getSysErrorMessage() {
        return this.sysErrorMessage;
    }

    protected SystemMessage getSysMessage() {
        return this.sysMessage;
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void clearErrorMessage() {
        this.sysErrorMessage = null;
        this.stringErrorMessageShowing = false;
        this.dlgPage.setErrorMessage(null);
        this.setIconToolTipText();
    }

    public void clearMessage() {
        this.dlgPage.setMessage(null);
        this.sysMessage = null;
        this.setIconToolTipText();
    }

    public String getErrorMessage() {
        return this.dlgPage.getErrorMessage();
    }

    public String getMessage() {
        return this.dlgPage.getMessage();
    }

    public void setErrorMessage(String emessage) {
        this.internalSetErrorMessage(emessage);
    }

    public void setErrorMessage(SystemMessage emessage) {
        if (emessage == null) {
            this.clearErrorMessage();
        } else {
            this.dlgPage.setErrorMessage(this.getMessageText(emessage));
            this.stringErrorMessageShowing = false;
            this.sysErrorMessage = emessage;
            this.logMessage(emessage);
        }
        this.setIconToolTipText();
    }

    public void setErrorMessage(Throwable exc) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEF8002");
        msg.makeSubstitution((Object)exc);
        this.setErrorMessage(msg);
    }

    public void setMessage(String msg) {
        this.internalSetMessage(msg);
        this.dlgPage.setMessage(msg);
    }

    public void setMessage(SystemMessage smessage) {
        if (smessage == null) {
            this.clearMessage();
            return;
        }
        this.sysMessage = smessage;
        int msgType = 0;
        if (smessage.getIndicator() == 'E' || smessage.getIndicator() == 'U') {
            msgType = 3;
        } else if (smessage.getIndicator() == 'W') {
            msgType = 2;
        } else if (smessage.getIndicator() == 'I' || smessage.getIndicator() == 'C') {
            msgType = 1;
        }
        this.dlgPage.setMessage(this.getMessageText(smessage), msgType);
        this.logMessage(smessage);
        this.setIconToolTipText();
    }

    private void logMessage(SystemMessage message) {
        Object[] subList = message.getSubVariables();
        int i = 0;
        while (subList != null && i < subList.length) {
            String msg = String.valueOf(message.getFullMessageID()) + ": SUB#" + new Integer(i).toString() + ":" + message.getSubValue(subList[i]);
            if (message.getIndicator() == 'I' || message.getIndicator() == 'Q' || message.getIndicator() == 'C') {
                SystemBasePlugin.logInfo(msg);
            } else if (message.getIndicator() == 'W') {
                SystemBasePlugin.logWarning(msg);
            } else if (message.getIndicator() == 'E') {
                SystemBasePlugin.logError(msg, null);
            } else if (message.getIndicator() == 'U') {
                if (i == subList.length - 1) {
                    SystemBasePlugin.logError(msg, new Exception());
                } else {
                    SystemBasePlugin.logError(msg, null);
                }
            }
            ++i;
        }
        if (subList == null) {
            String msg = message.getFullMessageID();
            if (message.getIndicator() == 'I' || message.getIndicator() == 'Q' || message.getIndicator() == 'C') {
                SystemBasePlugin.logInfo(msg);
            } else if (message.getIndicator() == 'W') {
                SystemBasePlugin.logWarning(msg);
            } else if (message.getIndicator() == 'E') {
                SystemBasePlugin.logError(msg, null);
            } else if (message.getIndicator() == 'U') {
                SystemBasePlugin.logError(msg, new Exception());
            }
        }
    }

    public void internalSetMessage(String msg) {
        this.sysMessage = null;
        this.setIconToolTipText();
    }

    public void internalSetErrorMessage(String msg) {
        this.sysErrorMessage = null;
        this.stringErrorMessageShowing = msg != null;
        this.setIconToolTipText();
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
        this.displayMessageDialog();
    }

    public SystemMessage getCurrentMessage() {
        if (this.sysErrorMessage != null) {
            return this.sysErrorMessage;
        }
        if (!this.stringErrorMessageShowing) {
            return this.sysMessage;
        }
        return null;
    }

    private void displayMessageDialog() {
        SystemMessage currentMessage = this.getCurrentMessage();
        if (currentMessage != null) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.dlgPage.getShell(), currentMessage);
            msgDlg.openWithDetails();
        }
    }

    private void setIconToolTipText() {
        SystemMessage msg = this.getCurrentMessage();
        String tip = "";
        if (msg != null) {
            tip = String.valueOf(msg.getFullMessageID()) + " " + SystemResources.RESID_MSGLINE_TIP;
        }
        if (this.msgIconLabel != null) {
            this.msgIconLabel.setToolTipText(tip);
        }
        if (this.msgTextLabel != null) {
            this.msgTextLabel.setToolTipText(tip);
        } else {
            this.msgIconCLabel.setToolTipText(tip);
        }
    }

    private String getMessageText(SystemMessage msg) {
        return msg.getLevelOneText();
    }
}

