/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class SystemMessageStatus
implements IStatus {
    private SystemMessage message;
    private SystemMessageException exception;

    public SystemMessageStatus(SystemMessage message) {
        this.message = message;
    }

    public SystemMessageStatus(SystemMessageException exception) {
        this.message = exception.getSystemMessage();
        this.exception = exception;
    }

    public boolean isOK() {
        int severity = this.getSeverity();
        return severity <= 0;
    }

    public String getPlugin() {
        String id = SystemBasePlugin.getBaseDefault().getBundle().getSymbolicName();
        return id;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        String codeString = this.message.getMessageNumber();
        int code = 0;
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException numberFormatException) {}
        return code;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message.getLevelOneText();
    }

    public int getSeverity() {
        char ind = this.message.getIndicator();
        switch (ind) {
            case 'C': {
                return 0;
            }
            case 'I': {
                return 1;
            }
            case 'Q': {
                return 1;
            }
            case 'W': {
                return 2;
            }
            case 'U': {
                return 2;
            }
            case 'E': {
                return 4;
            }
        }
        return 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean matches(int severityMask) {
        int severity = this.getSeverity();
        int matching = severity & severityMask;
        return matching > 0;
    }

    public SystemMessage getSystemMessage() {
        return this.message;
    }
}

