/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.open;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.ui.open.ISystemQuickOpenPage;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Bundle;

public class SystemQuickOpenPageDescriptor
implements Comparable {
    public static final String PAGE_TAG = "page";
    private static final String ID_ATTRIBUTE = "id";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String SIZE_ATTRIBUTE = "sizeHint";
    private static final String TAB_POSITION_ATTRIBUTE = "tabPosition";
    public static final Point UNKNOWN_SIZE = new Point(-1, -1);
    private IConfigurationElement element;

    public SystemQuickOpenPageDescriptor(IConfigurationElement element) {
        this.element = element;
    }

    public ISystemQuickOpenPage createObject() {
        ISystemQuickOpenPage result = null;
        try {
            result = (ISystemQuickOpenPage)this.element.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            SystemBasePlugin.logError("Error trying to create a quick open page from configuration element", e);
            return null;
        }
        catch (ClassCastException e) {
            SystemBasePlugin.logError("Error trying to create a quick open page from configuration element", e);
            return null;
        }
        if (result != null) {
            result.setTitle(this.getLabel());
        }
        return result;
    }

    public String getId() {
        return this.element.getAttribute(ID_ATTRIBUTE);
    }

    public String getLabel() {
        return this.element.getAttribute(LABEL_ATTRIBUTE);
    }

    public ImageDescriptor getImage() {
        String imageName = this.element.getAttribute(ICON_ATTRIBUTE);
        if (imageName == null) {
            return null;
        }
        URL url = null;
        try {
            String nameSpace = this.element.getDeclaringExtension().getNamespace();
            Bundle bundle = Platform.getBundle((String)nameSpace);
            url = new URL(bundle.getEntry("/"), imageName);
        }
        catch (MalformedURLException e) {
            SystemBasePlugin.logError("Error trying to get image", e);
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Point getPreferredSize() {
        return StringConverter.asPoint((String)this.element.getAttribute(SIZE_ATTRIBUTE), (Point)UNKNOWN_SIZE);
    }

    public int getTabPosition() {
        int position = 0x3FFFFFFF;
        String str = this.element.getAttribute(TAB_POSITION_ATTRIBUTE);
        if (str != null) {
            try {
                position = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                SystemBasePlugin.logError("Error trying to get tab position", e);
            }
        }
        return position;
    }

    public boolean isEnabled() {
        return true;
    }

    public int compareTo(Object o) {
        int myPos = this.getTabPosition();
        int objsPos = ((SystemQuickOpenPageDescriptor)o).getTabPosition();
        if (myPos == Integer.MAX_VALUE && objsPos == Integer.MAX_VALUE || myPos == objsPos) {
            return this.getLabel().compareTo(((SystemQuickOpenPageDescriptor)o).getLabel());
        }
        return myPos - objsPos;
    }
}

