/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.ISystemConnectionWizardPropertyPage;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.widgets.ServerConnectionSecurityForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ServerConnectionSecurityPropertyPage
extends SystemBasePropertyPage
implements ISystemConnectionWizardPropertyPage {
    private ServerConnectionSecurityForm _form;

    protected Control createContentArea(Composite parent) {
        this._form = new ServerConnectionSecurityForm(this.getShell(), this.getMessageLine());
        this._form.createContents(parent);
        this.initialize();
        SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.ssls0001");
        return parent;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    private void initialize() {
        IPreferenceStore prefStore = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean alertSSL = prefStore.getBoolean("org.eclipse.rse.preferences.alert.ssl");
        boolean alertNonSSL = prefStore.getBoolean("org.eclipse.rse.preferences.alert.nonssl");
        this._form.setAlertSSL(alertSSL);
        this._form.setAlertNonSSL(alertNonSSL);
        boolean hasProvider = SystemKeystoreProviderManager.getInstance().hasProvider();
        if (!hasProvider) {
            this._form.disable();
        } else {
            this._form.enable();
        }
    }

    public boolean performOk() {
        IAdaptable subsystem = this.getElement();
        if (subsystem instanceof ISubSystem) {
            return this.applyValues(((ISubSystem)subsystem).getConnectorService());
        }
        return true;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
    }

    public boolean applyValues(IConnectorService connectorService) {
        boolean alertSSL = this._form.getAlertSSL();
        boolean alertNonSSL = this._form.getAlertNonSSL();
        IPreferenceStore prefStore = RSEUIPlugin.getDefault().getPreferenceStore();
        prefStore.setValue("org.eclipse.rse.preferences.alert.ssl", alertSSL);
        prefStore.setValue("org.eclipse.rse.preferences.alert.nonssl", alertNonSSL);
        return true;
    }

    public void setHostname(String name) {
    }

    public void setSystemType(String systemType) {
    }
}

