/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemViewInputProvider;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;

public class SystemTestFilterStringAPIProviderImpl
extends SystemAbstractAPIProvider
implements ISystemViewInputProvider {
    protected String filterString = null;
    protected ISubSystem subsystem = null;
    protected Object[] emptyList = new Object[0];
    protected Object[] msgList = new Object[1];
    protected SystemMessageObject nullObject = null;
    protected SystemMessageObject canceledObject = null;
    protected SystemMessageObject errorObject = null;

    public SystemTestFilterStringAPIProviderImpl(ISubSystem subsystem, String filterString) {
        this.subsystem = subsystem;
        this.filterString = filterString;
    }

    private void initMsgObjects() {
        this.nullObject = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1100"), 3, null);
        this.canceledObject = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1101"), 1, null);
        this.errorObject = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, null);
    }

    public void setSubSystem(ISubSystem subsystem) {
        this.subsystem = subsystem;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public Object[] getSystemViewRoots() {
        Object[] children = this.emptyList;
        if (this.subsystem == null) {
            return children;
        }
        try {
            children = this.subsystem.resolveFilterString(this.filterString);
            if (children == null || children.length == 0) {
                if (this.nullObject == null) {
                    this.initMsgObjects();
                }
                this.msgList[0] = this.nullObject;
                children = this.msgList;
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.canceledObject == null) {
                this.initMsgObjects();
            }
            this.msgList[0] = this.canceledObject;
            children = this.msgList;
        }
        catch (Exception exc) {
            if (this.errorObject == null) {
                this.initMsgObjects();
            }
            this.msgList[0] = this.errorObject;
            children = this.msgList;
            SystemBasePlugin.logError("Error in SystemTestFilterStringAPIProviderImpl#getSystemViewRoots()", exc);
        }
        return children;
    }

    public boolean hasSystemViewRoots() {
        return true;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return true;
    }

    public boolean showActionBar() {
        return false;
    }

    public boolean showButtonBar() {
        return true;
    }

    public boolean showActions() {
        return false;
    }
}

