/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.view.SystemViewPart;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.UpAction;

public class SystemViewPartGotoActionGroup
extends ActionGroup {
    protected SystemViewPart fSystemViewPart;
    protected BackAction backAction;
    protected ForwardAction forwardAction;
    protected UpAction upAction;

    public SystemViewPartGotoActionGroup(SystemViewPart viewPart) {
        this.fSystemViewPart = viewPart;
        this.makeActions();
    }

    public SystemViewPart getSystemViewPart() {
        return this.fSystemViewPart;
    }

    protected void makeActions() {
        FrameList frameList = this.fSystemViewPart.getFrameList();
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
    }

    public void fillContextMenu(IMenuManager menu) {
        MenuManager gotoMenu = new MenuManager(GenericMessages.ResourceNavigator_goto);
        menu.add((IContributionItem)gotoMenu);
        gotoMenu.add((IAction)this.backAction);
        gotoMenu.add((IAction)this.forwardAction);
        gotoMenu.add((IAction)this.upAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler(ActionFactory.UP.getId(), (IAction)this.upAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IAction)this.upAction);
    }

    public void updateActionBars() {
        this.getContext().getSelection();
    }
}

