/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.EnvironmentVariablesPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EnvironmentVariablesForm
extends SystemBaseForm
implements SelectionListener,
MouseListener {
    private static final String VAR_NAME = "NAME";
    private static final String VAR_VALUE = "VALUE";
    private static final String[] COLUMN_PROPERTIES = new String[]{"NAME", "VALUE"};
    private Table envVarTable;
    private Vector envVars;
    private EnvironmentVariablesTableContentProvider provider;
    private Object selectedObject;
    private TableViewer envVarTableViewer;
    private String systemType;
    private String invalidNameChars;
    private Button addButton;
    private Button changeButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;

    public EnvironmentVariablesForm(Shell shell, ISystemMessageLine msgLine, Object selectedObject, String invalidNameChars) {
        super(shell, msgLine);
        this.selectedObject = selectedObject;
        this.invalidNameChars = invalidNameChars;
        this.envVars = new Vector();
        this.provider = new EnvironmentVariablesTableContentProvider();
        if (selectedObject instanceof ISubSystem) {
            this.systemType = ((ISubSystem)selectedObject).getHost().getSystemType();
        }
    }

    public Control createContents(Composite parent) {
        SystemWidgetHelpers.createLabel(parent, SystemResources.RESID_SUBSYSTEM_ENVVAR_DESCRIPTION);
        this.envVarTable = new Table(parent, 68354);
        this.envVarTable.setLinesVisible(true);
        this.envVarTable.setHeaderVisible(true);
        this.envVarTable.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_TOOLTIP);
        this.envVarTable.addSelectionListener((SelectionListener)this);
        this.envVarTable.addMouseListener((MouseListener)this);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        this.envVarTable.setLayout((Layout)tableLayout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.envVarTable.setLayoutData((Object)gd);
        TableColumn hostnameColumn = new TableColumn(this.envVarTable, 0);
        hostnameColumn.setText(SystemResources.RESID_SUBSYSTEM_ENVVAR_NAME_TITLE);
        TableColumn sysTypeColumn = new TableColumn(this.envVarTable, 0);
        sysTypeColumn.setText(SystemResources.RESID_SUBSYSTEM_ENVVAR_VALUE_TITLE);
        this.envVarTableViewer = new TableViewer(this.envVarTable);
        this.envVarTableViewer.setContentProvider((IContentProvider)this.provider);
        this.envVarTableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.envVarTableViewer.setCellModifier((ICellModifier)this.provider);
        this.envVarTableViewer.setColumnProperties(COLUMN_PROPERTIES);
        CellEditor[] cellEditors = new CellEditor[2];
        cellEditors[0] = new TextCellEditor((Composite)this.envVarTable);
        cellEditors[0].setValidator((ICellEditorValidator)this.provider);
        cellEditors[1] = new TextCellEditor((Composite)this.envVarTable);
        this.envVarTableViewer.setCellEditors(cellEditors);
        this.envVarTableViewer.setInput(this.selectedObject);
        Composite buttonBar = SystemWidgetHelpers.createComposite(parent, 5);
        this.addButton = SystemWidgetHelpers.createPushButton(buttonBar, SystemResources.RESID_PREF_SIGNON_ADD_LABEL, null);
        this.addButton.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_ADD_TOOLTIP);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.changeButton = SystemWidgetHelpers.createPushButton(buttonBar, SystemResources.RESID_PREF_SIGNON_CHANGE_LABEL, null);
        this.changeButton.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_CHANGE_TOOLTIP);
        this.changeButton.addSelectionListener((SelectionListener)this);
        this.changeButton.setEnabled(false);
        this.removeButton = SystemWidgetHelpers.createPushButton(buttonBar, SystemResources.RESID_PREF_SIGNON_REMOVE_LABEL, null);
        this.removeButton.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_REMOVE_TOOLTIP);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setEnabled(false);
        this.moveUpButton = SystemWidgetHelpers.createPushButton(buttonBar, SystemResources.RESID_SUBSYSTEM_ENVVAR_MOVEUP_LABEL, null);
        this.moveUpButton.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_MOVEUP_TOOLTIP);
        this.moveUpButton.addSelectionListener((SelectionListener)this);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = SystemWidgetHelpers.createPushButton(buttonBar, SystemResources.RESID_SUBSYSTEM_ENVVAR_MOVEDOWN_LABEL, null);
        this.moveDownButton.setToolTipText(SystemResources.RESID_SUBSYSTEM_ENVVAR_MOVEDOWN_TOOLTIP);
        this.moveDownButton.addSelectionListener((SelectionListener)this);
        this.moveDownButton.setEnabled(false);
        SystemWidgetHelpers.setCompositeHelp(parent, "org.eclipse.rse.ui.envv0000");
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String[] getVariableNames() {
        String[] existingNames = new String[this.envVars.size()];
        int i = 0;
        while (i < this.envVars.size()) {
            existingNames[i] = ((EnvironmentVariable)this.envVars.get((int)i))._name;
            ++i;
        }
        return existingNames;
    }

    public void widgetSelected(SelectionEvent e) {
        Object temp;
        int loop;
        int[] selections;
        if (e.getSource() == this.addButton) {
            EnvironmentVariablesPromptDialog dialog = new EnvironmentVariablesPromptDialog(this.getShell(), SystemResources.RESID_SUBSYSTEM_ENVVAR_ADD_TITLE, this.systemType, this.invalidNameChars, this.getVariableNames(), false);
            if (dialog.open() == 0) {
                EnvironmentVariable var = new EnvironmentVariable(dialog.getName(), dialog.getValue());
                this.envVars.add(var);
                this.envVarTableViewer.refresh();
                this.envVarTableViewer.reveal((Object)var);
            }
        } else if (e.getSource() == this.removeButton) {
            selections = this.envVarTable.getSelectionIndices();
            if (selections != null && selections.length > 0) {
                int loop2 = selections.length - 1;
                while (loop2 >= 0) {
                    this.envVars.remove(selections[loop2]);
                    --loop2;
                }
                this.envVarTableViewer.refresh();
            }
        } else if (e.getSource() == this.changeButton) {
            this.changeCurrentlySelectedVariable();
        } else if (e.getSource() == this.moveUpButton) {
            selections = this.envVarTable.getSelectionIndices();
            this.envVarTable.deselectAll();
            if (selections != null) {
                loop = 0;
                while (loop < selections.length) {
                    temp = this.envVars.remove(selections[loop]);
                    this.envVars.add(selections[loop] - 1, temp);
                    ++loop;
                }
                this.envVarTableViewer.refresh();
                this.envVarTableViewer.reveal(this.envVars.get(selections[0] - 1));
                loop = 0;
                while (loop < selections.length) {
                    if (selections[loop] > 0) {
                        this.envVarTable.select(selections[loop] - 1);
                    } else {
                        this.envVarTable.select(selections[loop]);
                    }
                    ++loop;
                }
            }
        } else if (e.getSource() == this.moveDownButton) {
            selections = this.envVarTable.getSelectionIndices();
            this.envVarTable.deselectAll();
            if (selections != null) {
                loop = selections.length - 1;
                while (loop >= 0) {
                    if (selections[loop] < this.envVars.size() - 1) {
                        temp = this.envVars.remove(selections[loop]);
                        this.envVars.add(selections[loop] + 1, temp);
                    }
                    --loop;
                }
                this.envVarTableViewer.refresh();
                this.envVarTableViewer.reveal(this.envVars.get(selections[selections.length - 1] + 1));
                loop = 0;
                while (loop < selections.length) {
                    if (selections[loop] < this.envVars.size() - 1) {
                        this.envVarTable.select(selections[loop] + 1);
                    } else {
                        this.envVarTable.select(selections[loop]);
                    }
                    ++loop;
                }
            }
        }
        if (this.envVarTable.getSelectionCount() == 0) {
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            int[] selectionIndices = this.envVarTable.getSelectionIndices();
            boolean upEnabled = true;
            boolean downEnabled = true;
            int loop3 = 0;
            while (loop3 < selectionIndices.length) {
                if (selectionIndices[loop3] == 0) {
                    upEnabled = false;
                }
                if (selectionIndices[loop3] == this.envVarTable.getItemCount() - 1) {
                    downEnabled = false;
                }
                ++loop3;
            }
            if (selectionIndices.length == 1) {
                this.changeButton.setEnabled(true);
            } else {
                this.changeButton.setEnabled(false);
            }
            this.removeButton.setEnabled(true);
            this.moveUpButton.setEnabled(upEnabled);
            this.moveDownButton.setEnabled(downEnabled);
        }
    }

    public Collection getEnvVars() {
        return this.envVars;
    }

    public void setEnvVars(Vector envVars) {
        this.envVars = envVars;
        if (this.envVarTableViewer != null) {
            this.envVarTableViewer.refresh();
        }
    }

    private void changeCurrentlySelectedVariable() {
        int[] selections = this.envVarTable.getSelectionIndices();
        if (selections != null && selections.length == 1) {
            EnvironmentVariablesPromptDialog dialog = new EnvironmentVariablesPromptDialog(this.getShell(), SystemResources.RESID_SUBSYSTEM_ENVVAR_CHANGE_TITLE, this.systemType, this.invalidNameChars, this.getVariableNames(), true);
            dialog.setName(((EnvironmentVariable)this.envVars.get(selections[0])).getName());
            dialog.setValue(((EnvironmentVariable)this.envVars.get(selections[0])).getValue());
            if (dialog.open() == 0) {
                this.envVars.remove(selections[0]);
                this.envVars.add(selections[0], new EnvironmentVariable(dialog.getName(), dialog.getValue()));
                this.envVarTableViewer.refresh();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.changeCurrentlySelectedVariable();
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private SystemMessage validateName(String value) {
        SystemMessage msg = null;
        String name = value;
        if (name == null || name.trim().equals("")) {
            msg = RSEUIPlugin.getPluginMessage("RSEC2002");
        } else if (this.invalidNameChars != null) {
            if (this.invalidNameChars.indexOf(32) != -1) {
                name = value.trim();
            }
            if (this.invalidNameChars != null) {
                int i = 0;
                while (i < this.invalidNameChars.length() && msg == null) {
                    if (name.indexOf(this.invalidNameChars.charAt(i)) != -1) {
                        msg = RSEUIPlugin.getPluginMessage("RSEC2004");
                    }
                    ++i;
                }
            }
            int currentSelection = this.envVarTable.getSelectionIndex();
            int i = 0;
            while (i < this.envVars.size() && msg == null) {
                String existingName = ((EnvironmentVariable)this.envVars.get(i)).getName();
                if (currentSelection != i && existingName.equals(name)) {
                    msg = RSEUIPlugin.getPluginMessage("RSEC2001");
                    msg.makeSubstitution((Object)existingName);
                }
                ++i;
            }
        }
        return msg;
    }

    public class EnvironmentVariable {
        protected String _name;
        protected String _value;

        public EnvironmentVariable(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setValue(String value) {
            this._value = value;
        }
    }

    protected class EnvironmentVariablesTableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    ICellModifier,
    ICellEditorValidator {
        protected EnvironmentVariablesTableContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return EnvironmentVariablesForm.this.envVars.toArray();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((EnvironmentVariable)element).getName();
            }
            return ((EnvironmentVariable)element).getValue();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            if (EnvironmentVariablesForm.VAR_NAME.equals(property)) {
                return ((EnvironmentVariable)element).getName();
            }
            return ((EnvironmentVariable)element).getValue();
        }

        public void modify(Object element, String property, Object value) {
            if (EnvironmentVariablesForm.VAR_NAME.equals(property)) {
                SystemMessage msg = EnvironmentVariablesForm.this.validateName((String)value);
                if (msg != null) {
                    EnvironmentVariablesForm.this.getMessageLine().setErrorMessage(msg);
                } else {
                    if (EnvironmentVariablesForm.this.invalidNameChars != null && EnvironmentVariablesForm.this.invalidNameChars.indexOf(32) != -1) {
                        ((EnvironmentVariable)((TableItem)element).getData()).setName(((String)value).trim());
                    } else {
                        ((EnvironmentVariable)((TableItem)element).getData()).setName((String)value);
                    }
                    EnvironmentVariablesForm.this.getMessageLine().clearErrorMessage();
                }
            } else {
                ((EnvironmentVariable)((TableItem)element).getData()).setValue((String)value);
            }
            EnvironmentVariablesForm.this.envVarTableViewer.refresh();
        }

        public String isValid(Object value) {
            SystemMessage msg = EnvironmentVariablesForm.this.validateName((String)value);
            if (msg != null) {
                EnvironmentVariablesForm.this.getMessageLine().setErrorMessage(msg);
            } else {
                EnvironmentVariablesForm.this.getMessageLine().clearErrorMessage();
            }
            return null;
        }
    }
}

