/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.rse.ui.wizards.IRSENewConnectionWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class RSENewConnectionWizardMainPage
extends AbstractSystemWizardPage
implements SelectionListener {
    protected String parentHelpId = "org.eclipse.rse.ui.wncc0000";
    protected List textSystemType;
    protected Text descriptionSystemType;
    protected IWizardPage nextPage;
    protected IRSESystemType[] restrictedSystemTypes;

    public RSENewConnectionWizardMainPage(IRSENewConnectionWizard wizard, String title, String description) {
        super((IWizard)wizard, "NewConnectionSystemType", title, description);
        this.setHelp(this.parentHelpId);
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        SystemWidgetHelpers.setCompositeHelp(composite_prompts, this.parentHelpId);
        String temp = SystemWidgetHelpers.appendColon(SystemResources.RESID_CONNECTION_SYSTEMTYPE_LABEL);
        Label labelSystemType = SystemWidgetHelpers.createLabel(composite_prompts, temp);
        labelSystemType.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
        if (this.restrictedSystemTypes == null) {
            this.textSystemType = SystemWidgetHelpers.createSystemTypeListBox(parent, null);
        } else {
            String[] systemTypeNames = new String[this.restrictedSystemTypes.length];
            int i = 0;
            while (i < this.restrictedSystemTypes.length) {
                systemTypeNames[i] = this.restrictedSystemTypes[i].getName();
                ++i;
            }
            this.textSystemType = SystemWidgetHelpers.createSystemTypeListBox(parent, null, systemTypeNames);
        }
        this.textSystemType.setToolTipText(SystemResources.RESID_CONNECTION_SYSTEMTYPE_TIP);
        SystemWidgetHelpers.setHelp((Control)this.textSystemType, "org.eclipse.rse.ui.ccon0003");
        this.textSystemType.addSelectionListener((SelectionListener)this);
        this.descriptionSystemType = SystemWidgetHelpers.createMultiLineTextField(parent, null, 30);
        this.descriptionSystemType.setEditable(false);
        IRSESystemType systemType = RSECorePlugin.getDefault().getRegistry().getSystemType(this.textSystemType.getSelection()[0]);
        if (systemType != null) {
            this.descriptionSystemType.setText(systemType.getDescription());
        }
        return composite_prompts;
    }

    public void restrictToSystemTypes(IRSESystemType[] systemTypes) {
        this.restrictedSystemTypes = systemTypes;
    }

    protected Control getInitialFocusControl() {
        if (this.textSystemType != null) {
            return this.textSystemType;
        }
        return null;
    }

    public boolean performFinish() {
        return true;
    }

    public IWizardPage getNextPage() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof IRSENewConnectionWizard) {
            String systemTypeStr = this.textSystemType.getSelection()[0];
            IRSENewConnectionWizard newConnWizard = (IRSENewConnectionWizard)wizard;
            newConnWizard.setSelectedSystemType(RSECorePlugin.getDefault().getRegistry().getSystemType(systemTypeStr));
            return newConnWizard.getDelegate().getMainPage();
        }
        return super.getNextPage();
    }

    public void widgetSelected(SelectionEvent e) {
        IWizard wizard = this.getWizard();
        if (wizard instanceof IRSENewConnectionWizard) {
            String systemTypeStr = this.textSystemType.getSelection()[0];
            IRSENewConnectionWizard newConnWizard = (IRSENewConnectionWizard)wizard;
            IRSESystemType systemType = RSECorePlugin.getDefault().getRegistry().getSystemType(systemTypeStr);
            newConnWizard.setSelectedSystemType(systemType);
            this.descriptionSystemType.setText(systemType.getDescription());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
        if (this.canFlipToNextPage()) {
            this.getWizard().getContainer().showPage(this.getNextPage());
        }
    }
}

