/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;
import org.eclipse.rse.ui.wizards.SystemNewProfileWizardMainPage;

public class SystemNewProfileWizard
extends AbstractSystemWizard {
    private SystemNewProfileWizardMainPage mainPage;

    public SystemNewProfileWizard() {
        super(SystemResources.RESID_NEWPROFILE_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newprofile_wizBannerIcon"));
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage();
            this.addPage((IWizardPage)this.mainPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("New connection: Error in createPages: ", exc);
        }
    }

    protected SystemNewProfileWizardMainPage createMainPage() {
        this.mainPage = new SystemNewProfileWizardMainPage(this);
        return this.mainPage;
    }

    public boolean performFinish() {
        boolean ok = true;
        if (this.mainPage.performFinish()) {
            SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
            String name = this.mainPage.getProfileName();
            boolean makeActive = this.mainPage.getMakeActive();
            try {
                sr.createSystemProfile(name, makeActive);
            }
            catch (Exception exc) {
                String msg = "Exception creating profile ";
                SystemBasePlugin.logError(msg, exc);
                SystemMessageDialog.displayExceptionMessage(this.getShell(), exc);
            }
            return ok;
        }
        ok = false;
        return ok;
    }
}

