/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.tm.terminal.ISettingsPage;
import org.eclipse.tm.terminal.ISettingsStore;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.internal.telnet.ITelnetSettings;
import org.eclipse.tm.terminal.internal.telnet.TelnetConnectWorker;
import org.eclipse.tm.terminal.internal.telnet.TelnetConnection;
import org.eclipse.tm.terminal.internal.telnet.TelnetSettings;
import org.eclipse.tm.terminal.internal.telnet.TelnetSettingsPage;

public class TelnetConnector
implements ITerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private Socket fSocket;
    private ITerminalControl fControl;
    private TelnetConnection fTelnetConnection;
    private final TelnetSettings fSettings;

    public TelnetConnector() {
        this(new TelnetSettings());
    }

    public String getId() {
        return this.getClass().getName();
    }

    public TelnetConnector(TelnetSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        Logger.log("entered.");
        this.fControl = control;
        TelnetConnectWorker worker = new TelnetConnectWorker(this, control);
        worker.start();
    }

    public void disconnect() {
        Logger.log("entered.");
        if (this.getSocket() != null) {
            try {
                this.getSocket().close();
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
        if (this.getOutputStream() != null) {
            try {
                this.getOutputStream().close();
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
        this.cleanSocket();
        this.setState(TerminalState.CLOSED);
    }

    public boolean isLocalEcho() {
        if (this.fTelnetConnection != null) {
            return false;
        }
        return this.fTelnetConnection.localEcho();
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fTelnetConnection != null) {
            this.fTelnetConnection.setTerminalSize(newWidth, newHeight);
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    Socket getSocket() {
        return this.fSocket;
    }

    void cleanSocket() {
        this.fSocket = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    void setSocket(Socket socket) throws IOException {
        if (socket == null) {
            this.cleanSocket();
        } else {
            this.fSocket = socket;
            this.setInputStream(socket.getInputStream());
            this.setOutputStream(socket.getOutputStream());
        }
    }

    public void setTelnetConnection(TelnetConnection connection) {
        this.fTelnetConnection = connection;
    }

    public void writeToTerminal(String txt) {
        this.fControl.writeToTerminal(txt);
    }

    public void setState(TerminalState state) {
        this.fControl.setState(state);
    }

    public ITelnetSettings getTelnetSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new TelnetSettingsPage(this.fSettings);
    }

    public String getStatusString(String strConnected) {
        return this.fSettings.getStatusString(strConnected);
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    public boolean isInstalled() {
        return true;
    }
}

