/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.view.ISystemCommandTextModifyListener;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class SystemCommandEditor
extends SourceViewer {
    protected boolean menuListenerAdded;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    protected ISystemValidator cmdValidator;
    protected boolean ignoreChanges;
    private String contentAssistText;
    private boolean isInCodeAssist = false;
    private IViewSite _site;
    private Vector listeners = new Vector();
    private TextViewerAction _undoAction = null;
    private TextViewerAction _cutAction = null;
    private TextViewerAction _copyAction = null;
    private TextViewerAction _pasteAction = null;
    private TextViewerAction _selectAllAction = null;
    private TextViewerAction _caAction = null;

    public SystemCommandEditor(IViewSite site, Composite parent, int attributes, int columnSpan, SourceViewerConfiguration sourceViewerConfiguration, String cmd, String contentAssistText) {
        super(parent, null, attributes);
        this.contentAssistText = contentAssistText;
        this._site = site;
        this.init(columnSpan, sourceViewerConfiguration, cmd);
    }

    private void init(int columnSpan, SourceViewerConfiguration sourceViewerConfiguration, String cmd) {
        Document document = new Document();
        this.configure(sourceViewerConfiguration);
        this.setEditable(true);
        this.setDocument((IDocument)document);
        Control control = this.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = columnSpan;
        data.widthHint = 200;
        data.heightHint = 45;
        control.setLayoutData((Object)data);
        document.set(cmd);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SystemCommandEditor.this.updateSelectionDependentActions();
            }
        });
        this.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SystemCommandEditor.this.updateUndoAction();
                if (SystemCommandEditor.this.ignoreChanges || !SystemCommandEditor.this.getTextWidget().isEnabled()) {
                    return;
                }
                String cmdText = SystemCommandEditor.this.getCommandText();
                SystemCommandEditor.this.updateSelectionDependentActions();
                SystemCommandEditor.this._selectAllAction.setEnabled(cmdText.length() > 0);
                SystemMessage errorMessage = SystemCommandEditor.this.validateCommand();
                SystemCommandEditor.this.fireModifyEvents(cmdText, errorMessage);
            }
        });
        this.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!e.doit) {
                    return;
                }
                if (e.stateMask == 262144) {
                    switch (e.character) {
                        case ' ': {
                            SystemCommandEditor.this.doOperation(13);
                            break;
                        }
                        case '\u001a': {
                            SystemCommandEditor.this.doOperation(1);
                        }
                    }
                }
            }
        });
        this.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                SystemCommandEditor.this.handleVerifyKeyPressed(event);
            }
        });
        this.initializeActions();
    }

    public String getCommandText() {
        return this.getDocument().get().trim();
    }

    public String getSelectedText() {
        return this.getTextWidget().getSelectionText();
    }

    public void addModifyListener(ISystemCommandTextModifyListener listener) {
        this.listeners.add(listener);
    }

    public void removeModifyListener(ISystemCommandTextModifyListener listener) {
        this.listeners.remove(listener);
    }

    private void fireModifyEvents(String cmdText, SystemMessage errorMessage) {
        int idx = 0;
        while (idx < this.listeners.size()) {
            ((ISystemCommandTextModifyListener)this.listeners.elementAt(idx)).commandModified(cmdText, errorMessage);
            ++idx;
        }
    }

    public void setIgnoreChanges(boolean ignore) {
        this.ignoreChanges = ignore;
    }

    public SystemMessage validateCommand() {
        if (this.cmdValidator != null) {
            return this.cmdValidator.validate(this.getCommandText());
        }
        return null;
    }

    public void setCommandValidator(ISystemValidator cmdValidator) {
        this.cmdValidator = cmdValidator;
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    private IActionBars getActionBars() {
        if (this._site != null) {
            IActionBars actionBars = this._site.getActionBars();
            return actionBars;
        }
        return null;
    }

    public void setViewSite(IViewSite site) {
        this._site = site;
    }

    private void initializeActions() {
        this._undoAction = new TextViewerAction((ITextViewer)this, 1);
        this._undoAction.setText(SystemResources.ACTION_UNDO_LABEL);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, this._undoAction);
        this._undoAction.setEnabled(false);
        this._cutAction = new TextViewerAction((ITextViewer)this, 3);
        this._cutAction.setText(SystemResources.ACTION_CUT_LABEL);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, this._cutAction);
        this._cutAction.setEnabled(false);
        this._copyAction = new TextViewerAction((ITextViewer)this, 4);
        this._copyAction.setText(SystemResources.ACTION_COPY_LABEL);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, this._copyAction);
        this._copyAction.setEnabled(false);
        this._pasteAction = new TextViewerAction((ITextViewer)this, 5);
        this._pasteAction.setText(SystemResources.ACTION_PASTE_LABEL);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, this._pasteAction);
        this._pasteAction.setEnabled(false);
        if (this._pasteAction != null) {
            this._pasteAction.update();
        }
        this._selectAllAction = new TextViewerAction((ITextViewer)this, 7);
        this._selectAllAction.setText(SystemResources.ACTION_SELECT_ALL_LABEL);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, this._selectAllAction);
        this._selectAllAction.setEnabled(false);
        this._caAction = new TextViewerAction((ITextViewer)this, 13);
        this._caAction.setText(this.contentAssistText);
        this._caAction.setEnabled(true);
        this.fGlobalActions.put("ContentAssistProposal", this._caAction);
        this.setActionHandlers();
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Menu m;
                SystemCommandEditor.this.fillContextMenu(mgr);
                if (!SystemCommandEditor.this.menuListenerAdded && mgr instanceof MenuManager && (m = ((MenuManager)mgr).getMenu()) != null) {
                    SystemCommandEditor.this.menuListenerAdded = true;
                    SystemViewMenuListener ml = new SystemViewMenuListener();
                    m.addMenuListener((MenuListener)ml);
                }
            }
        });
        StyledText text = this.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    public void setActionHandlers() {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this._undoAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this._cutAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this._copyAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this._pasteAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this._selectAllAction);
            actionBars.updateActionBars();
        }
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction action;
        Object obj = this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (obj instanceof IAction && (action = (IAction)obj) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(String actionId) {
        IAction action;
        Object obj = this.fGlobalActions.get(actionId);
        if (obj instanceof IAction && (action = (IAction)obj) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
    }

    public void setInCodeAssist(boolean flag) {
        this.isInCodeAssist = flag;
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
        boolean result = super.requestWidgetToken(requester);
        if (result) {
            this.setInCodeAssist(true);
        }
        return result;
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
        boolean result = super.requestWidgetToken(requester, priority);
        if (result) {
            this.setInCodeAssist(true);
        }
        return result;
    }

    public void releaseWidgetToken(IWidgetTokenKeeper tokenKeeper) {
        super.releaseWidgetToken(tokenKeeper);
        DelayedIsInCodeAssistUntoggler untoggler = new DelayedIsInCodeAssistUntoggler();
        untoggler.start();
    }

    public boolean isInCodeAssist() {
        return this.isInCodeAssist;
    }

    public void doOperation(int operation) {
        super.doOperation(operation);
    }

    private class DelayedIsInCodeAssistUntoggler
    extends Thread {
        private DelayedIsInCodeAssistUntoggler() {
        }

        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            SystemCommandEditor.this.setInCodeAssist(false);
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

