/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Display;

public class DownloadJob
extends Job {
    private ISystemEditableRemoteObject _editable;
    private boolean _systemEditor;

    public DownloadJob(ISystemEditableRemoteObject editable, boolean systemEditor) {
        super(FileResources.RESID_FILES_DOWNLOAD);
        this._editable = editable;
        this._systemEditor = systemEditor;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            IFile localFile = this._editable.getLocalResource();
            SystemUniversalTempFileListener listener = SystemUniversalTempFileListener.getListener();
            listener.addIgnoreFile(localFile);
            this._editable.download(monitor);
            listener.removeIgnoreFile(localFile);
        }
        catch (Exception exception) {}
        if (!monitor.isCanceled()) {
            OpenEditorRunnable oe = new OpenEditorRunnable(this._editable, this._systemEditor);
            Display.getDefault().asyncExec((Runnable)oe);
        }
        return Status.OK_STATUS;
    }

    public static class OpenEditorRunnable
    implements Runnable {
        private ISystemEditableRemoteObject _editable;
        private boolean _systemEditor;

        public OpenEditorRunnable(ISystemEditableRemoteObject editable, boolean systemEditor) {
            this._editable = editable;
            this._systemEditor = systemEditor;
        }

        public void run() {
            try {
                this._editable.addAsListener();
                this._editable.setLocalResourceProperties();
                if (this._systemEditor) {
                    ((SystemEditableRemoteFile)this._editable).openSystemEditor();
                } else {
                    this._editable.openEditor();
                }
            }
            catch (Exception exception) {}
        }
    }
}

