/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.view;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.model.ISystemNewConnectionWizardPage;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.files.ui.actions.SystemFileUpdateFilterAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFileAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFileFilterAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFolderAction;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.SubSystemConfigurationAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;

public class RemoteFileSubSystemConfigurationAdapter
extends SubSystemConfigurationAdapter {
    SystemNewFileFilterAction _newFileFilterAction;
    SystemFileUpdateFilterAction _changeFilerAction;
    Vector _additionalActions;

    public ISystemNewConnectionWizardPage[] getNewConnectionWizardPages(ISubSystemConfiguration factory, IWizard wizard) {
        ISystemNewConnectionWizardPage[] basepages = super.getNewConnectionWizardPages(factory, wizard);
        return basepages;
    }

    protected IAction getNewFilterPoolFilterAction(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        if (this._newFileFilterAction == null) {
            this._newFileFilterAction = new SystemNewFileFilterAction((IRemoteFileSubSystemConfiguration)factory, selectedPool, shell);
        } else {
            this._newFileFilterAction.setParentFilterPool(selectedPool);
        }
        return this._newFileFilterAction;
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        if (this._changeFilerAction == null) {
            this._changeFilerAction = new SystemFileUpdateFilterAction(shell);
        }
        return this._changeFilerAction;
    }

    protected Vector getAdditionalFilterActions(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        if (this._additionalActions == null) {
            this._additionalActions = super.getAdditionalFilterActions(factory, selectedFilter, shell);
            if (selectedFilter.isPromptable()) {
                return this._additionalActions;
            }
            if (this._additionalActions == null) {
                this._additionalActions = new Vector();
            }
            this._additionalActions.add(new SystemNewFileAction(shell));
            this._additionalActions.add(new SystemNewFolderAction(shell));
            Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
            this._additionalActions.add(new SystemPasteFromClipboardAction(shell, clipboard));
        }
        return this._additionalActions;
    }

    public Object[] applyViewFilters(IContextObject parent, Object[] children) {
        boolean showHidden = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.subsystems.files.core.preferences.showhidden");
        if (showHidden) {
            return children;
        }
        ArrayList<IRemoteFile> results = new ArrayList<IRemoteFile>(children.length);
        int i = 0;
        while (i < children.length) {
            IRemoteFile remoteFile;
            if (children[i] instanceof IRemoteFile && !(remoteFile = (IRemoteFile)children[i]).isHidden()) {
                results.add(remoteFile);
            }
            ++i;
        }
        return results.toArray();
    }
}

