/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.processes.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.processes.servicesubsystem.ProcessServiceSubSystem;
import org.eclipse.rse.ui.propertypages.ServicesPropertyPage;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public class ProcessServicesPropertyPage
extends ServicesPropertyPage {
    private IProcessServiceSubSystemConfiguration _currentFactory;

    protected ProcessServiceSubSystem getProcessServiceSubSystem() {
        return (ProcessServiceSubSystem)this.getElement();
    }

    protected ServiceElement[] getServiceElements() {
        ProcessServiceSubSystem subSystem = this.getProcessServiceSubSystem();
        IHost host = subSystem.getHost();
        this._currentFactory = (IProcessServiceSubSystemConfiguration)subSystem.getParentRemoteProcessSubSystemConfiguration();
        IProcessServiceSubSystemConfiguration[] factories = this.getProcessServiceSubSystemConfigurations(host.getSystemType());
        ServiceElement[] elements = new ServiceElement[factories.length];
        int i = 0;
        while (i < factories.length) {
            IProcessServiceSubSystemConfiguration factory = factories[i];
            elements[i] = new FactoryServiceElement(host, (IServiceSubSystemConfiguration)factory);
            if (factory == this._currentFactory) {
                elements[i].setSelected(true);
            }
            ++i;
        }
        return elements;
    }

    protected IProcessServiceSubSystemConfiguration[] getProcessServiceSubSystemConfigurations(IRSESystemType systemType) {
        ArrayList<ISubSystemConfiguration> results = new ArrayList<ISubSystemConfiguration>();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType, false);
        int i = 0;
        while (i < factories.length) {
            ISubSystemConfiguration factory = factories[i];
            if (factory instanceof IProcessServiceSubSystemConfiguration) {
                results.add(factory);
            }
            ++i;
        }
        return results.toArray(new IProcessServiceSubSystemConfiguration[results.size()]);
    }

    protected IServiceSubSystemConfiguration getCurrentServiceSubSystemConfiguration() {
        return this._currentFactory;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this._currentFactory = (IProcessServiceSubSystemConfiguration)factory;
    }
}

