/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.model;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;

public class RemoteFileFilterString
implements Cloneable {
    protected String path;
    protected String file;
    protected String[] types;
    protected boolean subdirs;
    protected boolean files;
    protected boolean filterByTypes;
    protected String PATH_SEP = File.separator;
    public static final char TYPE_SEP = ',';
    public static final String TYPE_SEP_STRING = ",";
    public static final String SWITCH_NOSUBDIRS = " /ns";
    public static final String SWITCH_NOFILES = " /nf";

    public RemoteFileFilterString() {
        this.file = "*";
        this.subdirs = true;
        this.files = true;
    }

    public RemoteFileFilterString(IRemoteFileSubSystemConfiguration subsysFactory) {
        this.PATH_SEP = subsysFactory.getSeparator();
        this.file = "*";
        this.subdirs = true;
        this.files = true;
    }

    public RemoteFileFilterString(IRemoteFileSubSystemConfiguration subsysFactory, String input) {
        this(subsysFactory);
        this.parse(null, input);
    }

    public RemoteFileFilterString(IRemoteFileSubSystemConfiguration subsysFactory, String path, String input) {
        this(subsysFactory);
        this.parse(path, input);
    }

    public void setSubSystemConfiguration(IRemoteFileSubSystemConfiguration subsysFactory) {
        this.PATH_SEP = subsysFactory.getSeparator();
    }

    public void setFile(String obj) {
        this.file = obj;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTypes(String[] types) {
        this.types = types;
        this.filterByTypes = types != null;
    }

    public void setShowFiles(boolean set) {
        this.files = set;
    }

    public void setShowSubDirs(boolean set) {
        this.subdirs = set;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileOrTypes() {
        if (!this.filterByTypes || this.types == null) {
            return this.file;
        }
        return RemoteFileFilterString.getTypesString(this.types);
    }

    public static String getTypesString(String[] typesArray) {
        StringBuffer typesBuffer = new StringBuffer("");
        int idx = 0;
        while (idx < typesArray.length) {
            typesBuffer.append(String.valueOf(typesArray[idx]) + TYPE_SEP_STRING);
            ++idx;
        }
        return typesBuffer.toString();
    }

    public String getTypesAsString() {
        if (!this.filterByTypes || this.types == null) {
            return null;
        }
        return RemoteFileFilterString.getTypesString(this.types);
    }

    public String getPath() {
        return this.path;
    }

    public String[] getTypes() {
        return this.types;
    }

    public boolean getShowFiles() {
        return this.files;
    }

    public boolean getShowSubDirs() {
        return this.subdirs;
    }

    public boolean getFilterByTypes() {
        return this.filterByTypes;
    }

    public boolean listRoots() {
        return this.path == null || this.path.equals("/");
    }

    public boolean listRoot() {
        return this.toStringNoSwitches().equals("/*");
    }

    protected void parse(String inputPath, String input) {
        int idx = input.indexOf(SWITCH_NOSUBDIRS);
        if (idx >= 0) {
            this.subdirs = false;
            input = input.substring(0, idx);
        } else {
            this.subdirs = true;
        }
        idx = input.indexOf(SWITCH_NOFILES);
        if (idx >= 0) {
            this.files = false;
            input = input.substring(0, idx);
        } else {
            this.files = true;
        }
        if (inputPath != null) {
            this.path = inputPath;
            this.parseFileOrTypes(input);
        } else {
            int pathidx = input.lastIndexOf(this.PATH_SEP);
            if (pathidx == 0) {
                this.path = this.PATH_SEP;
                if (input.length() > 1) {
                    this.parseFileOrTypes(input.substring(1));
                } else {
                    this.file = "*";
                }
            } else if (pathidx > 0) {
                this.path = input.substring(0, pathidx);
                if (this.path.endsWith(":")) {
                    this.path = String.valueOf(this.path) + this.PATH_SEP;
                }
                if (pathidx == input.length() - 1) {
                    this.file = "*";
                } else {
                    this.parseFileOrTypes(input.substring(pathidx + 1));
                }
            } else {
                this.path = null;
                this.parseFileOrTypes(input);
            }
        }
    }

    protected void parseFileOrTypes(String filter) {
        this.filterByTypes = false;
        this.types = null;
        if (filter == null || filter.length() == 0) {
            this.file = "*";
        } else if (filter.endsWith(TYPE_SEP_STRING)) {
            this.types = RemoteFileFilterString.parseTypes(filter);
            this.filterByTypes = true;
        } else {
            this.file = filter;
        }
    }

    public static String[] parseTypes(String typeList) {
        StringTokenizer tokens = new StringTokenizer(typeList, TYPE_SEP_STRING);
        Vector<String> v = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0) continue;
            v.addElement(token);
        }
        String[] types = new String[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            types[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return types;
    }

    public String toString() {
        String fs = this.toStringNoSwitches();
        if (!this.getShowSubDirs()) {
            fs = String.valueOf(fs) + SWITCH_NOSUBDIRS;
        }
        if (!this.getShowFiles()) {
            fs = String.valueOf(fs) + SWITCH_NOFILES;
        }
        return fs;
    }

    public String toStringNoSwitches() {
        String fs = null;
        fs = this.path == null || this.path.length() == 0 ? this.getFileOrTypes() : (!this.path.endsWith(this.PATH_SEP) ? String.valueOf(this.path) + this.PATH_SEP + this.getFileOrTypes() : String.valueOf(this.path) + this.getFileOrTypes());
        return fs;
    }

    public Object clone() {
        RemoteFileFilterString copy = new RemoteFileFilterString();
        copy.path = this.path;
        copy.file = this.file;
        copy.subdirs = this.subdirs;
        copy.files = this.files;
        copy.PATH_SEP = this.PATH_SEP;
        copy.filterByTypes = this.filterByTypes;
        if (this.types != null) {
            copy.types = new String[this.types.length];
            int idx = 0;
            while (idx < this.types.length) {
                copy.types[idx] = this.types[idx];
                ++idx;
            }
        }
        return copy;
    }
}

