/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IRSECallback;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.model.ISystemPromptableObject;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenInNewWindowAction;

public class SystemOpenExplorerPerspectiveAction
extends SystemBaseAction {
    private IWorkbenchWindow window;
    static /* synthetic */ Class class$0;

    public SystemOpenExplorerPerspectiveAction(Shell parent, IWorkbenchWindow currentWorkbenchWindow) {
        super(SystemResources.ACTION_OPENEXPLORER_DIFFPERSP2_LABEL, SystemResources.ACTION_OPENEXPLORER_DIFFPERSP2_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.system_perspIcon"), parent);
        this.window = currentWorkbenchWindow;
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.open");
        this.setHelp("org.eclipse.rse.ui.actn0016");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Object selected = selection.getFirstElement();
        if (selected instanceof ISystemFilterReference) {
            if (((ISystemFilterReference)selected).getReferencedFilter().isPromptable()) {
                enable = false;
            }
        } else if (selected instanceof ISystemPromptableObject) {
            enable = false;
        }
        return enable;
    }

    public void run() {
        final IAdaptable input = this.getPageInput();
        final ISubSystem ss = this.getSubSystem(input);
        if (ss != null && !ss.isConnected()) {
            try {
                ss.connect(false, new IRSECallback(){

                    public void done(IStatus status, Object object) {
                        if (ss.isConnected()) {
                            Display.getDefault().asyncExec(new Runnable(this, input){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IAdaptable val$input;
                                {
                                    this.this$1 = var1_1;
                                    this.val$input = iAdaptable;
                                }

                                public void run() {
                                    1.access$0(this.this$1).openWindow(this.val$input);
                                }
                            });
                        }
                    }

                    static /* synthetic */ SystemOpenExplorerPerspectiveAction access$0(1 var0) {
                        return var0.SystemOpenExplorerPerspectiveAction.this;
                    }
                });
            }
            catch (Exception e) {
                SystemBasePlugin.logError(e.getMessage(), e);
            }
        } else {
            this.openWindow(input);
        }
    }

    private ISubSystem getSubSystem(IAdaptable input) {
        ISystemViewElementAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)input.getAdapter((Class)clazz)) != null && (input instanceof ISystemFilterReference || input instanceof ISubSystem || adapter.isRemote(input))) {
            return adapter.getSubSystem(input);
        }
        return null;
    }

    protected void openWindow(IAdaptable input) {
        OpenInNewWindowAction workbenchOpenAction = new OpenInNewWindowAction(this.window, input);
        workbenchOpenAction.run();
    }

    public void setPageInput(IAdaptable input) {
    }

    public IAdaptable getPageInput() {
        Object firstSel = this.getFirstSelection();
        if (firstSel != null && firstSel instanceof IAdaptable) {
            return (IAdaptable)firstSel;
        }
        return null;
    }
}

