/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemDeleteTableRow;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemRenameTableProvider;
import org.eclipse.rse.ui.dialogs.SystemRenameTableRow;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.rse.ui.validators.ValidatorConnectionName;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SystemRenameDialog
extends SystemPromptDialog
implements ISelectionChangedListener,
TraverseListener,
ICellEditorListener,
Runnable,
FocusListener {
    private SystemMessage errorMessage;
    private TextCellEditor cellEditor;
    private int currRow = 0;
    private GridData tableData = null;
    private boolean ignoreSelection = false;
    private Hashtable uniqueNameValidatorPerParent = new Hashtable();
    private String verbiage;
    private SystemRenameTableProvider srtp;
    private Table table;
    private TableViewer tableViewer;
    private static final int COLUMN_NEWNAME = 2;
    private String[] columnHeaders = new String[]{"", SystemResources.RESID_RENAME_COLHDG_OLDNAME, SystemResources.RESID_RENAME_COLHDG_NEWNAME, SystemResources.RESID_RENAME_COLHDG_TYPE};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(125, 125, true), new ColumnWeightData(150, 150, true), new ColumnWeightData(120, 120, true)};
    private static String[] tableColumnProperties = new String[]{"org.eclipse.rse.ui.error", "org.eclipse.jface.text", "org.eclipse.rse.ui.newName", "org.eclipse.rse.ui.type"};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            SystemRenameTableRow row = (SystemRenameTableRow)element;
            String value = "";
            value = property.equals("org.eclipse.jface.text") ? row.getName() : row.getNewName();
            return value;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = property.equals("org.eclipse.rse.ui.newName");
            if (SystemRenameDialog.this.cellEditor != null && SystemRenameDialog.this.cellEditor.getControl() != null) {
                SystemRenameTableRow row = (SystemRenameTableRow)element;
                int limit = row.getNameLengthLimit();
                if (limit == -1) {
                    limit = 1000;
                }
                ((Text)SystemRenameDialog.this.cellEditor.getControl()).setTextLimit(limit);
            }
            return modifiable;
        }

        public void modify(Object element, String property, Object value) {
            SystemRenameTableRow row = (SystemRenameTableRow)((TableItem)element).getData();
            if (property.equals("org.eclipse.rse.ui.newName")) {
                row.setNewName((String)value);
                SystemRenameDialog.this.tableViewer.update((Object)row, null);
            }
        }
    };
    static /* synthetic */ Class class$0;

    public SystemRenameDialog(Shell shell) {
        this(shell, SystemResources.RESID_RENAME_TITLE);
    }

    public SystemRenameDialog(Shell shell, String title) {
        super(shell, title);
        this.setHelp("org.eclipse.rse.ui.drnm0000");
    }

    public void setVerbiage(String verbiage) {
        this.verbiage = verbiage;
    }

    public void setNameValidator(ISystemValidator nameValidator) {
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        SystemRenameTableRow[] rows = this.getRows();
        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)rows[0]), true);
        this.tableViewer.editElement((Object)rows[0], 2);
        return null;
    }

    protected Control createInner(Composite parent) {
        int height;
        int nbrColumns = 1;
        Composite composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        if (this.verbiage != null) {
            SystemWidgetHelpers.createVerbiage(composite, this.verbiage, nbrColumns, false, 200);
        } else {
            SystemWidgetHelpers.createVerbiage(composite, SystemResources.RESID_RENAME_VERBIAGE, nbrColumns, false, 200);
        }
        this.table = this.createTable(composite);
        this.tableViewer = new TableViewer(this.table);
        this.createColumns();
        this.tableViewer.setColumnProperties(tableColumnProperties);
        this.tableViewer.setCellModifier(this.cellModifier);
        CellEditor[] editors = new CellEditor[this.columnHeaders.length];
        this.cellEditor = new TextCellEditor((Composite)this.table);
        this.cellEditor.addListener((ICellEditorListener)this);
        editors[2] = this.cellEditor;
        this.tableViewer.setCellEditors(editors);
        this.cellEditor.getControl().addTraverseListener((TraverseListener)this);
        this.srtp = new SystemRenameTableProvider();
        int width = this.tableData.widthHint;
        int nbrRows = Math.min(this.getRows().length, 8);
        int rowHeight = this.table.getItemHeight() + this.table.getGridLineWidth();
        int sbHeight = this.table.getHorizontalBar().getSize().y;
        this.tableData.heightHint = height = nbrRows * rowHeight + sbHeight;
        this.table.setLayoutData((Object)this.tableData);
        this.table.setSize(width, height);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.srtp);
        this.tableViewer.setContentProvider((IContentProvider)this.srtp);
        this.tableViewer.setInput(this.getInputObject());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tableViewer.getTable().addFocusListener((FocusListener)this);
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        if (display != null) {
            display.asyncExec((Runnable)this);
        } else {
            this.run();
        }
        return composite;
    }

    private Table createTable(Composite parent) {
        this.table = new Table(parent, 101124);
        this.table.setLinesVisible(true);
        this.tableData = new GridData();
        this.tableData.horizontalAlignment = 4;
        this.tableData.grabExcessHorizontalSpace = true;
        this.tableData.widthHint = 450;
        this.tableData.heightHint = 30;
        this.tableData.verticalAlignment = 2;
        this.tableData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)this.tableData);
        return this.table;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.ignoreSelection) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.currRow = -1;
            return;
        }
        SystemRenameTableRow selectedRow = (SystemRenameTableRow)selection.getFirstElement();
        int rowIdx = this.srtp.getRowNumber(selectedRow);
        if (rowIdx == this.currRow) {
            return;
        }
        this.currRow = rowIdx;
        this.tableViewer.editElement((Object)this.getRows()[rowIdx], 2);
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
    }

    protected boolean processOK() {
        if (this.currRow >= 0 && this.currRow <= this.getRows().length - 1) {
            String newName = ((Text)this.cellEditor.getControl()).getText();
            this.getRows()[this.currRow].setNewName(newName);
        }
        boolean closeDialog = this.verify();
        return closeDialog;
    }

    public boolean verify() {
        SystemMessage errMsg = null;
        SystemMessage firstErrMsg = null;
        Object firstErrRow = null;
        this.clearErrorMessage();
        Object[] rows = this.getRows();
        Vector<String> newNames = new Vector<String>();
        int idx = 0;
        while (idx < rows.length) {
            rows[idx].setErrorMessage(null);
            ++idx;
        }
        idx = 0;
        while (firstErrMsg == null && idx < rows.length) {
            errMsg = null;
            String oldName = rows[idx].getName();
            String newName = ((SystemRenameTableRow)rows[idx]).getNewName();
            String canonicalNewName = ((SystemRenameTableRow)rows[idx]).getCanonicalNewName();
            if (((SystemRenameTableRow)rows[idx]).newNameEqualsOldName()) {
                errMsg = RSEUIPlugin.getPluginMessage("RSEG1009").makeSubstitution((Object)oldName);
            } else if (newNames.contains(canonicalNewName)) {
                errMsg = RSEUIPlugin.getPluginMessage("RSEG1010").makeSubstitution((Object)newName);
            } else {
                boolean ok;
                ValidatorUniqueString vun;
                ISystemValidator nameValidator = ((SystemRenameTableRow)rows[idx]).getNameValidator();
                if (nameValidator != null) {
                    errMsg = nameValidator.validate(newName);
                }
                if (errMsg == null && (vun = ((SystemRenameTableRow)rows[idx]).getUniqueNameValidator()) != null) {
                    errMsg = vun.validate(newName);
                }
                if (errMsg == null && ((SystemDeleteTableRow)rows[idx]).getElement() instanceof IHost && !(ok = ValidatorConnectionName.validateNameNotInUse(newName, this.getShell()))) {
                    errMsg = RSEUIPlugin.getPluginMessage("RSEG1067");
                }
            }
            if (errMsg == null) {
                newNames.addElement(canonicalNewName);
            }
            if (errMsg != null) {
                firstErrMsg = errMsg;
                firstErrRow = rows[idx];
            }
            ((SystemRenameTableRow)rows[idx]).setErrorMessage(errMsg);
            ++idx;
        }
        if (firstErrMsg != null) {
            this.setErrorMessage(firstErrMsg);
            this.tableViewer.update(rows, null);
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstErrRow), true);
            this.tableViewer.editElement(firstErrRow, 2);
        }
        return firstErrMsg == null;
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = null;
        if (this.errorMessage == null) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessage(this.errorMessage);
        }
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            pageComplete = true;
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public void keyTraversed(TraverseEvent e) {
        int detail = e.detail;
        e.doit = false;
        this.ignoreSelection = true;
        if (detail == 16) {
            if (this.currRow != this.getRows().length - 1) {
                ++this.currRow;
                this.tableViewer.editElement((Object)this.getRows()[this.currRow], 2);
            } else {
                this.tableViewer.editElement((Object)this.getRows()[0], 2);
                this.currRow = 0;
                e.doit = true;
            }
        } else if (detail == 8) {
            if (this.currRow != 0) {
                this.currRow = this.currRow > 0 ? --this.currRow : 0;
                this.tableViewer.editElement((Object)this.getRows()[this.currRow], 2);
            } else {
                this.tableViewer.editElement((Object)this.getRows()[this.getRows().length - 1], 2);
                this.currRow = this.getRows().length - 1;
                e.doit = true;
            }
        } else {
            e.doit = true;
        }
        this.ignoreSelection = false;
    }

    public SystemRenameTableRow[] getRows() {
        return (SystemRenameTableRow[])this.srtp.getElements(this.getInputObject());
    }

    public String[] getNewNames() {
        SystemRenameTableRow[] rows = this.getRows();
        String[] names = new String[rows.length];
        int idx = 0;
        while (idx < rows.length) {
            names[idx] = rows[idx].getNewName();
            ++idx;
        }
        return names;
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }

    public void run() {
        SystemRenameTableRow[] rows = this.getRows();
        ValidatorUniqueString uniqueNameValidator = null;
        Object inputElement = null;
        ISystemValidator nameValidator = null;
        int idx = 0;
        while (idx < rows.length) {
            nameValidator = rows[idx].getNameValidator();
            inputElement = rows[idx].getElement();
            uniqueNameValidator = this.setUniqueNameValidator(inputElement, nameValidator);
            rows[idx].setUniqueNameValidator(uniqueNameValidator);
            ++idx;
        }
    }

    protected ValidatorUniqueString setUniqueNameValidator(Object inputElement, ISystemValidator nameValidator) {
        ValidatorUniqueString uniqueNameValidator = null;
        ISystemRemoteElementAdapter ra = this.getRemoteAdapter(inputElement);
        boolean debug = false;
        String parentName = null;
        if (ra != null) {
            parentName = ra.getAbsoluteParentName(inputElement);
        }
        if (ra != null && parentName != null) {
            uniqueNameValidator = (ValidatorUniqueString)this.uniqueNameValidatorPerParent.get(parentName);
            if (uniqueNameValidator != null) {
                if (debug) {
                    System.out.println("Existing name list found for parent " + parentName);
                }
                return uniqueNameValidator;
            }
            if (debug) {
                System.out.println("No existing name list found for parent " + parentName);
            }
        }
        if (ra != null && parentName != null) {
            boolean needUniqueNameValidator;
            String[] names = null;
            boolean caseSensitive = ra.getSubSystem(inputElement).getSubSystemConfiguration().isCaseSensitive();
            boolean bl = needUniqueNameValidator = !(nameValidator instanceof ISystemValidatorUniqueString);
            if (!needUniqueNameValidator) {
                String[] existingNames = ((ISystemValidatorUniqueString)((Object)nameValidator)).getExistingNamesList();
                boolean bl2 = needUniqueNameValidator = existingNames == null || existingNames.length == 0;
            }
            if (needUniqueNameValidator) {
                super.setBusyCursor(true);
                try {
                    names = ra.getRemoteParentNamesInUse(inputElement, null);
                }
                catch (Exception exc) {
                    SystemBasePlugin.logError("Exception getting parent's child names in rename dialog", exc);
                }
                if (names != null && names.length > 0) {
                    uniqueNameValidator = new ValidatorUniqueString(names, caseSensitive);
                    uniqueNameValidator.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1006"), RSEUIPlugin.getPluginMessage("RSEG1007"));
                    this.uniqueNameValidatorPerParent.put(parentName, uniqueNameValidator);
                    if (debug) {
                        System.out.println("Name validator set. Names = ");
                        int idx = 0;
                        while (idx < names.length) {
                            System.out.println("..." + idx + ": " + names[idx]);
                            ++idx;
                        }
                    }
                }
                super.setBusyCursor(false);
            }
        }
        return uniqueNameValidator;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

