/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.util;

import java.util.Vector;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class ValidatorFileUniqueName
extends ValidatorUniqueString {
    protected SystemMessage msg_Invalid;
    private ValidatorFileName fileNameValidator = new ValidatorFileName();
    private ValidatorFolderName folderNameValidator = new ValidatorFolderName();
    protected IRemoteFile parentFolder;
    protected Vector names;
    protected boolean isFolder;

    public ValidatorFileUniqueName(Shell shell, IRemoteFile parentFolder, boolean isFolder) {
        super(null, parentFolder.getParentRemoteFileSubSystem().isCaseSensitive());
        this.parentFolder = parentFolder;
        this.isFolder = isFolder;
        this.init(shell);
    }

    private void init(Shell shell) {
        Cursor busyCursor = new Cursor((Device)shell.getDisplay(), 1);
        SystemPromptDialog.setDisplayCursor((Shell)shell, (Cursor)busyCursor);
        this.setErrorMessages(RSEUIPlugin.getPluginMessage((String)"RSEG1006"), RSEUIPlugin.getPluginMessage((String)"RSEG1007"), this.isFolder ? RSEUIPlugin.getPluginMessage((String)"RSEG1018") : RSEUIPlugin.getPluginMessage((String)"RSEG1019"));
        try {
            IRemoteFile[] contents = this.parentFolder.getParentRemoteFileSubSystem().listFoldersAndFiles(this.parentFolder, null);
            if (contents != null) {
                String[] names = new String[contents.length];
                int idx = 0;
                while (idx < names.length) {
                    names[idx] = contents[idx].getName();
                    ++idx;
                }
                this.setExistingNamesList(names);
            }
        }
        catch (SystemMessageException systemMessageException) {}
        SystemPromptDialog.setDisplayCursor((Shell)shell, null);
        busyCursor.dispose();
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    public SystemMessage isSyntaxOk(String newText) {
        if (!this.isFolder) {
            return this.getFileNameValidator().isSyntaxOk(newText);
        }
        return this.getFolderNameValidator().isSyntaxOk(newText);
    }

    protected ValidatorFileName getFileNameValidator() {
        if (this.fileNameValidator == null) {
            this.fileNameValidator = this.parentFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().getFileNameValidator();
        }
        return this.fileNameValidator;
    }

    protected ValidatorFolderName getFolderNameValidator() {
        if (this.folderNameValidator == null) {
            this.folderNameValidator = this.parentFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().getFolderNameValidator();
        }
        return this.folderNameValidator;
    }

    public int getMaximumNameLength() {
        if (this.isFolder) {
            return this.getFolderNameValidator().getMaximumNameLength();
        }
        return this.getFileNameValidator().getMaximumNameLength();
    }

    public String toString() {
        return "ValidatorFileFilterString class";
    }
}

