/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.servicesubsystem;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.subsystems.shells.core.ShellStrings;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.ui.progress.UIJob;

public class OutputRefreshJob
extends UIJob {
    private IRemoteCommandShell _command;
    private IRemoteOutput[] _outputs;
    private boolean _cwdChanged = false;
    private boolean _isComplete = false;

    public OutputRefreshJob(IRemoteCommandShell command, IRemoteOutput[] outputs, boolean cwdChanged) {
        super(ShellStrings.RSESubSystemOperation_Refresh_Output);
        this._command = command;
        this._cwdChanged = cwdChanged;
        this._outputs = outputs;
    }

    public void addOutputs(IRemoteOutput[] outputs) {
        IRemoteOutput[] oldOutputs = this._outputs;
        int total = oldOutputs.length + outputs.length;
        IRemoteOutput[] newOutputs = new IRemoteOutput[total];
        int k = 0;
        int i = 0;
        while (i < oldOutputs.length) {
            newOutputs[k] = oldOutputs[i];
            ++k;
            ++i;
        }
        int j = 0;
        while (j < outputs.length) {
            newOutputs[k] = outputs[j];
            ++k;
            ++j;
        }
        this._outputs = newOutputs;
    }

    public boolean isComplete() {
        return this._isComplete;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            if (this._outputs != null) {
                if (this._outputs.length > 0 && this._outputs[0] != null) {
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object[])this._outputs, 82, (Object)this._command));
                }
                if (this._cwdChanged) {
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._command, 86, (Object)this._command.getCommandSubSystem()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._isComplete = true;
        return Status.OK_STATUS;
    }
}

