/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Vector;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.internal.ui.view.SystemEmptyListAPIProviderImpl;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemLongRunningRequestListener;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.SystemLongRunningRequestEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public class SystemViewForm
extends Composite
implements ISystemTree {
    private ToolBar toolbar = null;
    private ToolBarManager toolbarMgr = null;
    private Button refreshButton;
    private Button getListButton;
    private SystemView tree = null;
    private ISystemMessageLine msgLine = null;
    private boolean showActions = true;
    private boolean deferLoading = false;
    private boolean requestInProgress = false;
    private ISystemViewInputProvider inputProvider = null;
    private ISystemViewInputProvider emptyProvider = new SystemEmptyListAPIProviderImpl();
    private Vector requestListeners = null;
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 300;
    protected Object caller;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected ViewerFilter[] initViewerFilters = null;

    public SystemViewForm(Shell shell, Composite parent, int style, ISystemViewInputProvider inputProvider, boolean singleSelectionMode, ISystemMessageLine msgLine) {
        this(shell, parent, style, inputProvider, singleSelectionMode, msgLine, 1, 1);
    }

    public SystemViewForm(Shell shell, Composite parent, int style, ISystemViewInputProvider inputProvider, boolean singleSelectionMode, ISystemMessageLine msgLine, int horizontalSpan, int verticalSpan) {
        this(shell, parent, style, inputProvider, singleSelectionMode, msgLine, horizontalSpan, verticalSpan, null);
    }

    public SystemViewForm(Shell shell, Composite parent, int style, ISystemViewInputProvider inputProvider, boolean singleSelectionMode, ISystemMessageLine msgLine, int horizontalSpan, int verticalSpan, ViewerFilter[] initViewerFilters) {
        super(parent, style);
        this.inputProvider = inputProvider;
        this.msgLine = msgLine;
        this.callerInstanceOfWizardPage = this.caller instanceof WizardPage;
        this.callerInstanceOfSystemPromptDialog = this.caller instanceof SystemPromptDialog;
        this.prepareComposite(1, horizontalSpan, verticalSpan);
        this.initViewerFilters = initViewerFilters;
        this.createSystemView(shell, inputProvider, singleSelectionMode);
    }

    public ToolBarManager getToolBarManager() {
        return this.toolbarMgr;
    }

    public SystemView getSystemView() {
        return this.tree;
    }

    public Tree getTreeControl() {
        return this.tree.getTree();
    }

    public void setToolTipText(String tip) {
        this.tree.getTree().setToolTipText(tip);
    }

    public void refresh() {
        this.tree.refreshAll();
    }

    public void reset(ISystemViewInputProvider inputProvider) {
        this.inputProvider = inputProvider;
        if (this.deferLoading) {
            this.tree.setSelection(null);
            this.tree.setInputProvider(this.emptyProvider);
        } else {
            this.tree.setSelection(null);
            this.tree.setInputProvider(inputProvider);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.toolbar != null) {
            this.toolbar.setEnabled(enabled);
        }
        this.tree.setEnabled(enabled);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tree.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tree.removeSelectionChangedListener(listener);
    }

    public void addListRequestListener(ISystemLongRunningRequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new Vector();
        }
        this.requestListeners.addElement(listener);
    }

    public void removeListRequestListener(ISystemLongRunningRequestListener listener) {
        if (this.requestListeners != null) {
            this.requestListeners.removeElement(listener);
        }
    }

    public ISelection getSelection() {
        return this.tree.getSelection();
    }

    public boolean areAnySelectedItemsExpanded() {
        return this.tree.areAnySelectedItemsExpanded();
    }

    public boolean areAnySelectedItemsExpandable() {
        return this.tree.areAnySelectedItemsExpandable();
    }

    public boolean sameParent() {
        return this.tree.sameParent();
    }

    public Object getSelectedParent() {
        return this.tree.getSelectedParent();
    }

    public Object getPreviousElement() {
        return this.tree.getPreviousElement();
    }

    public Object getNextElement() {
        return this.tree.getNextElement();
    }

    public Object getRootParent() {
        return this.tree.getRootParent();
    }

    public Object[] getElementNodes(Object element) {
        return this.tree.getElementNodes(element);
    }

    public boolean isSelectedOrChildSelected(Object parentElement) {
        return this.tree.isSelectedOrChildSelected(parentElement);
    }

    public int getChildCount(Object element) {
        return this.tree.getChildCount(element);
    }

    public void updatePropertySheet() {
        this.tree.updatePropertySheet();
    }

    public void select(Object element, boolean expand) {
        this.tree.select(element, expand);
    }

    public Item getViewerItem() {
        return this.tree.getViewerItem();
    }

    public boolean okToClose() {
        return !this.requestInProgress;
    }

    protected Composite prepareComposite(int numColumns, int horizontalSpan, int verticalSpan) {
        SystemViewForm composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 300;
        data.heightHint = 300;
        data.horizontalSpan = horizontalSpan;
        data.verticalSpan = verticalSpan;
        composite.setLayoutData(data);
        return composite;
    }

    protected void createSystemView(Shell shell, ISystemViewInputProvider inputProvider, boolean singleSelectionMode) {
        int style = (singleSelectionMode ? 4 : 2) | 0x100 | 0x200 | 0x800;
        this.tree = new SystemView(shell, this, style, this.deferLoading ? this.emptyProvider : inputProvider, this.msgLine, this.initViewerFilters);
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.widthHint = 300;
        treeData.heightHint = 200;
        this.tree.getTree().setLayoutData((Object)treeData);
        this.tree.setShowActions(this.showActions);
    }

    protected void addOurMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
            }
        };
        this.toolbar.addMouseListener((MouseListener)mouseListener);
    }

    protected void fireRequestStartEvent() {
        if (this.requestListeners != null) {
            SystemLongRunningRequestEvent event = new SystemLongRunningRequestEvent();
            int idx = 0;
            while (idx < this.requestListeners.size()) {
                ((ISystemLongRunningRequestListener)this.requestListeners.elementAt(idx)).startingLongRunningRequest(event);
                ++idx;
            }
        }
    }

    protected void fireRequestStopEvent() {
        if (this.requestListeners != null) {
            SystemLongRunningRequestEvent event = new SystemLongRunningRequestEvent();
            int idx = 0;
            while (idx < this.requestListeners.size()) {
                ((ISystemLongRunningRequestListener)this.requestListeners.elementAt(idx)).endingLongRunningRequest(event);
                ++idx;
            }
        }
    }
}

