/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.scratchpad;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonSelectAllAction;
import org.eclipse.rse.internal.ui.actions.SystemOpenExplorerPerspectiveAction;
import org.eclipse.rse.internal.ui.actions.SystemShowInTableAction;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewDataDragAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewDataDropAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.internal.ui.view.scratchpad.ClearAction;
import org.eclipse.rse.internal.ui.view.scratchpad.ClearSelectedAction;
import org.eclipse.rse.internal.ui.view.scratchpad.SystemScratchpadViewProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemSelectAllTarget;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.PluginTransfer;

public class SystemScratchpadView
extends TreeViewer
implements IMenuListener,
ISystemDeleteTarget,
ISystemRenameTarget,
ISystemSelectAllTarget,
ISystemShellProvider,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
ISelectionChangedListener,
ISelectionProvider {
    private Object _objectInput;
    private TableLayout _layout;
    private SystemScratchpadViewProvider _provider;
    private MenuManager _menuManager;
    protected SystemRefreshAction _refreshAction;
    protected PropertyDialogAction _propertyDialogAction;
    protected SystemOpenExplorerPerspectiveAction _openToPerspectiveAction;
    protected SystemShowInTableAction _showInTableAction;
    protected SystemCommonDeleteAction _deleteAction;
    protected SystemCommonRenameAction _renameAction;
    protected SystemCommonSelectAllAction _selectAllAction;
    protected ClearSelectedAction _clearSelectedAction;
    protected ClearAction _clearAllAction;
    protected boolean _selectionShowRefreshAction;
    protected boolean _selectionShowOpenViewActions;
    protected boolean _selectionShowDeleteAction;
    protected boolean _selectionShowRenameAction;
    protected boolean _selectionEnableDeleteAction;
    protected boolean _selectionEnableRenameAction;
    protected boolean _selectionIsRemoteObject = true;
    protected boolean _selectionFlagsUpdated = false;
    private ISystemMessageLine _messageLine;
    protected boolean menuListenerAdded = false;
    private static final int LEFT_BUTTON = 1;
    private int mouseButtonPressed = 1;
    static /* synthetic */ Class class$0;

    public SystemScratchpadView(Tree tableTree, ISystemMessageLine msgLine) {
        super(tableTree);
        this._messageLine = msgLine;
        this._layout = new TableLayout();
        this._provider = new SystemScratchpadViewProvider(this);
        this.setContentProvider((IContentProvider)this._provider);
        IWorkbench wb = PlatformUI.getWorkbench();
        this.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this._provider, wb.getDecoratorManager().getLabelDecorator()));
        this._menuManager = new MenuManager("#PopupMenu");
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener((IMenuListener)this);
        Menu menu = this._menuManager.createContextMenu((Control)tableTree);
        tableTree.setMenu(menu);
        this.addSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.addSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        this.initDragAndDrop();
        tableTree.setVisible(false);
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemScratchpadView.this.handleKeyPressed(e);
            }
        });
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemScratchpadView.this.mouseButtonPressed = e.button;
            }
        });
    }

    public Layout getLayout() {
        return this._layout;
    }

    public Menu getContextMenu() {
        return this.getTree().getMenu();
    }

    public MenuManager getContextMenuManager() {
        return this._menuManager;
    }

    public void inputChanged(Object newObject, Object oldObject) {
        if (newObject instanceof IAdaptable) {
            this.getTree().setVisible(true);
            this._objectInput = newObject;
            super.inputChanged(newObject, oldObject);
        } else if (newObject == null) {
            this.getTree().setVisible(false);
            this._objectInput = null;
        }
    }

    public Object getInput() {
        return this._objectInput;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object obj) {
        return SystemAdapterHelpers.getViewAdapter(obj);
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{PluginTransfer.getInstance(), TextTransfer.getInstance(), EditorInputTransfer.getInstance(), FileTransfer.getInstance()};
        this.addDragSupport(ops, transfers, (DragSourceListener)new SystemViewDataDragAdapter(this));
        this.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new SystemViewDataDropAdapter((StructuredViewer)this));
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        SystemScratchpadViewProvider provider;
        Object parent = event.getParent();
        Object child = event.getSource();
        int eventType = event.getType();
        switch (eventType) {
            case 15: 
            case 25: 
            case 43: {
                if (!(child instanceof ISystemFilter)) break;
                IRSEBaseReferencingObject[] references = ((ISystemFilter)child).getReferencingObjects();
                int i = 0;
                while (i < references.length) {
                    IRSEBaseReferencingObject ref = references[i];
                    Widget w = this.findItem(ref);
                    if (w != null) {
                        this.internalRefresh(ref);
                    }
                    ++i;
                }
                break;
            }
            case 81: 
            case 86: 
            case 87: {
                Widget w = this.findItem(child);
                if (w == null) break;
                this.updateItem(w, child);
                break;
            }
            case 50: 
            case 53: {
                SystemScratchpadViewProvider provider2;
                boolean addingConnection = child instanceof IHost;
                if (!(this._objectInput instanceof ISystemRegistry) || !addingConnection || (provider2 = (SystemScratchpadViewProvider)this.getContentProvider()) == null) break;
                this.internalRefresh(this._objectInput);
                break;
            }
            case 82: {
                this.internalRefresh(parent);
                break;
            }
            case 83: {
                IStructuredSelection sel = (IStructuredSelection)this.getSelection();
                Iterator iter = sel.iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    this.internalRefresh(obj);
                }
                break;
            }
            case 65: {
                Widget w = this.findItem(child);
                if (w == null) break;
                this.updateItem(w, child);
                break;
            }
            case 55: 
            case 60: {
                Widget w;
                if (!(child instanceof ISystemFilterReference) || (w = this.findItem(child)) == null) break;
                this.remove(child);
                SystemRegistryUI.getInstance().getSystemScratchPad().removeChild(child);
                break;
            }
        }
        if ((child == this._objectInput || parent == this._objectInput) && (provider = (SystemScratchpadViewProvider)this.getContentProvider()) != null) {
            try {
                this.internalRefresh(this._objectInput);
            }
            catch (Exception e) {
                SystemBasePlugin.logError(e.getMessage());
            }
        }
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        String remoteResourceName;
        int eventType = event.getEventType();
        Object remoteResourceParent = event.getResourceParent();
        Object remoteResource = event.getResource();
        List remoteResourceNames = null;
        if (remoteResource instanceof List) {
            remoteResourceNames = (List)remoteResource;
            remoteResource = remoteResourceNames.get(0);
        }
        if ((remoteResourceName = this.getRemoteResourceAbsoluteName(remoteResource)) == null) {
            return;
        }
        SystemScratchpadViewProvider provider = (SystemScratchpadViewProvider)this.getContentProvider();
        switch (eventType) {
            case 4: {
                Widget w;
                if (remoteResourceParent != this.getInput() || (w = this.findItem(remoteResource)) == null) break;
                this.updateItem(w, remoteResource);
                break;
            }
            case 1: {
                this.internalRefresh(remoteResourceParent);
                break;
            }
            case 2: {
                if (remoteResourceParent != null) {
                    this.internalRefresh(remoteResourceParent);
                    break;
                }
                this.remove(remoteResource);
                break;
            }
            case 8: {
                Widget widget;
                Object child = event.getResource();
                if (provider == null || (widget = this.findItem(child)) == null) break;
                widget.setData(child);
                this.updateItem(widget, child);
                return;
            }
        }
    }

    private String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else {
            ISystemViewElementAdapter ra = this.getViewAdapter(remoteResource);
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    public void displayMessage(String msg) {
        if (this._messageLine != null) {
            this._messageLine.setMessage(msg);
        }
    }

    public void clearMessage() {
        if (this._messageLine != null) {
            this._messageLine.clearMessage();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object firstSelection = sel.getFirstElement();
        if (firstSelection == null) {
            return;
        }
        this._selectionFlagsUpdated = false;
        ISystemViewElementAdapter adapter = this.getViewAdapter(firstSelection);
        if (adapter != null) {
            this.displayMessage(adapter.getStatusLineText(firstSelection));
            if (this.mouseButtonPressed == 1) {
                adapter.selectionChanged(firstSelection);
            }
        } else {
            this.clearMessage();
        }
    }

    public void dispose() {
        this.removeAsListener();
        Tree tree = this.getTree();
        boolean isDisposed = tree.isDisposed();
        if (!isDisposed) {
            tree.dispose();
        }
    }

    public void removeAsListener() {
        this.removeSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.removeSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
    }

    protected PropertyDialogAction getPropertyDialogAction() {
        if (this._propertyDialogAction == null) {
            this._propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this);
        }
        this._propertyDialogAction.selectionChanged(this.getSelection());
        return this._propertyDialogAction;
    }

    protected IAction getSelectAllAction() {
        if (this._selectAllAction == null) {
            this._selectAllAction = new SystemCommonSelectAllAction(this.getShell(), this, this);
        }
        return this._selectAllAction;
    }

    protected IAction getRenameAction() {
        if (this._renameAction == null) {
            this._renameAction = new SystemCommonRenameAction(this.getShell(), this);
        }
        return this._renameAction;
    }

    protected IAction getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = new SystemCommonDeleteAction(this.getShell(), this);
        }
        return this._deleteAction;
    }

    protected IAction getClearSelectedAction() {
        if (this._clearSelectedAction == null) {
            this._clearSelectedAction = new ClearSelectedAction(this);
        }
        this._clearSelectedAction.checkEnabledState();
        return this._clearSelectedAction;
    }

    protected IAction getClearAllAction() {
        if (this._clearAllAction == null) {
            this._clearAllAction = new ClearAction(this);
        }
        this._clearAllAction.checkEnabledState();
        return this._clearAllAction;
    }

    protected IAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = new SystemRefreshAction(this.getShell());
        }
        return this._refreshAction;
    }

    protected SystemOpenExplorerPerspectiveAction getOpenToPerspectiveAction() {
        if (this._openToPerspectiveAction == null) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchWindow win = desktop.getActiveWorkbenchWindow();
            this._openToPerspectiveAction = new SystemOpenExplorerPerspectiveAction(this.getShell(), win);
        }
        return this._openToPerspectiveAction;
    }

    protected SystemShowInTableAction getShowInTableAction() {
        if (this._showInTableAction == null) {
            this._showInTableAction = new SystemShowInTableAction(this.getShell());
        }
        return this._showInTableAction;
    }

    public Shell getShell() {
        return this.getTree().getShell();
    }

    public boolean showDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowDeleteAction;
    }

    public boolean canDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableDeleteAction;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        boolean ok = true;
        boolean anyOk = false;
        Vector deletedVector = new Vector();
        try {
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getViewAdapter(element);
                ok = adapter.doDelete(this.getShell(), element, monitor);
                if (!ok) continue;
                anyOk = true;
                deletedVector.addElement(element);
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1063").makeSubstitution(element, (Object)msg));
            ok = false;
        }
        if (anyOk) {
            Object[] deleted = new Object[deletedVector.size()];
            int idx = 0;
            while (idx < deleted.length) {
                deleted[idx] = deletedVector.elementAt(idx);
                ++idx;
            }
            if (this._selectionIsRemoteObject) {
                sr.fireRemoteResourceChangeEvent(2, deletedVector, null, null, null, (Object)this);
            } else {
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(deleted, 60, this.getInput()));
            }
        }
        return ok;
    }

    public boolean showRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowRenameAction;
    }

    public boolean canRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableRenameAction;
    }

    protected Object getParentForContent(Object element) {
        return this._objectInput;
    }

    public boolean doRename(String[] newNames) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        ISystemRemoteElementAdapter remoteAdapter = null;
        String oldFullName = null;
        boolean ok = true;
        try {
            int nameIdx = 0;
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getViewAdapter(element);
                Object parentElement = this.getParentForContent(element);
                remoteAdapter = this.getRemoteAdapter(element);
                if (remoteAdapter != null) {
                    oldFullName = remoteAdapter.getAbsoluteName(element);
                }
                if (!(ok = adapter.doRename(this.getShell(), element, newNames[nameIdx++]))) continue;
                if (remoteAdapter != null) {
                    sr.fireRemoteResourceChangeEvent(8, element, parentElement, remoteAdapter.getSubSystem(element), oldFullName, (Object)this);
                    continue;
                }
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(element, 65, parentElement));
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1064").makeSubstitution(element, (Object)exc), exc);
            ok = false;
        }
        return ok;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        ISystemRemoteElementAdapter adapter = null;
        if (!(o instanceof IAdaptable)) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemRemoteElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
        } else {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz);
        }
        if (adapter != null && adapter instanceof ISystemViewElementAdapter) {
            ((ISystemViewElementAdapter)((Object)adapter)).setViewer((Viewer)this);
        }
        return adapter;
    }

    public boolean enableSelectAll(IStructuredSelection selection) {
        return true;
    }

    public void doSelectAll(IStructuredSelection selection) {
        Tree tree;
        Tree theTree = tree = this.getTree();
        theTree.setSelection(theTree.getItems());
        TreeItem[] items = theTree.getItems();
        Object[] objects = new Object[items.length];
        int idx = 0;
        while (idx < items.length) {
            objects[idx] = items[idx].getData();
            ++idx;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(objects)));
    }

    public void menuAboutToShow(IMenuManager manager) {
        Menu m;
        SystemView.createStandardGroups(manager);
        if (!this.menuListenerAdded && manager instanceof MenuManager && (m = ((MenuManager)manager).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            if (this._messageLine != null) {
                ml.setShowToolTipText(true, this._messageLine);
            }
            m.addMenuListener((MenuListener)ml);
        }
        this.fillContextMenu(manager);
    }

    public ISelection getSelection() {
        ISelection selection = super.getSelection();
        if (selection == null || selection.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this._objectInput != null) {
                list.add(this._objectInput);
                selection = new StructuredSelection(list);
            }
        }
        return selection;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        boolean allSelectionsFromSameParent = true;
        int selectionCount = selection.size();
        if (selectionCount == 0) {
            return;
        }
        if (selectionCount == 1) {
            selection.getFirstElement();
            this.getInput();
        }
        if (selectionCount > 1 && !(allSelectionsFromSameParent = this.sameParent()) && this.selectionHasAncestryRelationship()) {
            SystemView.createStandardGroups(menu);
            return;
        }
        SystemView.createStandardGroups(menu);
        if (this.showRefresh()) {
            menu.appendToGroup("group.build", this.getRefreshAction());
        }
        if (this.canRename() && this.showRename()) {
            menu.appendToGroup("group.reorganize", this.getRenameAction());
        }
        SystemMenuManager ourMenu = new SystemMenuManager(menu);
        Iterator elements = selection.iterator();
        Hashtable adapters = new Hashtable();
        while (elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getViewAdapter(element);
            if (adapter == null) continue;
            adapters.put(adapter, element);
        }
        Enumeration uniqueAdapters = adapters.keys();
        Shell shell = this.getShell();
        while (uniqueAdapters.hasMoreElements()) {
            ISystemViewElementAdapter nextAdapter = (ISystemViewElementAdapter)uniqueAdapters.nextElement();
            nextAdapter.addActions(ourMenu, selection, shell, "group.adapters");
            if (!(nextAdapter instanceof AbstractSystemViewAdapter)) continue;
            AbstractSystemViewAdapter aVA = (AbstractSystemViewAdapter)nextAdapter;
            aVA.addCommonRemoteActions(ourMenu, selection, shell, "group.adapters");
            aVA.addDynamicPopupMenuActions(ourMenu, selection, shell, "additions");
        }
        IContributionItem[] items = menu.getItems();
        int idx = 0;
        while (idx < items.length) {
            Object item;
            if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                item.setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            } else if (items[idx] instanceof SystemSubMenuManager) {
                item = (SystemSubMenuManager)items[idx];
                ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            }
            ++idx;
        }
        if (this.canDelete() && this.showDelete()) {
            menu.appendToGroup("group.reorganize", this.getDeleteAction());
            ((ISystemAction)this.getDeleteAction()).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
            menu.add((IContributionItem)new Separator());
        }
        menu.appendToGroup("additions", this.getClearSelectedAction());
        menu.appendToGroup("additions", this.getClearAllAction());
        PropertyDialogAction pdAction = this.getPropertyDialogAction();
        if (pdAction.isApplicableForSelection()) {
            menu.appendToGroup("group.properties", (IAction)pdAction);
        }
        if (!this._selectionIsRemoteObject) {
            SystemOpenExplorerPerspectiveAction openToPerspectiveAction = this.getOpenToPerspectiveAction();
            SystemShowInTableAction showInTableAction = this.getShowInTableAction();
            openToPerspectiveAction.setSelection((ISelection)selection);
            showInTableAction.setSelection((ISelection)selection);
            menu.appendToGroup("group.open", (IAction)openToPerspectiveAction);
            menu.appendToGroup("group.open", (IAction)showInTableAction);
        }
    }

    protected boolean showRefresh() {
        return this._selectionShowRefreshAction;
    }

    public boolean sameParent() {
        boolean same = true;
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        if (items == null || items.length == 0) {
            return true;
        }
        TreeItem prevParent = null;
        TreeItem currParent = null;
        int idx = 0;
        while (idx < items.length) {
            currParent = items[idx].getParentItem();
            if (idx > 0 && currParent != prevParent) {
                same = false;
                break;
            }
            prevParent = currParent;
            ++idx;
        }
        return same;
    }

    private boolean selectionHasAncestryRelationship() {
        Tree tree = this.getTree();
        TreeItem[] items = tree.getSelection();
        int idx = 0;
        while (idx < items.length) {
            TreeItem item = items[idx];
            int c = 0;
            while (c < items.length) {
                if (item != items[c] && this.isAncestorOf(item, items[c], false)) {
                    return true;
                }
                ++c;
            }
            ++idx;
        }
        return false;
    }

    private boolean isAncestorOf(TreeItem container, TreeItem item, boolean direct) {
        TreeItem parent;
        TreeItem[] children = null;
        children = !direct ? ((parent = container.getParentItem()) != null ? parent.getItems() : this.getTree().getItems()) : container.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem child = children[i];
            if (child == item && direct) {
                return true;
            }
            if (child.getItemCount() > 0 && this.isAncestorOf(child, item, true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void scanSelections() {
        this._selectionShowRefreshAction = true;
        this._selectionShowOpenViewActions = true;
        this._selectionShowDeleteAction = true;
        this._selectionShowRenameAction = true;
        this._selectionEnableDeleteAction = true;
        this._selectionEnableRenameAction = true;
        this._selectionIsRemoteObject = true;
        this._selectionFlagsUpdated = true;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            Object element = elements.next();
            ISystemViewElementAdapter adapter = this.getViewAdapter(element);
            if (adapter == null) continue;
            if (this._selectionShowRefreshAction) {
                this._selectionShowRefreshAction = adapter.showRefresh(element);
            }
            if (this._selectionShowOpenViewActions) {
                this._selectionShowOpenViewActions = adapter.showOpenViewActions(element);
            }
            if (this._selectionShowDeleteAction) {
                this._selectionShowDeleteAction = adapter.showDelete(element);
            }
            if (this._selectionShowRenameAction) {
                this._selectionShowRenameAction = adapter.showRename(element);
            }
            if (this._selectionEnableDeleteAction) {
                boolean bl = this._selectionEnableDeleteAction = this._selectionShowDeleteAction && adapter.canDelete(element);
            }
            if (this._selectionEnableRenameAction) {
                boolean bl = this._selectionEnableRenameAction = this._selectionShowRenameAction && adapter.canRename(element);
            }
            if (!this._selectionIsRemoteObject) continue;
            boolean bl = this._selectionIsRemoteObject = this.getRemoteAdapter(element) != null;
        }
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.scanSelections();
            if (this.showDelete() && this.canDelete()) {
                SystemCommonDeleteAction dltAction = (SystemCommonDeleteAction)this.getDeleteAction();
                dltAction.setShell(this.getShell());
                dltAction.setSelection(this.getSelection());
                dltAction.setViewer((Viewer)this);
                dltAction.run();
            }
        }
    }

    protected void createChildren(final Widget widget) {
        if (widget instanceof TreeItem) {
            Object data;
            final Item[] tis = this.getChildren(widget);
            if (tis != null && tis.length > 0 && (data = tis[0].getData()) != null) {
                return;
            }
            BusyIndicator.showWhile((Display)widget.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    IContextObject parentElement;
                    Object[] children;
                    Object d;
                    if (tis != null) {
                        int i = 0;
                        while (i < tis.length) {
                            if (tis[i].getData() != null) {
                                SystemScratchpadView.this.disassociate(tis[i]);
                                Assert.isTrue((tis[i].getData() == null ? 1 : 0) != 0, (String)"Second or later child is non -null");
                            }
                            tis[i].dispose();
                            ++i;
                        }
                    }
                    if ((d = widget.getData()) != null && (children = SystemScratchpadView.this.getSortedChildren(parentElement = SystemScratchpadView.this.getContextObject((TreeItem)widget))) != null) {
                        int i = 0;
                        while (i < children.length) {
                            SystemScratchpadView.this.createTreeItem(widget, children[i], -1);
                            ++i;
                        }
                    }
                }
            });
        } else {
            super.createChildren(widget);
        }
    }

    public ISystemFilterReference getContainingFilterReference(TreeItem item) {
        Object data = item.getData();
        if (data instanceof ISystemFilterReference) {
            return (ISystemFilterReference)data;
        }
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            return this.getContainingFilterReference(parent);
        }
        Object input = this.getInput();
        if (input instanceof ISystemFilterReference) {
            return (ISystemFilterReference)input;
        }
        return null;
    }

    public ISubSystem getContainingSubSystem(TreeItem item) {
        Object data = item.getData();
        if (data instanceof ISubSystem) {
            return (ISubSystem)data;
        }
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            return this.getContainingSubSystem(parent);
        }
        Object input = this.getInput();
        if (input instanceof ISubSystem) {
            return (ISubSystem)input;
        }
        return null;
    }

    public IContextObject getContextObject(TreeItem item) {
        Object data = item.getData();
        ISystemFilterReference filterReference = this.getContainingFilterReference(item);
        if (filterReference != null) {
            return new ContextObject(data, filterReference.getSubSystem(), filterReference);
        }
        ISubSystem subSystem = this.getContainingSubSystem(item);
        if (subSystem != null) {
            return new ContextObject(data, subSystem);
        }
        return new ContextObject(data);
    }

    public void add(Object parentElementOrTreePath, Object[] childElements) {
        Assert.isNotNull((Object)parentElementOrTreePath);
        this.assertElementsNotNull(childElements);
        if (parentElementOrTreePath instanceof IContextObject) {
            parentElementOrTreePath = ((IContextObject)parentElementOrTreePath).getModelObject();
        }
        super.add(parentElementOrTreePath, childElements);
    }
}

