/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.shells.dstore;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostOutput;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostShell;
import org.eclipse.rse.internal.services.dstore.shells.DStoreShellOutputReader;
import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.RemoteError;
import org.eclipse.rse.subsystems.shells.core.model.RemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;

public class DStoreServiceCommandShell
extends ServiceCommandShell {
    public DStoreServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
    }

    public Object getContext() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DStoreShellOutputReader reader = (DStoreShellOutputReader)shell.getStandardOutputReader();
        String workingDir = reader.getWorkingDirectory();
        if (workingDir != null && workingDir.length() > 0) {
            try {
                IRemoteFileSubSystem ss = this.getFileSubSystem();
                if (ss.isConnected()) {
                    return ss.getRemoteFileObject(workingDir, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public String getContextString() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DStoreShellOutputReader reader = (DStoreShellOutputReader)shell.getStandardOutputReader();
        return reader.getWorkingDirectory();
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            Object output = null;
            IHostOutput lineObj = lines[i];
            if (lineObj instanceof DStoreHostOutput) {
                DataElement line = ((DStoreHostOutput)lineObj).getElement();
                String type = line.getType();
                String src = line.getSource();
                output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
                output.setText(line.getName());
                int colonSep = src.indexOf(58);
                if (colonSep > 0) {
                    String lineNo = src.substring(colonSep + 1);
                    String file = src.substring(0, colonSep);
                    int linen = 0;
                    try {
                        linen = Integer.parseInt(lineNo);
                    }
                    catch (Exception exception) {}
                    if (linen != 0) {
                        output.setAbsolutePath(file);
                        output.setLine(linen);
                    } else {
                        output.setAbsolutePath(src);
                    }
                } else {
                    output.setAbsolutePath(src);
                }
                this.addOutput(output);
                outputs[i] = output;
            }
            ++i;
        }
        this._lastRefreshJob = new OutputRefreshJob((IRemoteCommandShell)this, outputs, false);
        this._lastRefreshJob.schedule();
    }

    public boolean isActive() {
        boolean activeShell = this._hostShell.isActive();
        if (!activeShell) {
            DataElement status = ((DStoreHostShell)this._hostShell).getStatus();
            if (this._output.size() < status.getNestedSize()) {
                return true;
            }
        }
        return activeShell;
    }
}

