/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;

public class DStoreInputStream
extends InputStream {
    private DataStore _dataStore;
    private String _remotePath;
    private DataElement _minerElement;
    private String _encoding;
    private int _mode;
    private DataElement _cmdStatus;
    private File _localFile;
    private InputStream _localFileInputStream;

    public DStoreInputStream(DataStore dataStore, String remotePath, DataElement minerElement, String encoding, int mode) {
        this._dataStore = dataStore;
        this._remotePath = remotePath;
        this._minerElement = minerElement;
        this._encoding = encoding;
        this._mode = mode;
        this.initDownload();
    }

    protected void initDownload() {
        DataStore ds = this._dataStore;
        DataElement universaltemp = this._minerElement;
        DataElement de = this._dataStore.createObject(universaltemp, "universal.FileObject", this._remotePath, this._remotePath, "", false);
        try {
            this._localFile = File.createTempFile("download", "rse");
            DataElement remoteElement = ds.createObject(universaltemp, de.getType(), this._remotePath, String.valueOf(this._mode));
            DataElement localElement = ds.createObject(universaltemp, de.getType(), this._localFile.getAbsolutePath(), this._encoding);
            DataElement bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "10240", "");
            DataElement queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
            ArrayList<DataElement> argList = new ArrayList<DataElement>();
            argList.add(remoteElement);
            argList.add(localElement);
            argList.add(bufferSizeElement);
            DataElement subject = ds.createObject(universaltemp, de.getType(), this._remotePath, String.valueOf(this._mode));
            this._cmdStatus = ds.command(queryCmd, argList, subject);
            this.waitForTempFile();
            this._localFileInputStream = new FileInputStream(this._localFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected DataStore getDataStore() {
        return this._dataStore;
    }

    protected DataElement getCommandDescriptor(DataElement subject, String command) {
        DataElement cmd = this._dataStore.localDescriptorQuery(subject.getDescriptor(), command);
        return cmd;
    }

    public void close() throws IOException {
        if (this._localFileInputStream != null) {
            this._localFileInputStream.close();
        }
    }

    protected void waitForTempFile() {
        if (this._localFile != null) {
            while (this._localFile.length() == 0L) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public int read() throws IOException {
        if (this._localFileInputStream != null) {
            int result = this._localFileInputStream.read();
            return result;
        }
        return 0;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._localFileInputStream != null) {
            int result = this._localFileInputStream.read(b, off, len);
            return result;
        }
        return 0;
    }

    public int read(byte[] b) throws IOException {
        if (this._localFileInputStream != null) {
            int result = this._localFileInputStream.read(b);
            return result;
        }
        return 0;
    }

    public int available() throws IOException {
        if (this._localFileInputStream != null) {
            return this._localFileInputStream.available();
        }
        return 0;
    }

    public synchronized void mark(int readlimit) {
        if (this._localFileInputStream != null) {
            this._localFileInputStream.mark(readlimit);
        }
    }

    public boolean markSupported() {
        if (this._localFileInputStream != null) {
            return this._localFileInputStream.markSupported();
        }
        return false;
    }

    public synchronized void reset() throws IOException {
        if (this._localFileInputStream != null) {
            this._localFileInputStream.reset();
        }
    }

    public long skip(long n) throws IOException {
        if (this._localFileInputStream != null) {
            return this._localFileInputStream.skip(n);
        }
        return 0L;
    }
}

