/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.internal.testsubsystem;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.ui.view.SystemPerspectiveHelpers;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.testsubsystem.TestSubSystemAddAction;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemAddTarget;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNode;
import org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNodeContainer;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TestSubSystemNodeAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter,
ITestSubSystemAddTarget {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.internal.testsubsystem.TestSubSystemNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
        if (selection.size() == 1 && this.isTestSubSystemNodeContainer(selection.getFirstElement()) && this.canAdd(selection.getFirstElement())) {
            menu.add(menuGroup, (IAction)new TestSubSystemAddAction("Add branch", true, this.getShell()));
            menu.add(menuGroup, (IAction)new TestSubSystemAddAction("Add leaf", false, this.getShell()));
        }
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        if (this.isTestSubSystemNodeContainer(element)) {
            return RSETestsPlugin.getDefault().getImageDescriptor("ICON_ID_BRANCH");
        }
        if (this.isTestSubSystemNode(element)) {
            return RSETestsPlugin.getDefault().getImageDescriptor("ICON_ID_LEAF");
        }
        return null;
    }

    public String getText(Object element) {
        if (this.isTestSubSystemNode(element)) {
            return ((ITestSubSystemNode)element).getName();
        }
        return null;
    }

    public String getAbsoluteName(Object element) {
        if (!$assertionsDisabled && !this.isTestSubSystemNode(element)) {
            throw new AssertionError();
        }
        ITestSubSystemNode node = (ITestSubSystemNode)element;
        String absName = node.getName();
        node = node.getParent();
        while (node != null) {
            absName = String.valueOf(node.getName()) + "/" + absName;
            node = node.getParent();
        }
        return absName;
    }

    public String getType(Object element) {
        if (this.isTestSubSystemNodeContainer(element)) {
            return "testSubSystemContainerNode";
        }
        if (this.isTestSubSystemNode(element)) {
            return "testSubSystemNode";
        }
        return "unknown";
    }

    public Object getParent(Object element) {
        if (this.isTestSubSystemNode(element)) {
            return ((ITestSubSystemNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        if (this.isTestSubSystemNodeContainer(element)) {
            return ((ITestSubSystemNodeContainer)element).hasChildNodes();
        }
        return false;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        if (this.isTestSubSystemNodeContainer(element)) {
            return ((ITestSubSystemNodeContainer)element).getChildNodes();
        }
        return null;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return null;
    }

    protected Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getAbsoluteParentName(Object element) {
        if (this.isTestSubSystemNode(element) && ((ITestSubSystemNode)element).getParent() != null) {
            return ((ITestSubSystemNode)element).getParent().getName();
        }
        return null;
    }

    public String getSubSystemConfigurationId(Object element) {
        return "testSubSystemConfigurationId";
    }

    public String getRemoteTypeCategory(Object element) {
        return "testCategory";
    }

    public String getRemoteType(Object element) {
        return "testType";
    }

    public String getRemoteSubType(Object element) {
        return "testSubType";
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        ITestSubSystemNode oldNode = (ITestSubSystemNode)oldElement;
        ITestSubSystemNode newNode = (ITestSubSystemNode)newElement;
        newNode.setName(oldNode.getName());
        return false;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        if (this.isTestSubSystemNode(element)) {
            return ((ITestSubSystemNode)element).getParent();
        }
        return null;
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public boolean supportsUserDefinedActions(Object object) {
        return true;
    }

    public boolean canDelete(Object element) {
        return this.isTestSubSystemNode(element);
    }

    public boolean showDelete(Object element) {
        return true;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        if (this.isTestSubSystemNode(element)) {
            ITestSubSystemNodeContainer parent = (ITestSubSystemNodeContainer)((Object)((ITestSubSystemNode)element).getParent());
            if (parent == null) {
                parent = (ITestSubSystemNodeContainer)((ITestSubSystemNode)element).getSubSystem();
            }
            if (parent != null && this.isTestSubSystemNodeContainer(parent)) {
                return parent.removeChildNode((ITestSubSystemNode)element);
            }
        }
        return false;
    }

    private boolean isTestSubSystemNode(Object element) {
        return element instanceof ITestSubSystemNode;
    }

    private boolean isTestSubSystemNodeContainer(Object element) {
        return element instanceof ITestSubSystemNodeContainer;
    }

    public boolean canAdd(Object element) {
        return this.isTestSubSystemNodeContainer(element);
    }

    public boolean doAdd(Shell shell, Object container, Object element, IProgressMonitor monitor) {
        SystemView view;
        boolean added = false;
        if (this.isTestSubSystemNodeContainer(container) && this.isTestSubSystemNode(element) && (added = ((ITestSubSystemNodeContainer)container).addChildNode((ITestSubSystemNode)element)) && (view = SystemPerspectiveHelpers.findRSEView()) != null) {
            view.expandSelected();
            view.refresh(container);
        }
        return false;
    }

    public boolean showAdd(Object element) {
        return this.isTestSubSystemNodeContainer(element);
    }

    public boolean canRename(Object element) {
        return this.isTestSubSystemNode(element);
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        String oldName;
        if (name != null && this.isTestSubSystemNode(element) && ((oldName = ((ITestSubSystemNode)element).getName()) == null || !oldName.equals(name))) {
            ((ITestSubSystemNode)element).setName(name);
            return true;
        }
        return false;
    }

    public boolean showRename(Object element) {
        return this.isTestSubSystemNode(element);
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

