/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.ui.mnemonics;

import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;

public class MnemonicsTest
extends RSECoreTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDefaultGeneration() {
        Mnemonics mn = new Mnemonics();
        mn.clear("abcde");
        String result = mn.setUniqueMnemonic("A...");
        MnemonicsTest.assertEquals((String)"A...", (String)result);
        result = mn.setUniqueMnemonic("F...");
        MnemonicsTest.assertEquals((String)"&F...", (String)result);
    }

    public void testAppendPolicies() {
        this.setLocalePattern(".*");
        Mnemonics mn = new Mnemonics();
        mn.clear("abcde");
        String result = mn.setUniqueMnemonic("A...");
        MnemonicsTest.assertEquals((String)"A(&F)...", (String)result);
        result = mn.setUniqueMnemonic("F...");
        MnemonicsTest.assertEquals((String)"F(&G)...", (String)result);
        result = mn.setUniqueMnemonic("H...");
        MnemonicsTest.assertEquals((String)"&H...", (String)result);
    }

    private void setLocalePattern(String pattern) {
        RSEUIPlugin.getDefault().getPluginPreferences().setValue("APPEND_MNEMONICS_PATTERN", pattern);
    }
}

