/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.serial.ISerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialConnectWorker;
import org.eclipse.tm.internal.terminal.serial.SerialMessages;
import org.eclipse.tm.internal.terminal.serial.SerialPortHandler;
import org.eclipse.tm.internal.terminal.serial.SerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialSettingsPage;

public class SerialConnector
implements ITerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private ITerminalControl fControl;
    private SerialPort fSerialPort;
    private CommPortIdentifier fSerialPortIdentifier;
    private SerialPortHandler fTerminalSerialPortHandler;
    private SerialSettings fSettings;

    public SerialConnector() {
    }

    public SerialConnector(SerialSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
        try {
            this.fSettings = new SerialSettings();
        }
        catch (NoClassDefFoundError e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.tm.terminal.serial", 0, SerialMessages.ERROR_LIBRARY_NOT_INSTALLED, (Throwable)e));
        }
    }

    public void connect(ITerminalControl control) {
        Logger.log((String)"entered.");
        this.fControl = control;
        SerialConnectWorker worker = new SerialConnectWorker(this, control);
        worker.start();
    }

    public void disconnect() {
        Logger.log((String)"entered.");
        new Thread("Terminal View Serial Port Disconnect Worker"){

            public void run() {
                if (SerialConnector.this.getSerialPortIdentifier() != null) {
                    SerialConnector.this.getSerialPortIdentifier().removePortOwnershipListener((CommPortOwnershipListener)SerialConnector.this.getSerialPortHandler());
                }
                if (SerialConnector.this.getSerialPort() != null) {
                    SerialConnector.this.getSerialPort().removeEventListener();
                    Logger.log((String)"Calling close() on serial port ...");
                    SerialConnector.this.getSerialPort().close();
                }
                if (SerialConnector.this.getInputStream() != null) {
                    try {
                        SerialConnector.this.getInputStream().close();
                    }
                    catch (Exception exception) {
                        Logger.logException((Exception)exception);
                    }
                }
                if (SerialConnector.this.getOutputStream() != null) {
                    try {
                        SerialConnector.this.getOutputStream().close();
                    }
                    catch (Exception exception) {
                        Logger.logException((Exception)exception);
                    }
                }
                SerialConnector.this.setSerialPortIdentifier(null);
                SerialConnector.this.cleanSerialPort();
                SerialConnector.this.setSerialPortHandler(null);
            }
        }.start();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public boolean isLocalEcho() {
        return false;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    protected SerialPort getSerialPort() {
        return this.fSerialPort;
    }

    void cleanSerialPort() {
        this.fSerialPort = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    protected void setSerialPort(SerialPort serialPort) throws IOException {
        this.cleanSerialPort();
        if (serialPort != null) {
            this.fSerialPort = serialPort;
            this.setOutputStream(serialPort.getOutputStream());
            this.setInputStream(serialPort.getInputStream());
        }
    }

    protected CommPortIdentifier getSerialPortIdentifier() {
        return this.fSerialPortIdentifier;
    }

    protected void setSerialPortIdentifier(CommPortIdentifier serialPortIdentifier) {
        this.fSerialPortIdentifier = serialPortIdentifier;
    }

    void setSerialPortHandler(SerialPortHandler serialPortHandler) {
        this.fTerminalSerialPortHandler = serialPortHandler;
    }

    SerialPortHandler getSerialPortHandler() {
        return this.fTerminalSerialPortHandler;
    }

    public ISerialSettings getSerialSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new SerialSettingsPage(this.fSettings);
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

