/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.control.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.control.impl.TerminalInputStream;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class TerminalText
implements ControlListener {
    protected static final int ANSISTATE_INITIAL = 0;
    protected static final int ANSISTATE_ESCAPE = 1;
    protected static final int ANSISTATE_EXPECTING_PARAMETER_OR_COMMAND = 2;
    protected static final int ANSISTATE_EXPECTING_OS_COMMAND = 3;
    protected int ansiState = 0;
    protected ITerminalControlForText terminal;
    protected StyledText text;
    protected int characterPixelWidth = 0;
    protected int widthInColumns = 0;
    protected int heightInLines = 0;
    protected int cursorColumn = 0;
    protected int caretOffset = 0;
    protected int savedCursorLine = 0;
    protected int savedCursorColumn = 0;
    protected StringBuffer[] ansiParameters = new StringBuffer[16];
    protected StringBuffer ansiOsCommand = new StringBuffer(128);
    protected int nextAnsiParameter = 0;
    protected Color currentForegroundColor;
    protected Color currentBackgroundColor;
    protected int currentFontStyle = 0;
    protected boolean reverseVideo = false;
    protected final Color BLACK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    protected final Color RED = new Color((Device)Display.getCurrent(), 255, 0, 0);
    protected final Color GREEN = new Color((Device)Display.getCurrent(), 0, 255, 0);
    protected final Color YELLOW = new Color((Device)Display.getCurrent(), 255, 255, 0);
    protected final Color BLUE = new Color((Device)Display.getCurrent(), 0, 0, 255);
    protected final Color MAGENTA = new Color((Device)Display.getCurrent(), 255, 0, 255);
    protected final Color CYAN = new Color((Device)Display.getCurrent(), 0, 255, 255);
    protected final Color WHITE = new Color((Device)Display.getCurrent(), 255, 255, 255);
    protected boolean fLimitOutput;
    protected int fBufferLineLimit;
    final TerminalInputStream fTerminalInputStream;
    final Reader fReader;
    private int fNextChar = -1;

    public TerminalText(ITerminalControlForText terminal) {
        Logger.log("entered");
        this.terminal = terminal;
        int i = 0;
        while (i < this.ansiParameters.length) {
            this.ansiParameters[i] = new StringBuffer();
            ++i;
        }
        this.fTerminalInputStream = new TerminalInputStream(1024, 100, new Runnable(){

            public void run() {
                TerminalText.this.processText();
            }
        });
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)this.fTerminalInputStream, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.fReader = reader;
    }

    public void setStyledText(StyledText ctlText) {
        if (this.text != null) {
            throw new IllegalStateException("Text can be set only once");
        }
        this.text = ctlText;
        this.text.addControlListener((ControlListener)this);
        this.resetState();
    }

    public void dispose() {
        Logger.log("entered");
        this.BLACK.dispose();
        this.RED.dispose();
        this.GREEN.dispose();
        this.YELLOW.dispose();
        this.BLUE.dispose();
        this.MAGENTA.dispose();
        this.CYAN.dispose();
        this.WHITE.dispose();
    }

    public void controlMoved(ControlEvent event) {
        Logger.log("entered");
    }

    public void controlResized(ControlEvent event) {
        Logger.log("entered");
        this.adjustTerminalDimensions();
    }

    public void clearTerminal() {
        Logger.log("entered");
        this.text.setText("");
        this.cursorColumn = 0;
    }

    public void fontChanged() {
        Logger.log("entered");
        this.characterPixelWidth = 0;
        if (this.text != null) {
            this.adjustTerminalDimensions();
        }
    }

    void processText() {
        try {
            if (this.text != null && this.text.isDisposed()) {
                return;
            }
            if (this.terminal.getState() == TerminalState.OPENED) {
                this.terminal.setState(TerminalState.CONNECTED);
            }
            this.adjustTerminalDimensions();
            this.text.setCaretOffset(this.caretOffset);
            try {
                this.processNewText();
            }
            catch (IOException e) {
                Logger.logException(e);
            }
            this.caretOffset = this.text.getCaretOffset();
        }
        catch (Exception ex) {
            Logger.logException(ex);
        }
    }

    protected void processNewText() throws IOException {
        Logger.log("entered");
        this.text.setRedraw(false);
        block21: while (this.hasNextChar()) {
            char character = this.getNextChar();
            block0 : switch (this.ansiState) {
                case 0: {
                    switch (character) {
                        case '\u0000': {
                            break block0;
                        }
                        case '\u0007': {
                            this.processBEL();
                            break block0;
                        }
                        case '\b': {
                            this.processBackspace();
                            break block0;
                        }
                        case '\t': {
                            this.processTab();
                            break block0;
                        }
                        case '\n': {
                            this.processNewline();
                            break block0;
                        }
                        case '\r': {
                            this.processCarriageReturn();
                            break block0;
                        }
                        case '\u001b': {
                            this.ansiState = 1;
                            break block0;
                        }
                    }
                    this.processNonControlCharacters(character);
                    break;
                }
                case 1: {
                    switch (character) {
                        case '[': {
                            this.ansiState = 2;
                            this.nextAnsiParameter = 0;
                            int i = 0;
                            while (i < this.ansiParameters.length) {
                                this.ansiParameters[i].delete(0, this.ansiParameters[i].length());
                                ++i;
                            }
                            continue block21;
                        }
                        case ']': {
                            this.ansiState = 3;
                            this.ansiOsCommand.delete(0, this.ansiOsCommand.length());
                            break;
                        }
                        case '7': {
                            this.ansiState = 0;
                            this.savedCursorLine = this.absoluteCursorLine();
                            this.savedCursorColumn = this.cursorColumn;
                            break;
                        }
                        case '8': {
                            this.ansiState = 0;
                            this.moveCursor(this.savedCursorLine, this.savedCursorColumn);
                            break;
                        }
                        default: {
                            Logger.log("Unsupported escape sequence: escape '" + character + "'");
                            this.ansiState = 0;
                            break;
                        }
                    }
                    continue block21;
                }
                case 2: {
                    if (character == '@' || character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z') {
                        this.ansiState = 0;
                        this.processAnsiCommandCharacter(character);
                        break;
                    }
                    this.processAnsiParameterCharacter(character);
                    break;
                }
                case 3: {
                    if (character == '\u0007') {
                        this.ansiState = 0;
                        this.processAnsiOsCommand();
                        break;
                    }
                    this.ansiOsCommand.append(character);
                    break;
                }
                default: {
                    Logger.log("INVALID ANSI FSA STATE: " + this.ansiState);
                    this.ansiState = 0;
                }
            }
        }
        this.text.setRedraw(true);
    }

    protected void processAnsiOsCommand() {
        if (this.ansiOsCommand.charAt(0) != '0' || this.ansiOsCommand.charAt(1) != ';') {
            Logger.log("Ignoring unsupported ANSI OSC sequence: '" + this.ansiOsCommand + "'");
            return;
        }
        this.terminal.setTerminalTitle(this.ansiOsCommand.substring(2));
    }

    protected void processAnsiCommandCharacter(char ansiCommandCharacter) {
        if (this.heightInLines <= 1 || this.widthInColumns <= 1) {
            return;
        }
        switch (ansiCommandCharacter) {
            case '@': {
                this.processAnsiCommand_atsign();
                break;
            }
            case 'A': {
                this.processAnsiCommand_A();
                break;
            }
            case 'B': {
                this.processAnsiCommand_B();
                break;
            }
            case 'C': {
                this.processAnsiCommand_C();
                break;
            }
            case 'D': {
                this.processAnsiCommand_D();
                break;
            }
            case 'E': {
                this.processAnsiCommand_E();
                break;
            }
            case 'F': {
                this.processAnsiCommand_F();
                break;
            }
            case 'G': {
                this.processAnsiCommand_G();
                break;
            }
            case 'H': {
                this.processAnsiCommand_H();
                break;
            }
            case 'J': {
                this.processAnsiCommand_J();
                break;
            }
            case 'K': {
                this.processAnsiCommand_K();
                break;
            }
            case 'L': {
                this.processAnsiCommand_L();
                break;
            }
            case 'M': {
                this.processAnsiCommand_M();
                break;
            }
            case 'm': {
                this.processAnsiCommand_m();
                break;
            }
            case 'n': {
                this.processAnsiCommand_n();
                break;
            }
            case 'P': {
                this.processAnsiCommand_P();
                break;
            }
            case 'S': {
                break;
            }
            case 'T': {
                break;
            }
            case 'X': {
                break;
            }
            case 'Z': {
                break;
            }
            default: {
                Logger.log("Ignoring unsupported ANSI command character: '" + ansiCommandCharacter + "'");
            }
        }
    }

    protected void processAnsiCommand_atsign() {
        int charactersToInsert = this.getAnsiParameter(0);
        int caretOffset = this.text.getCaretOffset();
        this.text.replaceTextRange(caretOffset, 0, this.generateString(' ', charactersToInsert));
        int currentLineAbsolute = this.absoluteCursorLine();
        int currentLineStartOffset = this.text.getOffsetAtLine(currentLineAbsolute);
        int currentLineEndOffset = currentLineAbsolute == this.text.getLineCount() - 1 ? this.text.getCharCount() : this.text.getOffsetAtLine(currentLineAbsolute + 1) - 1;
        if (currentLineEndOffset - currentLineStartOffset > this.widthInColumns) {
            int charactersToDelete = currentLineEndOffset - currentLineStartOffset - this.widthInColumns;
            this.text.replaceTextRange(currentLineStartOffset + this.widthInColumns, charactersToDelete, "");
        }
        this.text.setCaretOffset(caretOffset);
    }

    protected void processAnsiCommand_A() {
        this.moveCursorUp(this.getAnsiParameter(0));
    }

    protected void processAnsiCommand_B() {
        this.moveCursorDown(this.getAnsiParameter(0));
    }

    protected void processAnsiCommand_C() {
        this.moveCursorForward(this.getAnsiParameter(0));
    }

    protected void processAnsiCommand_D() {
        this.moveCursorBackward(this.getAnsiParameter(0));
    }

    protected void processAnsiCommand_E() {
        int linesToMove = this.getAnsiParameter(0);
        this.moveCursor(this.relativeCursorLine() + linesToMove, 0);
    }

    protected void processAnsiCommand_F() {
        int linesToMove = this.getAnsiParameter(0);
        this.moveCursor(this.relativeCursorLine() - linesToMove, 0);
    }

    protected void processAnsiCommand_G() {
        int targetColumn = 1;
        if (this.ansiParameters[0].length() > 0) {
            targetColumn = this.getAnsiParameter(0) - 1;
        }
        this.moveCursor(this.relativeCursorLine(), targetColumn);
    }

    protected void processAnsiCommand_H() {
        this.moveCursor(this.getAnsiParameter(0) - 1, this.getAnsiParameter(1) - 1);
    }

    protected void processAnsiCommand_J() {
        int ansiParameter = this.ansiParameters[0].length() == 0 ? 0 : this.getAnsiParameter(0);
        switch (ansiParameter) {
            case 0: {
                int caretOffset = this.text.getCaretOffset();
                this.text.replaceTextRange(caretOffset, this.text.getCharCount() - caretOffset, this.generateString('\n', this.heightInLines - this.relativeCursorLine() - 1));
                this.text.setCaretOffset(caretOffset);
                break;
            }
            case 1: {
                int currentRelativeLineNumber = this.relativeCursorLine();
                int topmostScreenLineStartOffset = this.text.getOffsetAtLine(this.absoluteLine(0));
                this.text.replaceTextRange(topmostScreenLineStartOffset, this.text.getCaretOffset() - topmostScreenLineStartOffset, String.valueOf(this.generateString('\n', currentRelativeLineNumber)) + this.generateString(' ', this.cursorColumn));
                this.text.setCaretOffset(topmostScreenLineStartOffset + currentRelativeLineNumber + this.cursorColumn);
                break;
            }
            case 2: {
                int currentLineNumber = this.relativeCursorLine();
                int topmostScreenLineStartOffset = this.text.getOffsetAtLine(this.absoluteLine(0));
                this.text.replaceTextRange(topmostScreenLineStartOffset, this.text.getCharCount() - topmostScreenLineStartOffset, this.generateString('\n', this.heightInLines - 1));
                this.moveCursor(currentLineNumber, this.cursorColumn);
                break;
            }
            default: {
                Logger.log("Unexpected J-command parameter: " + ansiParameter);
            }
        }
    }

    protected void processAnsiCommand_K() {
        int ansiParameter = this.getAnsiParameter(0);
        int originalCaretOffset = this.text.getCaretOffset();
        switch (ansiParameter) {
            case 0: {
                int currentLineStartOffset = this.text.getOffsetAtLine(this.absoluteCursorLine());
                this.text.replaceTextRange(currentLineStartOffset, this.cursorColumn, this.generateString(' ', this.cursorColumn));
                break;
            }
            case 1: {
                int caretOffset = this.text.getCaretOffset();
                if (this.absoluteCursorLine() == this.text.getLineCount() - 1) {
                    this.text.replaceTextRange(caretOffset, this.text.getCharCount() - caretOffset, "");
                    break;
                }
                int nextLineStartOffset = this.text.getOffsetAtLine(this.absoluteCursorLine() + 1);
                this.text.replaceTextRange(caretOffset, nextLineStartOffset - caretOffset - 1, "");
                break;
            }
            case 2: {
                int currentLineStartOffset = this.text.getOffsetAtLine(this.absoluteCursorLine());
                if (this.absoluteCursorLine() == this.text.getLineCount() - 1) {
                    this.text.replaceTextRange(currentLineStartOffset, this.text.getCharCount() - currentLineStartOffset, this.generateString(' ', this.cursorColumn));
                    break;
                }
                int nextLineStartOffset = this.text.getOffsetAtLine(this.absoluteCursorLine() + 1);
                this.text.replaceTextRange(currentLineStartOffset, nextLineStartOffset - currentLineStartOffset - 1, this.generateString(' ', this.cursorColumn));
                break;
            }
            default: {
                Logger.log("Unexpected K-command parameter: " + ansiParameter);
            }
        }
        this.text.setCaretOffset(originalCaretOffset);
    }

    protected void processAnsiCommand_L() {
        int totalCharacters;
        int linesToInsert = this.getAnsiParameter(0);
        int currentLineStartOffset = this.text.getOffsetAtLine(this.absoluteCursorLine());
        int totalLines = this.text.getLineCount();
        int linesToDelete = -1;
        if (this.heightInLines <= totalLines) {
            linesToDelete = linesToInsert;
        } else if (totalLines + linesToInsert > this.heightInLines) {
            linesToDelete = totalLines + linesToInsert - this.heightInLines;
        }
        if (linesToDelete != -1) {
            int firstLineToDeleteStartOffset = this.text.getOffsetAtLine(totalLines - linesToDelete);
            this.text.replaceTextRange(firstLineToDeleteStartOffset - 1, this.text.getCharCount() - firstLineToDeleteStartOffset + 1, "");
        }
        if (currentLineStartOffset > (totalCharacters = this.text.getCharCount())) {
            this.text.replaceTextRange(totalCharacters, 0, this.generateString('\n', linesToInsert));
        } else {
            this.text.replaceTextRange(currentLineStartOffset, 0, this.generateString('\n', linesToInsert));
        }
        this.text.setCaretOffset(currentLineStartOffset);
    }

    protected void processAnsiCommand_M() {
        int totalLines = this.text.getLineCount();
        int linesToDelete = this.getAnsiParameter(0);
        int currentLineAbsolute = this.absoluteCursorLine();
        int currentLineStartOffset = this.text.getOffsetAtLine(currentLineAbsolute);
        if (linesToDelete >= totalLines - currentLineAbsolute) {
            this.text.replaceTextRange(currentLineStartOffset, this.text.getCharCount() - currentLineStartOffset, this.generateString('\n', totalLines - currentLineAbsolute - 1));
        } else {
            int firstUndeletedLineStartOffset = this.text.getOffsetAtLine(currentLineAbsolute + linesToDelete);
            this.text.replaceTextRange(currentLineStartOffset, firstUndeletedLineStartOffset - currentLineStartOffset, "");
            this.text.replaceTextRange(this.text.getCharCount(), 0, this.generateString('\n', linesToDelete));
        }
        this.text.setCaretOffset(currentLineStartOffset);
    }

    protected void processAnsiCommand_m() {
        if (this.ansiParameters[0].length() == 0) {
            this.ansiParameters[0].append('0');
        }
        int totalParameters = this.ansiParameters.length;
        int parameterIndex = 0;
        while (parameterIndex < totalParameters && this.ansiParameters[parameterIndex].length() > 0) {
            int ansiParameter = this.getAnsiParameter(parameterIndex);
            switch (ansiParameter) {
                case 0: {
                    this.currentForegroundColor = this.text.getForeground();
                    this.currentBackgroundColor = this.text.getBackground();
                    this.currentFontStyle = 0;
                    this.reverseVideo = false;
                    break;
                }
                case 1: {
                    this.currentFontStyle = 1;
                    break;
                }
                case 7: {
                    this.reverseVideo = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 22: {
                    this.currentFontStyle = 0;
                    break;
                }
                case 27: {
                    this.reverseVideo = false;
                    break;
                }
                case 30: {
                    this.currentForegroundColor = this.BLACK;
                    break;
                }
                case 31: {
                    this.currentForegroundColor = this.RED;
                    break;
                }
                case 32: {
                    this.currentForegroundColor = this.GREEN;
                    break;
                }
                case 33: {
                    this.currentForegroundColor = this.YELLOW;
                    break;
                }
                case 34: {
                    this.currentForegroundColor = this.BLUE;
                    break;
                }
                case 35: {
                    this.currentForegroundColor = this.MAGENTA;
                    break;
                }
                case 36: {
                    this.currentForegroundColor = this.CYAN;
                    break;
                }
                case 37: {
                    this.currentForegroundColor = this.text.getForeground();
                    break;
                }
                case 40: {
                    this.currentBackgroundColor = this.text.getBackground();
                    break;
                }
                case 41: {
                    this.currentBackgroundColor = this.RED;
                    break;
                }
                case 42: {
                    this.currentBackgroundColor = this.GREEN;
                    break;
                }
                case 43: {
                    this.currentBackgroundColor = this.YELLOW;
                    break;
                }
                case 44: {
                    this.currentBackgroundColor = this.BLUE;
                    break;
                }
                case 45: {
                    this.currentBackgroundColor = this.MAGENTA;
                    break;
                }
                case 46: {
                    this.currentBackgroundColor = this.CYAN;
                    break;
                }
                case 47: {
                    this.currentBackgroundColor = this.WHITE;
                    break;
                }
                default: {
                    Logger.log("Unsupported graphics rendition parameter: " + ansiParameter);
                }
            }
            ++parameterIndex;
        }
    }

    protected void processAnsiCommand_n() {
        if (this.getAnsiParameter(0) != 6) {
            return;
        }
        String positionReport = "\u001b[" + (this.relativeCursorLine() + 1) + ";" + (this.cursorColumn + 1) + "R";
        OutputStreamWriter streamWriter = new OutputStreamWriter(this.terminal.getOutputStream(), Charset.forName("ISO-8859-1"));
        try {
            streamWriter.write(positionReport, 0, positionReport.length());
            streamWriter.flush();
        }
        catch (IOException iOException) {
            Logger.log("Caught IOException!");
        }
    }

    protected void processAnsiCommand_P() {
        int caretOffset;
        int currentLineAbsolute = this.absoluteCursorLine();
        int currentLineEndOffset = currentLineAbsolute == this.text.getLineCount() - 1 ? this.text.getCharCount() : this.text.getOffsetAtLine(currentLineAbsolute + 1) - 1;
        int remainingCharactersOnLine = currentLineEndOffset - (caretOffset = this.text.getCaretOffset());
        if (remainingCharactersOnLine > 0) {
            int charactersToDelete = this.getAnsiParameter(0);
            if (charactersToDelete > remainingCharactersOnLine) {
                charactersToDelete = remainingCharactersOnLine;
            }
            this.text.replaceTextRange(caretOffset, charactersToDelete, "");
            this.text.setCaretOffset(caretOffset);
        }
    }

    protected int getAnsiParameter(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex >= this.ansiParameters.length) {
            return -1;
        }
        String parameter = this.ansiParameters[parameterIndex].toString();
        if (parameter.length() == 0) {
            return 1;
        }
        int parameterValue = 1;
        try {
            parameterValue = Integer.parseInt(parameter);
        }
        catch (NumberFormatException numberFormatException) {
            parameterValue = 1;
        }
        return parameterValue;
    }

    protected void processAnsiParameterCharacter(char ch) {
        if (ch == ';') {
            ++this.nextAnsiParameter;
        } else if (this.nextAnsiParameter < this.ansiParameters.length) {
            this.ansiParameters[this.nextAnsiParameter].append(ch);
        }
    }

    protected void processNonControlCharacters(char character) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(character);
        while (this.hasNextChar()) {
            character = this.getNextChar();
            if (character == '\u0000' || character == '\b' || character == '\t' || character == '\u0007' || character == '\n' || character == '\r' || character == '\u001b') {
                this.pushBackChar(character);
                break;
            }
            buffer.append(character);
        }
        int preDisplayCaretOffset = this.text.getCaretOffset();
        this.displayNewText(buffer.toString());
        if (!this.currentForegroundColor.equals((Object)this.text.getForeground()) || !this.currentBackgroundColor.equals((Object)this.text.getBackground()) || this.currentFontStyle != 0 || this.reverseVideo) {
            StyleRange style = new StyleRange(preDisplayCaretOffset, this.text.getCaretOffset() - preDisplayCaretOffset, this.reverseVideo ? this.currentBackgroundColor : this.currentForegroundColor, this.reverseVideo ? this.currentForegroundColor : this.currentBackgroundColor, this.currentFontStyle);
            this.text.setStyleRange(style);
        }
    }

    protected void displayNewText(String buffer) {
        if (this.text.getCaretOffset() == this.text.getCharCount()) {
            this.displayNewTextByAppending(buffer);
        } else {
            this.displayNewTextByOverwriting(buffer);
        }
    }

    protected void displayNewTextByAppending(String newText) {
        int availableSpaceOnLine;
        int first = 0;
        int last = newText.length() - 1;
        int numCharsToOutput = newText.length();
        if (numCharsToOutput >= (availableSpaceOnLine = this.widthInColumns - this.cursorColumn)) {
            this.text.append(newText.substring(first, first + availableSpaceOnLine));
            first += availableSpaceOnLine;
            this.processCarriageReturn();
            this.processNewline();
            while (first <= last) {
                availableSpaceOnLine = this.widthInColumns;
                if (availableSpaceOnLine > last - first + 1) {
                    this.text.append(newText.substring(first, last + 1));
                    this.cursorColumn = last - first + 1;
                    break;
                }
                this.text.append(newText.substring(first, first + availableSpaceOnLine));
                first += availableSpaceOnLine;
                this.processCarriageReturn();
                this.processNewline();
            }
        } else {
            this.text.append(newText.substring(first, last + 1));
            this.cursorColumn += last - first + 1;
        }
    }

    protected void displayNewTextByOverwriting(String newText) {
        int first = 0;
        int last = newText.length() - 1;
        ArrayList<String> textSegments = new ArrayList<String>(100);
        int availableSpaceOnLine = this.widthInColumns - this.cursorColumn;
        while (first <= last) {
            String segment = last - first + 1 > availableSpaceOnLine ? newText.substring(first, first + availableSpaceOnLine) : newText.substring(first, last + 1);
            textSegments.add(segment);
            first += availableSpaceOnLine;
            availableSpaceOnLine = this.widthInColumns;
        }
        Iterator iter = textSegments.iterator();
        while (iter.hasNext()) {
            String segment = (String)iter.next();
            int caretOffset = this.text.getCaretOffset();
            if (caretOffset == this.text.getCharCount()) {
                this.text.append(segment);
                if (!iter.hasNext()) continue;
                this.processCarriageReturn();
                this.processNewline();
                continue;
            }
            int numCharactersAfterCursorOnLine = this.absoluteCursorLine() == this.text.getLineCount() - 1 ? this.text.getCharCount() - caretOffset : this.text.getOffsetAtLine(this.absoluteCursorLine() + 1) - caretOffset - 1;
            int segmentLength = segment.length();
            int numCharactersToReplace = segmentLength < numCharactersAfterCursorOnLine ? segmentLength : numCharactersAfterCursorOnLine;
            this.text.replaceTextRange(caretOffset, numCharactersToReplace, segment);
            this.text.setCaretOffset(caretOffset + segmentLength);
            this.cursorColumn += segmentLength;
            if (iter.hasNext()) {
                this.cursorColumn = 0;
                this.text.setCaretOffset(caretOffset + segmentLength + 1);
                continue;
            }
            if (this.cursorColumn != this.widthInColumns) continue;
            this.processCarriageReturn();
            this.processNewline();
        }
    }

    protected void processBEL() {
        Display.getCurrent().beep();
    }

    protected void processBackspace() {
        this.moveCursorBackward(1);
    }

    protected void processTab() {
        this.moveCursorForward(8 - this.cursorColumn % 8);
    }

    protected void processNewline() {
        int totalLines = this.text.getLineCount();
        int currentLineAbsolute = this.absoluteCursorLine();
        if (currentLineAbsolute < totalLines - 1) {
            this.moveCursorDown(1);
        } else if (currentLineAbsolute == totalLines - 1) {
            this.text.append("\n");
            this.text.append(this.generateString(' ', this.cursorColumn));
            this.text.setCaretOffset(this.text.getCharCount());
            this.deleteTopmostLines();
        } else {
            Logger.log("SHOULD NOT BE REACHED!");
        }
    }

    protected void processCarriageReturn() {
        this.text.setCaretOffset(this.text.getOffsetAtLine(this.text.getLineAtOffset(this.text.getCaretOffset())));
        this.cursorColumn = 0;
    }

    protected void adjustTerminalDimensions() {
        ITerminalConnector telnetConnection;
        int linePixelHeight = this.text.getLineHeight();
        Point textWindowDimensions = this.text.getSize();
        int verticalPixelsToShrink = textWindowDimensions.y % linePixelHeight;
        this.heightInLines = textWindowDimensions.y / linePixelHeight;
        int horizontalPixelsToShrink = 0;
        if (this.characterPixelWidth == 0) {
            this.computeCharacterPixelWidth();
        }
        if (this.characterPixelWidth != 0) {
            horizontalPixelsToShrink = textWindowDimensions.x % this.characterPixelWidth;
            this.widthInColumns = textWindowDimensions.x / this.characterPixelWidth - 3;
        }
        if (verticalPixelsToShrink > 0 || horizontalPixelsToShrink > 0) {
            this.text.removeControlListener((ControlListener)this);
            textWindowDimensions.y -= verticalPixelsToShrink;
            textWindowDimensions.x -= horizontalPixelsToShrink;
            this.text.setSize(textWindowDimensions);
            Point textLocation = this.text.getLocation();
            textLocation.y += verticalPixelsToShrink;
            this.text.setLocation(textLocation);
            this.text.addControlListener((ControlListener)this);
            this.text.setSelectionRange(this.text.getCharCount(), 0);
            this.text.showSelection();
            this.text.getParent().redraw();
        }
        if ((telnetConnection = this.getConnector()) != null && this.widthInColumns != 0 && this.heightInLines != 0) {
            telnetConnection.setTerminalSize(this.widthInColumns, this.heightInLines);
        }
    }

    private ITerminalConnector getConnector() {
        if (this.terminal.getTerminalConnectorInfo() != null) {
            return this.terminal.getTerminalConnectorInfo().getConnector();
        }
        return null;
    }

    protected void computeCharacterPixelWidth() {
        this.text.replaceTextRange(0, 0, "   ");
        Point firstCharLocation = this.text.getLocationAtOffset(0);
        Point secondCharLocation = this.text.getLocationAtOffset(1);
        this.characterPixelWidth = secondCharLocation.x - firstCharLocation.x;
        this.text.replaceTextRange(0, 3, "");
    }

    protected void deleteTopmostLines() {
        int linesToDelete;
        if (!this.fLimitOutput) {
            return;
        }
        int totalLineCount = this.text.getLineCount();
        if (totalLineCount <= this.heightInLines) {
            return;
        }
        int bufferLineLimit = this.fBufferLineLimit;
        if (bufferLineLimit <= this.heightInLines) {
            bufferLineLimit = this.heightInLines + 1;
        }
        if ((linesToDelete = totalLineCount - bufferLineLimit) >= 5) {
            this.text.replaceTextRange(0, this.text.getOffsetAtLine(linesToDelete), "");
        }
    }

    protected int absoluteCursorLine() {
        return this.text.getLineAtOffset(this.text.getCaretOffset());
    }

    protected int relativeCursorLine() {
        int totalLines = this.text.getLineCount();
        if (totalLines <= this.heightInLines) {
            return this.text.getLineAtOffset(this.text.getCaretOffset());
        }
        return this.absoluteCursorLine() - totalLines + this.heightInLines;
    }

    protected int absoluteLine(int visibleLineNumber) {
        int totalLines = this.text.getLineCount();
        if (totalLines <= this.heightInLines) {
            return visibleLineNumber;
        }
        return totalLines - this.heightInLines + visibleLineNumber;
    }

    protected String generateString(char ch, int count) {
        char[] chars = new char[count];
        int i = 0;
        while (i < chars.length) {
            chars[i] = ch;
            ++i;
        }
        return new String(chars);
    }

    protected void moveCursor(int targetLine, int targetColumn) {
        int totalLines;
        if (targetLine < 0) {
            targetLine = 0;
        }
        if (targetLine >= this.heightInLines) {
            targetLine = this.heightInLines - 1;
        }
        if (targetColumn < 0) {
            targetColumn = 0;
        }
        if (targetColumn >= this.widthInColumns) {
            targetColumn = this.widthInColumns - 1;
        }
        if ((totalLines = this.text.getLineCount()) < this.heightInLines && targetLine >= totalLines) {
            this.text.append(this.generateString('\n', this.heightInLines - totalLines));
        }
        int targetLineStartOffset = this.text.getOffsetAtLine(this.absoluteLine(targetLine));
        int nextLineNumber = this.absoluteLine(targetLine + 1);
        int targetLineLength = nextLineNumber >= totalLines ? this.text.getCharCount() - targetLineStartOffset : this.text.getOffsetAtLine(nextLineNumber) - targetLineStartOffset - 1;
        if (targetColumn >= targetLineLength) {
            int spacesToAppend = targetColumn - targetLineLength;
            this.text.replaceTextRange(targetLineStartOffset + targetLineLength, 0, this.generateString(' ', spacesToAppend));
        }
        this.text.setCaretOffset(targetLineStartOffset + targetColumn);
        this.cursorColumn = targetColumn;
    }

    protected void moveCursorDown(int lines) {
        this.moveCursor(this.relativeCursorLine() + lines, this.cursorColumn);
    }

    protected void moveCursorUp(int lines) {
        this.moveCursor(this.relativeCursorLine() - lines, this.cursorColumn);
    }

    protected void moveCursorForward(int columnsToMove) {
        this.moveCursor(this.relativeCursorLine(), this.cursorColumn + columnsToMove);
    }

    protected void moveCursorBackward(int columnsToMove) {
        if (columnsToMove > this.cursorColumn) {
            columnsToMove = this.cursorColumn;
        }
        this.text.setCaretOffset(this.text.getCaretOffset() - columnsToMove);
        this.cursorColumn -= columnsToMove;
    }

    public void resetState() {
        this.ansiState = 0;
        this.currentForegroundColor = this.text.getForeground();
        this.currentBackgroundColor = this.text.getBackground();
        this.currentFontStyle = 0;
        this.reverseVideo = false;
    }

    protected int getBufferLineLimit() {
        return this.fBufferLineLimit;
    }

    protected void setBufferLineLimit(int bufferLineLimit) {
        this.fBufferLineLimit = bufferLineLimit;
    }

    protected boolean isLimitOutput() {
        return this.fLimitOutput;
    }

    protected void setLimitOutput(boolean limitOutput) {
        this.fLimitOutput = limitOutput;
    }

    public OutputStream getOutputStream() {
        return this.fTerminalInputStream.getOutputStream();
    }

    private char getNextChar() throws IOException {
        int c = -1;
        if (this.fNextChar != -1) {
            c = this.fNextChar;
            this.fNextChar = -1;
        } else {
            c = this.fReader.read();
        }
        if (c == -1) {
            c = 0;
        }
        return (char)c;
    }

    private boolean hasNextChar() throws IOException {
        if (this.fNextChar >= 0) {
            return true;
        }
        return this.fReader.ready();
    }

    void pushBackChar(char c) {
        this.fNextChar = c;
    }
}

