/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.dstore.extra.IDataElement;
import org.eclipse.dstore.internal.core.util.DataElementRemover;
import org.eclipse.dstore.internal.extra.DataElementActionFilter;
import org.eclipse.dstore.internal.extra.DesktopElement;
import org.eclipse.dstore.internal.extra.PropertySource;

public final class DataElement
implements IDataElement {
    private String[] _attributes;
    private StringBuffer _buffer;
    private boolean _isReference = false;
    private boolean _isDescriptor = false;
    private boolean _isExpanded = false;
    private boolean _isUpdated = false;
    private boolean _isPendingTransfer = false;
    private boolean _isSpirit = false;
    private int _depth = 1;
    private DataStore _dataStore = null;
    private DataElement _parent = null;
    private DataElement _descriptor = null;
    private ArrayList _nestedData = null;
    private DataElement _referencedObject = null;
    private PropertySource _propertySource = null;

    public DataElement() {
        this._dataStore = null;
        this._parent = null;
        DataElementRemover.addToCreatedCount();
    }

    protected DataElement(DataStore dataStore) {
        this._dataStore = dataStore;
        this._parent = null;
        DataElementRemover.addToCreatedCount();
    }

    protected void finalize() {
        DataElementRemover.addToGCedCount();
    }

    public void reInit(DataElement parent, DataElement originalObject, DataElement refType) {
        if (parent != null && originalObject != null) {
            String type;
            this._parent = parent;
            this._attributes = this.getAttributes();
            this._attributes[0] = type = refType.getName();
            String originalId = originalObject.getId();
            StringBuffer idBuf = new StringBuffer(parent.getId());
            idBuf.append(type);
            idBuf.append(originalId);
            this._attributes[1] = idBuf.toString();
            this._attributes[2] = originalId;
            this._attributes[3] = originalId;
            this.initialize(refType);
            this._referencedObject = originalObject;
            this._isReference = true;
        }
    }

    public void reInit(DataElement parent, DataElement originalObject, String refType) {
        if (parent != null && originalObject != null) {
            this._parent = parent;
            this._attributes = this.getAttributes();
            this._attributes[0] = refType;
            String originalId = originalObject.getId();
            StringBuffer idBuf = new StringBuffer(parent.getId());
            idBuf.append(refType);
            idBuf.append(originalId);
            this._attributes[1] = idBuf.toString();
            this._attributes[2] = originalId;
            this._attributes[3] = originalId;
            this.initialize();
            this._referencedObject = originalObject;
            this._isReference = true;
        }
    }

    public void reInit(DataElement parent, DataElement type, String id, String name, String source) {
        this._parent = parent;
        this._attributes = this.getAttributes();
        this._attributes[0] = type.getAttribute(2);
        this._attributes[1] = id;
        this._attributes[2] = name;
        this._attributes[3] = name;
        this._attributes[4] = source;
        this.initialize(type);
    }

    public void reInit(DataElement parent, String type, String id, String name, String source) {
        this._parent = parent;
        this._attributes = this.getAttributes();
        this._attributes[0] = type;
        this._attributes[1] = id;
        this._attributes[2] = name;
        this._attributes[3] = name;
        this._attributes[4] = source;
        this.initialize();
    }

    public void reInit(DataElement parent, DataElement type, String id, String name, String source, boolean isRef) {
        this._parent = parent;
        this._attributes = this.getAttributes();
        this._attributes[0] = type.getAttribute(2);
        this._attributes[1] = id;
        this._attributes[2] = name;
        this._attributes[3] = name;
        this._attributes[4] = source;
        this.initialize(type);
        this._isReference = isRef;
    }

    public void reInit(DataElement parent, String type, String id, String name, String source, boolean isRef) {
        this._parent = parent;
        this._attributes = this.getAttributes();
        this._attributes[0] = type;
        this._attributes[1] = id;
        this._attributes[2] = name;
        this._attributes[3] = name;
        this._attributes[4] = source;
        this.initialize();
        this._isReference = isRef;
    }

    public void reInit(DataElement parent, DataElement type, String[] attributes) {
        this._parent = parent;
        this._attributes = attributes;
        this._attributes[0] = type.getName();
        this.initialize(type);
    }

    public void reInit(DataElement parent, String[] attributes) {
        this._parent = parent;
        this._attributes = attributes;
        this.initialize();
    }

    public void reInitAsTransient(String[] attributes) {
        this._attributes = attributes;
        this._isReference = false;
        this._isDescriptor = false;
        this._depth = 1;
        this._referencedObject = null;
        this._isExpanded = false;
        this._isUpdated = false;
        String depthStr = this.getAttribute(7);
        if (depthStr != null && depthStr.length() > 0 && !depthStr.equals("1")) {
            try {
                this._depth = Integer.parseInt(depthStr);
            }
            catch (Exception exception) {}
        }
        if (this._nestedData != null) {
            this._nestedData.clear();
        }
    }

    public boolean isDeleted() {
        if (this._attributes == null) {
            return true;
        }
        String valueAttribute = this.getAttribute(3);
        if (valueAttribute != null && valueAttribute.equals(DataStoreResources.DELETED)) {
            return true;
        }
        return this._isSpirit && !this._dataStore.isVirtual();
    }

    public synchronized void addNestedData(List nestedData, boolean checkUnique) {
        if (nestedData != null) {
            if (this._nestedData == null) {
                this._nestedData = new ArrayList(nestedData.size());
            }
            int i = 0;
            while (i < nestedData.size()) {
                DataElement child = (DataElement)nestedData.get(i);
                if (child != null && child != this) {
                    this.addNestedData(child, checkUnique);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addNestedData(DataElement obj, boolean checkUnique) {
        if (this._nestedData == null) {
            this._nestedData = new ArrayList(4);
        }
        ArrayList arrayList = this._nestedData;
        synchronized (arrayList) {
            boolean alreadyThere = false;
            if (checkUnique) {
                alreadyThere = this._nestedData.contains(obj);
            }
            if (!checkUnique || !alreadyThere) {
                if (alreadyThere) {
                    return;
                }
                this._nestedData.add(obj);
                if (obj.getParent() == null) {
                    obj.setParent(this);
                }
            }
            this._isUpdated = false;
            obj.setUpdated(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNestedData(DataElement object) {
        if (this._nestedData != null) {
            ArrayList arrayList = this._nestedData;
            synchronized (arrayList) {
                this._nestedData.remove(object);
            }
        }
        this._isExpanded = false;
        this._isUpdated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNestedData() {
        if (this._nestedData != null) {
            ArrayList arrayList = this._nestedData;
            synchronized (arrayList) {
                while (this._nestedData.size() > 0) {
                    DataElement nestedObject = (DataElement)this._nestedData.get(0);
                    this._nestedData.remove(nestedObject);
                }
            }
        }
        this._isExpanded = false;
        this._isUpdated = false;
    }

    public String getAttribute(int attributeIndex) {
        return this._attributes[attributeIndex];
    }

    public String[] getAttributes() {
        if (this._attributes == null) {
            return new String[8];
        }
        return this._attributes;
    }

    public String getType() {
        return this.getAttribute(0);
    }

    public String getId() {
        return this.getAttribute(1);
    }

    public String getName() {
        return this.getAttribute(2);
    }

    public String getValue() {
        return this.getAttribute(3);
    }

    public String getSource() {
        return this.getAttribute(4);
    }

    public StringBuffer getBuffer() {
        return this._buffer;
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void initializeNestedData(int size) {
        if (this._nestedData == null) {
            this._nestedData = new ArrayList(size);
        }
    }

    public List getNestedData() {
        return this._nestedData;
    }

    public DataElement get(int index) {
        if (this._nestedData == null) {
            return null;
        }
        if (this.getNestedSize() > index) {
            Object obj = this._nestedData.get(index);
            return (DataElement)obj;
        }
        return null;
    }

    public int getNestedSize() {
        if (this._nestedData == null) {
            return 0;
        }
        return this._nestedData.size();
    }

    public DataElement getParent() {
        return this._parent;
    }

    public boolean isDescriptor() {
        return this._isDescriptor;
    }

    public void setDescriptor(DataElement theDescriptor) {
        this._descriptor = theDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataElement getDescriptor() {
        if (this.isDeleted()) {
            return null;
        }
        if (this._isReference) {
            if (this._referencedObject == null) {
                this._referencedObject = this.dereference();
            }
            if (this != this._referencedObject && !this._referencedObject.isDeleted()) return this._referencedObject.getDescriptor();
            this._referencedObject = null;
            return this._descriptor;
        } else {
            if (this._descriptor != null || this._dataStore == null) return this._descriptor;
            if (this._isDescriptor) {
                this._descriptor = this._dataStore.findDescriptor(this.getAttribute(0), this.getName());
                return this._descriptor;
            } else {
                this._descriptor = this._dataStore.findObjectDescriptor(this.getAttribute(0));
                if (this._descriptor != null) return this._descriptor;
                this._descriptor = this._dataStore.find(this._dataStore.getDescriptorRoot(), 2, this.getAttribute(0), 3);
            }
        }
        return this._descriptor;
    }

    public int depth() {
        return this._depth;
    }

    public boolean isReference() {
        return this._isReference;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public boolean isUpdated() {
        return this._isUpdated;
    }

    public boolean isPendingTransfer() {
        return this._isPendingTransfer;
    }

    public boolean isSpirit() {
        return this._isSpirit;
    }

    public void setAttribute(int attributeIndex, String attribute) {
        String nameAttribute = this.getAttribute(2);
        if (attributeIndex == 2 && nameAttribute != null && nameAttribute.equals(this.getAttribute(3))) {
            this._attributes[3] = attribute;
        } else if (attributeIndex == 7) {
            this._depth = attribute != null ? Integer.parseInt(attribute) : 0;
        } else if (attributeIndex == 0) {
            this._descriptor = null;
        }
        this._attributes[attributeIndex] = attribute;
        this._isUpdated = false;
    }

    public void setAttributes(String[] attributes) {
        int i = 0;
        while (i < 8) {
            if (attributes[i] != null) {
                this.setAttribute(i, attributes[i]);
            }
            ++i;
        }
        this._isUpdated = false;
    }

    public void setBuffer(StringBuffer buffer) {
        this._buffer = buffer;
        if (this._depth < 1 && buffer.length() > 0) {
            this.setDepth(1);
        }
        this._isUpdated = false;
    }

    public void appendToBuffer(String text) {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        this._buffer.append(text);
        this._isUpdated = false;
    }

    public void setExpanded(boolean flag) {
        this._isExpanded = flag;
    }

    public void setUpdated(boolean flag) {
        this._isUpdated = flag;
    }

    public void setPendingTransfer(boolean flag) {
        this._isPendingTransfer = flag;
    }

    public void setSpirit(boolean flag) {
        this._isSpirit = flag;
    }

    public void setParent(DataElement parent) {
        this._parent = parent;
    }

    public void setDataStore(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public void setDepth(int depth) {
        this._depth = depth;
        this.setAttribute(7, "" + this._depth);
        this._isUpdated = false;
    }

    public boolean isOfType(String typeStr) {
        DataElement typeDescriptor = this._dataStore.find(this._dataStore.getDescriptorRoot(), 2, typeStr, 1);
        return this.isOfType(typeDescriptor);
    }

    public boolean isOfType(String typeStr, boolean isDescriptor) {
        DataElement typeDescriptor = this._dataStore.find(this._dataStore.getDescriptorRoot(), 2, typeStr, 1);
        return this.isOfType(typeDescriptor, isDescriptor);
    }

    public boolean isOfType(DataElement type) {
        return this.isOfType(type, false);
    }

    public boolean isOfType(DataElement type, boolean isDescriptor) {
        boolean result = false;
        if (type == null) {
            return result;
        }
        DataElement descriptor = this;
        if (!isDescriptor) {
            descriptor = this.getDescriptor();
        }
        if (descriptor == type) {
            return true;
        }
        if (descriptor != null && !descriptor.isDeleted()) {
            String typeType = type.getType();
            String typeName = type.getName();
            if ((typeType.equals("objectdescriptor") || typeType.equals("abstractobjectdescriptor")) && (descriptor.getName().equals(typeName) || typeName.equals("all"))) {
                result = true;
                return result;
            }
            DataElement relationship = this._dataStore.getAbstractedByRelation();
            List abstracted = null;
            if (relationship != null) {
                abstracted = descriptor.getAssociated(relationship);
            }
            if (abstracted != null) {
                int i = 0;
                while (i < abstracted.size() && !result) {
                    DataElement superDescriptor = (DataElement)abstracted.get(i);
                    result = superDescriptor.isOfType(type, true);
                    ++i;
                }
            }
        }
        return result;
    }

    public boolean patternMatch(int[] attributes, String[] patterns, int numAttributes, boolean ignoreCase) {
        int index = 0;
        while (index < numAttributes) {
            String pattern = patterns[index];
            String attribute = this.getAttribute(attributes[index]);
            if (!StringCompare.compare(pattern, attribute, ignoreCase)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean contains(DataElement object, DataElement property) {
        return this.contains(object, property, 1);
    }

    public synchronized boolean contains(DataElement object, DataElement property, int depth) {
        block20: {
            if (depth <= 0) break block20;
            --depth;
            if (object == null) {
                return false;
            }
            if (property == null) {
                property = this._dataStore.getContentsRelation();
            }
            if (this.getNestedSize() == 0) {
                return false;
            }
            if (property != null) {
                if (property.getType().equals("abstractrelationdescriptor")) {
                    int i = 0;
                    while (i < property.getNestedSize()) {
                        DataElement subProperty = property.get(i).dereference();
                        if (this.contains(object, subProperty)) {
                            return true;
                        }
                        ++i;
                    }
                } else {
                    String type = property.getName();
                    if (type.equals(DataStoreResources.model_parent) && this._parent != null) {
                        if (object == this._parent) {
                            return true;
                        }
                        return this._parent.contains(object, property, depth);
                    }
                    if (this._nestedData != null) {
                        int i = 0;
                        while (i < this._nestedData.size()) {
                            DataElement nestedObject = (DataElement)this._nestedData.get(i);
                            if (nestedObject != null) {
                                if (nestedObject.isReference()) {
                                    String relType = nestedObject.getAttribute(0);
                                    if (relType.equals(type)) {
                                        DataElement referenced = nestedObject.dereference();
                                        if (referenced == object) {
                                            return true;
                                        }
                                        return referenced.contains(object, property, depth);
                                    }
                                } else if (type.equals("contents")) {
                                    if (nestedObject == object) {
                                        return true;
                                    }
                                    if (nestedObject.contains(object, property, depth)) {
                                        return true;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean contains(DataElement object) {
        return this.contains(object, 1);
    }

    public boolean contains(DataElement object, int depth) {
        boolean result = false;
        if (this._nestedData != null) {
            --depth;
            int i = 0;
            while (i < this.getNestedSize()) {
                DataElement child = this.get(i);
                if (child == object) {
                    return true;
                }
                if (child.dereference() == object) {
                    return true;
                }
                if (depth > 0 && (result = child.contains(object, depth))) {
                    return true;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean equals(Object arg) {
        if (arg instanceof DataElement) {
            return arg == this;
        }
        return false;
    }

    public List getAssociated(String propertyStr) {
        DataElement property = this._dataStore.findObjectDescriptor(propertyStr);
        if (property == null) {
            property = this._dataStore.findRelationDescriptor(propertyStr);
        }
        if (property != null) {
            return this.getAssociated(property);
        }
        return new ArrayList(1);
    }

    public List getAssociated(DataElement property) {
        ArrayList<DataElement> set;
        block11: {
            String type;
            block12: {
                block10: {
                    set = new ArrayList<DataElement>();
                    if (property == null || this.getNestedSize() == 0) {
                        return set;
                    }
                    if (!property.getType().equals("abstractrelationdescriptor")) break block10;
                    int i = 0;
                    while (i < property.getNestedSize()) {
                        DataElement subProperty = property.get(i).dereference();
                        List subSet = this.getAssociated(subProperty);
                        set.addAll(subSet);
                        ++i;
                    }
                    break block11;
                }
                type = property.getName();
                if (type.equals(DataStoreResources.model_parent) && this._parent != null) {
                    set.add(this._parent);
                    return set;
                }
                if (!type.equals(DataStoreResources.model_descriptor_for)) break block12;
                this.getDescriptor();
                if (this._descriptor == null) break block11;
                set.add(this._descriptor);
                break block11;
            }
            if (this._nestedData != null) {
                int i = 0;
                while (i < this._nestedData.size()) {
                    DataElement nestedObject = (DataElement)this._nestedData.get(i);
                    if (nestedObject != null) {
                        if (nestedObject.isReference()) {
                            DataElement referenced;
                            String relType = nestedObject.getType();
                            if (relType.equals(type) && (referenced = nestedObject.dereference()) != null && !referenced.isDeleted()) {
                                set.add(referenced);
                            }
                        } else if (type.equals(DataStoreResources.model_contents) && !nestedObject.isDeleted()) {
                            set.add(nestedObject);
                        }
                    }
                    ++i;
                }
            }
        }
        return set;
    }

    public DataElement dereference() {
        if (this._isReference) {
            String name = this.getAttribute(2);
            if (this._referencedObject != null) {
                if (this._referencedObject.getId().equals(name)) {
                    return this._referencedObject;
                }
                this._referencedObject = null;
                this.delete();
                return null;
            }
            this._referencedObject = this._dataStore.find(name);
            if (this._referencedObject != null) {
                return this._referencedObject;
            }
            return null;
        }
        return this;
    }

    public DataElement doCommandOn(String command, boolean isSynchronized) {
        DataElement cmdDescriptor;
        DataElement status = null;
        if (this._dataStore != null && this._dataStore.isConnected() && (cmdDescriptor = this._dataStore.localDescriptorQuery(this.getDescriptor(), command)) != null) {
            status = isSynchronized ? this._dataStore.synchronizedCommand(cmdDescriptor, this) : this._dataStore.command(cmdDescriptor, this);
        }
        return status;
    }

    public Object getAdapter(Class key) {
        Object adapter = DesktopElement.getPlatformAdapter((Object)this, (Class)key);
        if (adapter != null) {
            return adapter;
        }
        if (PropertySource.matches((Class)key)) {
            if (this._propertySource == null) {
                this._propertySource = new PropertySource((IDataElement)this);
            }
            return this._propertySource;
        }
        if (DataElementActionFilter.matches((Class)key)) {
            return DataElementActionFilter.getInstance();
        }
        return null;
    }

    public String toString() {
        return "DataElement " + (this._isReference ? "reference" : "") + "\n{\n\tType:\t" + this.getType() + "\n\tName:\t" + this.getName() + "\n\tValue:\t" + this.getValue() + "\n\tID:\t" + this.getId() + "\n\tSource:\t" + this.getSource() + "\n\tDepth:\t" + this._depth + "\n\tDataStore:\t" + this._dataStore.getName() + "\n}\n";
    }

    public Object getElementProperty(Object name) {
        return this.getElementProperty(name, 3);
    }

    private Object getElementProperty(Object name, int depth) {
        if (depth == 0) {
            return null;
        }
        if (this._isReference) {
            if (this._referencedObject == null) {
                this.dereference();
            }
            if (this._referencedObject != null) {
                return this._referencedObject.getElementProperty(name, depth - 1);
            }
            return null;
        }
        if ("notifier".equals(name)) {
            return this._dataStore.getDomainNotifier();
        }
        if ("label".equals(name)) {
            return this.getAttribute(2);
        }
        if ("type".equals(name)) {
            return this.getAttribute(0);
        }
        if ("name".equals(name)) {
            return this.getAttribute(2);
        }
        if ("value".equals(name)) {
            return this.getAttribute(3);
        }
        if ("id".equals(name)) {
            return this.getAttribute(1);
        }
        if ("descriptor".equals(name)) {
            return this._descriptor;
        }
        if ("source".equals(name)) {
            String source = this.getAttribute(4);
            int locationIndex = source.lastIndexOf(":");
            if (locationIndex > 3) {
                return source.substring(0, locationIndex);
            }
            return source;
        }
        if ("buffer".equals(name)) {
            return this._buffer;
        }
        if ("sourcefile".equals(name)) {
            return this.getAttribute(4);
        }
        if ("sourcelocationcolumn".equals(name)) {
            return null;
        }
        if ("dataStore".equals(name)) {
            return this._dataStore.getName();
        }
        if ("nested".equals(name) || "children".equals(name)) {
            return this.getNestedData();
        }
        return null;
    }

    private void initialize() {
        this.initialize(null);
    }

    private void initialize(DataElement typeDescriptor) {
        String type;
        String refType;
        this._isReference = false;
        this._isDescriptor = false;
        this._depth = 1;
        this._referencedObject = null;
        this._isExpanded = false;
        this._isUpdated = false;
        this._descriptor = typeDescriptor;
        String depthStr = this.getAttribute(7);
        if (depthStr != null && depthStr.length() > 0 && !depthStr.equals("2")) {
            try {
                this._depth = Integer.parseInt(depthStr);
            }
            catch (Exception exception) {}
        }
        if ((refType = this.getAttribute(6)) != null) {
            if (refType.equals(DataStoreResources.TRUE) || refType.equals(DataStoreResources.REFERENCE)) {
                this._isReference = true;
                this._isSpirit = false;
            } else if (refType.equals(DataStoreResources.FALSE) || refType.equals(DataStoreResources.VALUE)) {
                this._isReference = false;
                this._isSpirit = false;
            } else if (refType.equals(DataStoreResources.SPIRIT)) {
                this._isReference = false;
                this._isSpirit = true;
            }
        }
        if ((type = this.getAttribute(0)).equals("objectdescriptor") || type.equals("commanddescriptor") || type.equals("relationdescriptor") || type.equals("abstractobjectdescriptor") || type.equals("abstractcommanddescriptor") || type.equals("abstractrelationdescriptor")) {
            this._isDescriptor = true;
        }
        if (this._nestedData != null) {
            this._nestedData.clear();
        }
    }

    protected synchronized void clear() {
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.length) {
                String att = this._attributes[i];
                if (att != null) {
                    Object var2_2 = null;
                }
                ++i;
            }
        }
        if (this._nestedData != null) {
            this._nestedData.clear();
        }
        this._parent = null;
        this._descriptor = null;
        this._referencedObject = null;
        this._propertySource = null;
        this._buffer = null;
    }

    public synchronized void delete() {
        if (!this.isDeleted()) {
            this.setAttribute(4, null);
            this.setAttribute(3, DataStoreResources.DELETED);
            this.setAttribute(0, null);
            this.setAttribute(2, null);
            this._isUpdated = false;
            this._isExpanded = true;
            this._buffer = null;
        }
    }

    public synchronized void notifyUpdate() {
        this.notify();
    }

    public synchronized void waitForUpdate(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (Exception exception) {}
    }
}

