/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dstore.core.miners.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.IByteStreamHandler;
import org.eclipse.rse.dstore.universal.miners.ICancellableHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalByteStreamHandler;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.ArchiveQueryThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.ClassFileParser;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileClassifier;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileDescriptors;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileQueryThread;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.UniversalDownloadHandler;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.UniversalSearchHandler;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.ClassFileUtil;

public class UniversalFileSystemMiner
extends Miner {
    public static final String MINER_ID;
    private DataElement deUFSnode;
    private DataElement deUFSuploadlog;
    protected String filterString = "*";
    protected ArchiveHandlerManager _archiveHandlerManager;
    protected boolean showHidden = false;
    public static final String CLASSNAME = "UniversalFileSystemMiner";
    protected HashMap _cancellableThreads = new HashMap();
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MINER_ID = clazz.getName();
    }

    public UniversalFileSystemMiner() {
        this._archiveHandlerManager = ArchiveHandlerManager.getInstance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemZipHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("zip", (Class)clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemJarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("jar", (Class)clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.SystemTarHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._archiveHandlerManager.setRegisteredHandler("tar", (Class)clazz3);
    }

    protected FileClassifier getFileClassifier(DataElement subject) {
        return new FileClassifier(subject);
    }

    public DataElement handleCommand(DataElement theElement) {
        boolean caseSensitive;
        String name = this.getCommandName(theElement);
        DataElement status = this.getCommandStatus(theElement);
        DataElement subject = this.getCommandArgument(theElement, 0);
        UniversalServerUtilities.logInfo(this.getName(), String.valueOf(name) + ":" + subject);
        String queryType = (String)subject.getElementProperty((Object)"type");
        boolean bl = caseSensitive = !this._isWindows;
        if ("C_QUERY_VIEW_ALL".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryAll(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryAll(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_VIEW_FILES".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryFiles(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryFiles(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_VIEW_FOLDERS".equals(name)) {
            DataElement attributes = this.getCommandArgument(theElement, 1);
            if (attributes != null && attributes.getType().equals("attributes")) {
                return this.handleQueryFolders(subject, attributes, status, queryType, caseSensitive);
            }
            return this.handleQueryFolders(subject, null, status, queryType, caseSensitive);
        }
        if ("C_QUERY_ROOTS".equals(name)) {
            return this.handleQueryRoots(subject, status);
        }
        if ("C_SEARCH".equals(name)) {
            return this.handleSearch(theElement, status, queryType, caseSensitive);
        }
        if ("C_CANCEL".equals(name)) {
            subject.getName();
            return this.handleCancel(subject, status);
        }
        if ("C_RENAME".equals(name)) {
            return this.handleRename(subject, status);
        }
        if ("C_DELETE".equals(name)) {
            return this.handleDelete(subject, status, true);
        }
        if ("C_DELETE_BATCH".equals(name)) {
            return this.handleDeleteBatch(theElement, status);
        }
        if ("C_COPY".equals(name)) {
            return this.handleCopy(subject, this.getCommandArgument(theElement, 1), this.getCommandArgument(theElement, 2), status);
        }
        if ("C_COPY_BATCH".equals(name)) {
            return this.handleCopyBatch(subject, theElement, status);
        }
        if ("C_CREATE_FILE".equals(name)) {
            return this.handleCreateFile(subject, status, queryType);
        }
        if ("C_CREATE_FOLDER".equals(name)) {
            return this.handleCreateFolder(subject, status, queryType);
        }
        if ("C_SET_READONLY".equals(name)) {
            return this.handleSetReadOnly(subject, status);
        }
        if ("C_SET_LASTMODIFIED".equals(name)) {
            return this.handleSetLastModified(subject, status);
        }
        if ("C_QUERY_BASIC_PROPERTY".equals(name)) {
            return this.handleQueryBasicProperty(subject, status);
        }
        if ("C_QUERY_CAN_WRITE_PROPERTY".equals(name)) {
            return this.handleQuerycanWriteProperty(subject, status);
        }
        if ("C_QUERY_ADVANCE_PROPERTY".equals(name)) {
            return this.handleQueryAdvanceProperty(subject, status);
        }
        if ("C_QUERY_FILE_CLASSIFICATIONS".equals(name)) {
            return this.handleQueryFileClassification(subject, status);
        }
        if ("C_QUERY_FILE_CLASSIFICATION".equals(name)) {
            return this.handleQueryFileClassification(subject, status);
        }
        if ("C_QUERY_EXISTS".equals(name)) {
            return this.handleQueryExists(subject, status, queryType);
        }
        if ("C_QUERY_GET_REMOTE_OBJECT".equals(name)) {
            return this.handleQueryGetRemoteObject(subject, status, queryType);
        }
        if ("C_GET_OSTYPE".equals(name)) {
            return this.handleGetOSType(subject, status);
        }
        if ("C_DOWNLOAD_FILE".equals(name)) {
            return this.handleDownload(theElement, status);
        }
        if ("C_SYSTEM_ENCODING".equals(name)) {
            return this.handleQueryEncoding(subject, status);
        }
        if ("C_QUERY_UNUSED_PORT".equals(name)) {
            return this.handleQueryUnusedPort(subject, status);
        }
        if ("C_QUERY_CLASSNAME".equals(name)) {
            return this.handleQueryClassName(subject, status);
        }
        if ("C_QUERY_QUALIFIED_CLASSNAME".equals(name)) {
            return this.handleQueryQualifiedClassName(subject, status);
        }
        UniversalServerUtilities.logError(CLASSNAME, "Invalid query to handlecommand", null);
        return this.statusDone(status);
    }

    private DataElement handleCopyBatch(DataElement targetFolder, DataElement theElement, DataElement status) {
        String targetType = targetFolder.getType();
        File tgtFolder = this.getFileFor(targetFolder);
        int numOfSources = theElement.getNestedSize() - 2;
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(targetFolder);
            ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
            boolean result = true;
            if (handler == null) {
                status.setAttribute(4, "failed");
                return this.statusDone(status);
            }
            ArrayList<File> nonDirectoryArrayList = new ArrayList<File>();
            ArrayList<String> nonDirectoryNamesArrayList = new ArrayList<String>();
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            int i = 0;
            while (i < numOfSources) {
                File srcFile;
                DataElement sourceFile = this.getCommandArgument(theElement, i + 1);
                String srcType = sourceFile.getType();
                String srcName = sourceFile.getName();
                if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                    srcFile = this.getFileFor(sourceFile);
                } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                    AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                    ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    if (shandler == null) {
                        status.setAttribute(4, "failed");
                        return this.statusDone(status);
                    }
                    VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
                    srcFile = child.getExtractedFile();
                } else {
                    status.setAttribute(4, "failed");
                    return this.statusDone(status);
                }
                if (srcFile.isDirectory()) {
                    result = handler.add(srcFile, virtualContainer, srcName);
                    if (!result) {
                        status.setAttribute(4, "failed");
                        return this.statusDone(status);
                    }
                } else {
                    nonDirectoryArrayList.add(srcFile);
                    nonDirectoryNamesArrayList.add(srcName);
                }
                ++i;
            }
            if (nonDirectoryArrayList.size() > 0) {
                File[] resultFiles = nonDirectoryArrayList.toArray(new File[nonDirectoryArrayList.size()]);
                String[] resultNames = nonDirectoryNamesArrayList.toArray(new String[nonDirectoryNamesArrayList.size()]);
                result = handler.add(resultFiles, virtualContainer, resultNames);
            }
            if (result) {
                status.setAttribute(4, "success");
            } else {
                status.setAttribute(4, "failed");
            }
            return this.statusDone(status);
        }
        boolean folderCopy = false;
        String source = "";
        String tgt = this.enQuote(tgtFolder.getAbsolutePath());
        int numOfNonVirtualSources = 0;
        int i = 0;
        while (i < numOfSources) {
            DataElement sourceFile = this.getCommandArgument(theElement, i + 1);
            String srcType = sourceFile.getType();
            if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                ISystemArchiveHandler shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                if (shandler == null) {
                    status.setAttribute(4, "failed");
                    return this.statusDone(status);
                }
                VirtualChild child = shandler.getVirtualFile(svpath.getVirtualPart());
                File parentDir = this.getFileFor(targetFolder);
                File destination = new File(parentDir, sourceFile.getName());
                if (child.isDirectory) {
                    shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination);
                } else {
                    shandler.extractVirtualFile(svpath.getVirtualPart(), destination);
                }
            } else {
                File srcFile = this.getFileFor(sourceFile);
                folderCopy = folderCopy || srcFile.isDirectory();
                String src = srcFile.getAbsolutePath();
                src = this.enQuote(src);
                if (this._isWindows) {
                    tgt = String.valueOf(tgtFolder.getAbsolutePath()) + File.separatorChar + srcFile.getName();
                    this.doCopyCommand(src, this.enQuote(tgt), folderCopy, status);
                    if (status.getAttribute(4) == "failed") {
                        break;
                    }
                } else {
                    source = numOfNonVirtualSources == 0 ? String.valueOf(source) + src : String.valueOf(source) + " " + src;
                    ++numOfNonVirtualSources;
                }
            }
            ++i;
        }
        if (numOfNonVirtualSources > 0) {
            this.doCopyCommand(source, tgt, folderCopy, status);
        }
        return this.statusDone(status);
    }

    protected void doCopyCommand(String source, String tgt, boolean folderCopy, DataElement status) {
        String command = null;
        if (this._isWindows) {
            if (folderCopy) {
                command = "xcopy " + source + " " + tgt + " /S /E /K /Q /H /I /Y";
            } else {
                String unquotedTgt = tgt.substring(1, tgt.length() - 1);
                File targetFile = new File(unquotedTgt);
                if (!targetFile.exists()) {
                    try {
                        targetFile.createNewFile();
                    }
                    catch (Exception e) {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, e.getMessage());
                        return;
                    }
                }
                command = "xcopy " + source + " " + tgt + " /Y /K /Q /H";
            }
        } else {
            command = folderCopy ? "cp  -Rp " + source + " " + tgt : "cp -p " + source + " " + tgt;
        }
        try {
            String theShell;
            Runtime runtime = Runtime.getRuntime();
            Process p = null;
            if (this._isWindows) {
                theShell = "cmd /C ";
                p = runtime.exec(String.valueOf(theShell) + command);
            } else {
                theShell = "sh";
                String[] args = new String[]{theShell, "-c", command};
                p = runtime.exec(args);
            }
            if (p != null) {
                p.waitFor();
                int result = p.exitValue();
                if (result != 0) {
                    InputStream errStream = p.getErrorStream();
                    StringBuffer errBuf = new StringBuffer();
                    byte[] bytes = null;
                    int numOfBytesRead = 0;
                    int available = errStream.available();
                    while (available > 0) {
                        bytes = new byte[available];
                        numOfBytesRead = errStream.read(bytes);
                        if (numOfBytesRead <= -1) break;
                        errBuf.append(new String(bytes, 0, numOfBytesRead));
                        available = errStream.available();
                    }
                    String err = errBuf.toString();
                    String newLine = System.getProperty("line.separator");
                    if (newLine != null && err.endsWith(newLine)) {
                        err = err.substring(0, err.length() - newLine.length());
                    }
                    if (err.length() > 0) {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, err);
                    } else {
                        status.setAttribute(4, "failed");
                        status.setAttribute(3, "unexpectedError");
                    }
                } else {
                    status.setAttribute(4, "success");
                }
            } else {
                status.setAttribute(4, "failed");
                status.setAttribute(3, "unexpectedError");
            }
        }
        catch (Exception e) {
            UniversalServerUtilities.logError(CLASSNAME, "Exception is handleCopy", e);
            status.setAttribute(4, "failed");
            status.setAttribute(3, e.getMessage());
        }
    }

    public void deleteDir(File fileObj, DataElement status) {
        try {
            File[] list = fileObj.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isFile()) {
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed");
                    }
                } else {
                    this.deleteDir(list[i], status);
                    if (!list[i].delete()) {
                        status.setAttribute(4, "failed");
                        UniversalServerUtilities.logWarning(CLASSNAME, "Deletion of dir failed");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            status.setAttribute(4, "failed with exception");
            status.setAttribute(3, e.getLocalizedMessage());
            UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir failed", e);
        }
    }

    public DataElement handleSearch(DataElement theElement, DataElement status, String queryType, boolean fileNamesCaseSensitive) {
        File fileobj = null;
        DataElement subject = this.getCommandArgument(theElement, 0);
        if (!(queryType.equals("universal.FolderObject") || queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFolderObject"))) {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleSearch", null);
            return this.statusDone(status);
        }
        fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        if (fileobj.exists()) {
            DataElement arg1 = this.getCommandArgument(theElement, 1);
            DataElement arg2 = this.getCommandArgument(theElement, 2);
            DataElement arg3 = this.getCommandArgument(theElement, 3);
            String textString = arg1.getType();
            boolean isCaseSensitive = Boolean.valueOf(arg1.getName());
            boolean isTextRegex = Boolean.valueOf(arg1.getSource());
            String fileNamesString = arg2.getType();
            boolean isFileNamesRegex = Boolean.valueOf(arg2.getName());
            String classification = arg2.getSource();
            boolean isIncludeArchives = Boolean.valueOf(arg3.getType());
            boolean isIncludeSubfolders = Boolean.valueOf(arg3.getName());
            Boolean.valueOf(arg3.getSource()).booleanValue();
            SystemSearchString searchString = new SystemSearchString(textString, isCaseSensitive, isTextRegex, fileNamesString, isFileNamesRegex, isIncludeArchives, isIncludeSubfolders, classification);
            UniversalSearchHandler searchThread = new UniversalSearchHandler(this._dataStore, this, searchString, !this._isWindows, fileobj, status);
            searchThread.start();
            this.updateCancellableThreads(status.getParent(), searchThread);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleCancel(DataElement subject, DataElement status) {
        ICancellableHandler thread = (ICancellableHandler)this._cancellableThreads.get(subject);
        if (thread != null && !thread.isDone()) {
            thread.cancel();
        }
        this.statusCancelled(status);
        return this.statusDone(status);
    }

    public DataElement handleQueryAll(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, false);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryAll", null);
        }
        if (fileobj != null) {
            if (!fileobj.exists()) {
                subject.setAttribute(0, "universal.FilterObject");
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "failed with does not exist");
                if (subject.getNestedSize() > 0) {
                    List children = subject.getNestedData();
                    int i = children.size() - 1;
                    while (i >= 0) {
                        this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                        --i;
                    }
                }
                this._dataStore.refresh(subject);
            } else {
                this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 8, status);
                return status;
            }
        }
        return this.statusDone(status);
    }

    protected void internalQueryAll(DataElement subject, File fileobj, String queryType, String filter, boolean caseSensitive, int inclusion, DataElement status) {
        FileQueryThread queryThread = new FileQueryThread(subject, fileobj, queryType, filter, caseSensitive, inclusion, this.showHidden, this._isWindows, status);
        queryThread.start();
        this.updateCancellableThreads(status.getParent(), queryThread);
    }

    private void updateCancellableThreads(DataElement command, ICancellableHandler thread) {
        Iterator iter = this._cancellableThreads.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String threadName = (String)iter.next();
                ICancellableHandler theThread = (ICancellableHandler)this._cancellableThreads.get(threadName);
                if (theThread != null && !theThread.isDone() && !theThread.isCancelled()) continue;
                this._cancellableThreads.remove(threadName);
            }
        }
        catch (Exception e) {
            this._dataStore.trace((Throwable)e);
        }
        this._cancellableThreads.put(command, thread);
    }

    public DataElement handleQueryFiles(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFiles", null);
        }
        if (!fileobj.exists()) {
            subject.setAttribute(0, "universal.FilterObject");
            subject.setAttribute(4, this.setProperties(fileobj));
            status.setAttribute(4, "failed with does not exist");
            if (subject.getNestedSize() > 0) {
                List children = subject.getNestedData();
                int i = children.size() - 1;
                while (i >= 0) {
                    this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                    --i;
                }
            }
        } else {
            this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 2, status);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryFolders(DataElement subject, DataElement attributes, DataElement status, String queryType, boolean caseSensitive) {
        if (queryType.equals("universal.ArchiveFileObject") || queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            return this.handleQueryAllArchive(subject, attributes, status, caseSensitive, true);
        }
        File fileobj = null;
        String filter = null;
        if (attributes != null) {
            filter = this.getFilterString(attributes.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(attributes.getAttribute(4));
        } else {
            filter = this.getFilterString(subject.getAttribute(4));
            this.showHidden = this.getShowHiddenFlag(subject.getAttribute(4));
        }
        if (queryType.equals("universal.FilterObject")) {
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryFolders", null);
        }
        if (!fileobj.exists()) {
            subject.setAttribute(0, "universal.FilterObject");
            subject.setAttribute(4, this.setProperties(fileobj));
            status.setAttribute(4, "failed with does not exist");
            if (subject.getNestedSize() > 0) {
                List children = subject.getNestedData();
                int i = children.size() - 1;
                while (i >= 0) {
                    this._dataStore.deleteObject(subject, (DataElement)children.get(i));
                    --i;
                }
            }
        } else {
            this.internalQueryAll(subject, fileobj, queryType, filter, caseSensitive, 4, status);
            return status;
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryRoots(DataElement subject, DataElement status) {
        new File(subject.getName());
        DataElement deObj = null;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            String[] ALLDRIVES = new String[]{"c:\\", "d:\\", "e:\\", "f:\\", "g:\\", "h:\\", "i:\\", "j:\\", "k:\\", "l:\\", "m:\\", "n:\\", "o:\\", "p:\\", "q:\\", "r:\\", "s:\\", "t:\\", "u:\\", "v:\\", "w:\\", "x:\\", "y:\\", "z:\\"};
            int idx = 0;
            while (idx < ALLDRIVES.length) {
                File drive = new File(ALLDRIVES[idx]);
                if (drive.exists()) {
                    try {
                        String path = drive.getCanonicalPath();
                        deObj = this._dataStore.createObject(subject, "universal.FolderObject", path);
                        deObj.setAttribute(4, this.setProperties(drive));
                        deObj.setAttribute(2, "");
                        deObj.setAttribute(3, path);
                    }
                    catch (IOException iOException) {
                        return this.statusDone(status);
                    }
                }
                ++idx;
            }
        } else {
            File[] list = File.listRoots();
            int i = 0;
            while (i < list.length) {
                deObj = this._dataStore.createObject(subject, "universal.FolderObject", list[i].getAbsolutePath());
                deObj.setAttribute(4, this.setProperties(list[i]));
                deObj.setAttribute(2, "");
                deObj.setAttribute(3, list[i].getAbsolutePath());
                ++i;
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleDelete(DataElement subject, DataElement status, boolean refreshDataStore) {
        String type = subject.getType();
        if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject")) {
            return this.handleDeleteFromArchive(subject, status);
        }
        File deleteObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        DataElement deObj = null;
        if (!deleteObj.exists()) {
            status.setAttribute(4, "failed with does not exist|" + deleteObj.getAbsolutePath());
            UniversalServerUtilities.logError(CLASSNAME, "The object to delete does not exist", null);
        } else {
            try {
                if (deleteObj.isFile()) {
                    if (!deleteObj.delete()) {
                        status.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                    } else {
                        deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                        this._dataStore.deleteObject(subject, deObj);
                        status.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                    this._dataStore.refresh(subject);
                } else if (deleteObj.isDirectory()) {
                    this.deleteDir(deleteObj, status);
                    if (!deleteObj.delete()) {
                        status.setAttribute(4, "failed|" + deleteObj.getAbsolutePath());
                        UniversalServerUtilities.logError(CLASSNAME, "Deletion of dir fialed", null);
                    } else {
                        this._dataStore.deleteObjects(subject);
                        DataElement parent = subject.getParent();
                        this._dataStore.deleteObject(parent, subject);
                        this._dataStore.refresh(parent);
                        status.setAttribute(4, "success|" + deleteObj.getAbsolutePath());
                    }
                } else {
                    UniversalServerUtilities.logError(CLASSNAME, "The object to delete is neither a File or Folder! in handleDelete", null);
                }
            }
            catch (Exception e) {
                status.setAttribute(4, "failed with exception|" + deleteObj.getAbsolutePath());
                status.setAttribute(3, e.getLocalizedMessage());
                UniversalServerUtilities.logError(CLASSNAME, "Delete of the object failed", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private DataElement handleDeleteBatch(DataElement theElement, DataElement status) {
        DataElement substatus = this._dataStore.createObject(null, "status", "substatus");
        int numOfSources = theElement.getNestedSize() - 2;
        int i = 0;
        while (i < numOfSources) {
            DataElement subject = this.getCommandArgument(theElement, i + 1);
            this.handleDelete(subject, substatus, false);
            ++i;
        }
        status.setAttribute(4, substatus.getSource());
        return this.statusDone(status);
    }

    public DataElement handleRename(DataElement subject, DataElement status) {
        File fileoldname = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        File filerename = new File(subject.getAttribute(4));
        if (ArchiveHandlerManager.isVirtual((String)fileoldname.getAbsolutePath())) {
            boolean success;
            AbsoluteVirtualPath oldAbsPath = new AbsoluteVirtualPath(fileoldname.getAbsolutePath());
            AbsoluteVirtualPath newAbsPath = new AbsoluteVirtualPath(filerename.getAbsolutePath());
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(oldAbsPath.getContainingArchiveString()));
            boolean bl = success = handler != null && handler.fullRename(oldAbsPath.getVirtualPart(), newAbsPath.getVirtualPart());
            if (success && handler != null) {
                subject.setAttribute(2, filerename.getName());
                subject.setAttribute(4, this.setProperties(handler.getVirtualFile(newAbsPath.getVirtualPart())));
                status.setAttribute(4, "success");
                this._dataStore.update(subject);
            } else {
                status.setAttribute(4, "failed");
            }
            this._dataStore.refresh(subject);
            return this.statusDone(status);
        }
        if (filerename.exists()) {
            status.setAttribute(4, "failed with exist");
        } else {
            try {
                boolean done = fileoldname.renameTo(filerename);
                if (done) {
                    subject.setAttribute(2, filerename.getName());
                    subject.setAttribute(4, this.setProperties(filerename));
                    status.setAttribute(4, "success");
                    if (filerename.isDirectory()) {
                        this.updateChildProperties(subject, filerename);
                    }
                    this._dataStore.update(subject);
                } else {
                    status.setAttribute(4, "failed");
                }
            }
            catch (Exception e) {
                status.setAttribute(4, "failed");
                UniversalServerUtilities.logError(CLASSNAME, "handleRename failed", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private void updateChildProperties(DataElement subject, File filerename) {
        int nestedSize = subject.getNestedSize();
        int i = 0;
        while (i < nestedSize) {
            DataElement child = subject.get(i);
            child.setAttribute(3, filerename.getAbsolutePath());
            if (child.getNestedSize() > 0) {
                File childFile = new File(filerename, child.getName());
                this.updateChildProperties(child, childFile);
            }
            ++i;
        }
    }

    public DataElement handleCreateFile(DataElement subject, DataElement status, String queryType) {
        boolean wasFilter = queryType.equals("universal.FilterObject");
        if (queryType.equals("universal.VirtualFileObject")) {
            return this.handleCreateVirtualFile(subject, status, queryType);
        }
        File filename = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                subject.setAttribute(0, "universal.VirtualFileObject");
                return this.handleCreateVirtualFile(subject, status, queryType);
            }
            filename = new File(subject.getValue());
            subject.setAttribute(0, "universal.FileObject");
            subject.setAttribute(4, this.setProperties(filename));
        } else if (queryType.equals("universal.FileObject")) {
            filename = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleCreateFile", null);
        }
        if (filename != null) {
            if (filename.exists()) {
                status.setAttribute(4, "failed with exist");
            } else {
                try {
                    boolean done = filename.createNewFile();
                    if (ArchiveHandlerManager.getInstance().isArchive(filename)) {
                        done = ArchiveHandlerManager.getInstance().createEmptyArchive(filename);
                        if (done) {
                            subject.setAttribute(0, "universal.ArchiveFileObject");
                        }
                    } else if (done) {
                        subject.setAttribute(0, "universal.FileObject");
                    }
                    subject.setAttribute(4, this.setProperties(filename));
                    if (done) {
                        status.setAttribute(4, "success");
                        if (wasFilter) {
                            String fullName = subject.getValue();
                            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                            subject.setAttribute(2, name);
                            subject.setAttribute(3, path);
                        }
                    } else {
                        status.setAttribute(4, "failed");
                    }
                }
                catch (Exception e) {
                    UniversalServerUtilities.logError(CLASSNAME, "handleCreateFile failed", e);
                    status.setAttribute(4, "failed");
                }
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleCreateFolder(DataElement subject, DataElement status, String queryType) {
        if (queryType.equals("universal.VirtualFolderObject")) {
            return this.handleCreateVirtualFolder(subject, status, queryType);
        }
        File filename = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                subject.setAttribute(0, "universal.VirtualFolderObject");
                return this.handleCreateVirtualFolder(subject, status, queryType);
            }
            filename = new File(subject.getValue());
            subject.setAttribute(0, "universal.FolderObject");
            subject.setAttribute(4, this.setProperties(filename));
        } else if (queryType.equals("universal.FolderObject")) {
            filename = new File(subject.getValue());
        } else {
            UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleCreateFolder", null);
        }
        if (filename != null) {
            if (filename.exists()) {
                status.setAttribute(4, "failed with exist");
            } else {
                try {
                    boolean done = filename.mkdirs();
                    if (done) {
                        status.setAttribute(4, "success");
                        subject.setAttribute(4, this.setProperties(filename));
                        subject.setAttribute(0, "universal.FolderObject");
                        subject.setAttribute(2, filename.getName());
                        subject.setAttribute(3, filename.getParentFile().getAbsolutePath());
                    } else {
                        status.setAttribute(4, "failed");
                    }
                }
                catch (Exception e) {
                    UniversalServerUtilities.logError(CLASSNAME, "handleCreateFolder failed", e);
                    status.setAttribute(4, "failed");
                }
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleSetReadOnly(DataElement subject, DataElement status) {
        File filename = new File(subject.getAttribute(3), subject.getAttribute(2));
        if (!filename.exists()) {
            filename = new File(subject.getAttribute(3));
        }
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                String str = subject.getAttribute(4);
                boolean readOnly = "true".equals(str);
                boolean done = false;
                if (readOnly != filename.canWrite()) {
                    done = true;
                } else if (readOnly) {
                    done = filename.setReadOnly();
                } else if (!this._isWindows) {
                    String[] cmd = new String[]{"chmod", "u+w", filename.getAbsolutePath()};
                    Process p = Runtime.getRuntime().exec(cmd);
                    int exitValue = p.waitFor();
                    done = exitValue == 0;
                } else {
                    String[] cmd = new String[]{"attrib", "-R", filename.getAbsolutePath()};
                    Process p = Runtime.getRuntime().exec(cmd);
                    int exitValue = p.waitFor();
                    boolean bl = done = exitValue == 0;
                }
                if (done) {
                    status.setAttribute(4, "success");
                } else {
                    status.setAttribute(4, "failed");
                }
                filename = new File(filename.getAbsolutePath());
                subject.setAttribute(4, this.setProperties(filename));
                this._dataStore.refresh(subject);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetreadOnly", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleSetLastModified(DataElement subject, DataElement status) {
        File filename = new File(subject.getAttribute(3), subject.getAttribute(2));
        if (!filename.exists()) {
            filename = new File(subject.getAttribute(3));
        }
        if (!filename.exists()) {
            status.setAttribute(4, "failed with does not exist");
        } else {
            try {
                String str = subject.getAttribute(4);
                long date = Long.parseLong(str);
                boolean done = filename.setLastModified(date);
                if (done) {
                    status.setAttribute(4, "success");
                } else {
                    status.setAttribute(4, "failed");
                }
                filename = new File(filename.getAbsolutePath());
                subject.setAttribute(4, this.setProperties(filename));
                this._dataStore.refresh(subject);
            }
            catch (Exception e) {
                UniversalServerUtilities.logError(CLASSNAME, "handleSetLastModified", e);
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryBasicProperty(DataElement subject, DataElement status) {
        File fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        subject.setAttribute(4, this.setProperties(fileobj));
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQuerycanWriteProperty(DataElement subject, DataElement status) {
        File fileObj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(50);
        boolean canWrite = fileObj.canWrite();
        buffer.append(version).append("|").append(canWrite);
        subject.setAttribute(4, buffer.toString());
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryAdvanceProperty(DataElement subject, DataElement status) {
        return this.statusDone(status);
    }

    protected DataElement handleQueryFileClassification(DataElement subject, DataElement status) {
        FileClassifier classifier = this.getFileClassifier(subject);
        classifier.start();
        this.statusDone(status);
        return status;
    }

    protected DataElement handleQueryExists(DataElement subject, DataElement status, String queryType) {
        File fileobj = null;
        if (queryType.equals("universal.FilterObject")) {
            if (subject.getName().indexOf("#virtual#/") > 0) {
                VirtualChild child = this._archiveHandlerManager.getVirtualObject(subject.getName());
                if (child.exists()) {
                    status.setAttribute(4, "true");
                    return this.statusDone(status);
                }
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            fileobj = new File(subject.getName());
        } else if (queryType.equals("universal.FileObject") || queryType.equals("universal.ArchiveFileObject")) {
            fileobj = new File(String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName());
        } else if (queryType.equals("universal.FolderObject")) {
            fileobj = new File(subject.getAttribute(3));
        } else if (queryType.equals("universal.VirtualFileObject") || queryType.equals("universal.VirtualFolderObject")) {
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(subject);
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null) {
                status.setAttribute(4, "false");
                return this.statusDone(status);
            }
            VirtualChild child = handler.getVirtualFile(vpath.getVirtualPart());
            if (child.exists()) {
                status.setAttribute(4, "true");
                return this.statusDone(status);
            }
        }
        if (fileobj != null && fileobj.exists()) {
            status.setAttribute(4, "true");
        } else {
            status.setAttribute(4, "false");
        }
        return this.statusDone(status);
    }

    public DataElement handleQueryGetRemoteObject(DataElement subject, DataElement status, String queryType) {
        block27: {
            String path;
            String name;
            File fileobj = null;
            boolean isVirtual = false;
            String fullName = subject.getValue();
            if (queryType.equals("universal.FilterObject")) {
                isVirtual = ArchiveHandlerManager.isVirtual((String)fullName);
                String filterValue = subject.getValue();
                if (filterValue.equals(".")) {
                    filterValue = System.getProperty("user.home");
                    subject.setAttribute(3, filterValue);
                }
                if (!isVirtual) {
                    fileobj = new File(filterValue);
                }
            } else if (queryType.equals("universal.FileObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = new File(path, name);
            } else if (queryType.equals("universal.FolderObject")) {
                name = subject.getName();
                path = subject.getValue();
                fileobj = name.length() == 0 ? new File(path) : new File(path, name);
            } else {
                UniversalServerUtilities.logError(CLASSNAME, "Invalid query type to handleQueryGetRemoteObject", null);
                return this.statusDone(status);
            }
            if (!isVirtual && fileobj != null && fileobj.exists()) {
                try {
                    fullName = fileobj.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return this.statusDone(status);
                }
                if (fileobj.isFile()) {
                    if (this._archiveHandlerManager.isArchive(fileobj)) {
                        subject.setAttribute(0, "universal.ArchiveFileObject");
                    } else {
                        subject.setAttribute(0, "universal.FileObject");
                    }
                } else {
                    subject.setAttribute(0, "universal.FolderObject");
                }
                name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
                int lastFileSeparatorIndex = fullName.lastIndexOf(File.separatorChar);
                String path2 = "";
                if (-1 != lastFileSeparatorIndex) {
                    path2 = lastFileSeparatorIndex == 0 ? Character.toString(File.separatorChar) : fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
                }
                subject.setAttribute(2, name);
                subject.setAttribute(3, path2);
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "success");
            } else if (isVirtual) {
                try {
                    String goodFullName = ArchiveHandlerManager.cleanUpVirtualPath((String)fullName);
                    AbsoluteVirtualPath avp = new AbsoluteVirtualPath(goodFullName);
                    VirtualChild child = this._archiveHandlerManager.getVirtualObject(goodFullName);
                    if (child.exists()) {
                        if (child.isDirectory) {
                            subject.setAttribute(0, "universal.VirtualFolderObject");
                            subject.setAttribute(2, child.name);
                            if (child.path.equals("")) {
                                subject.setAttribute(3, avp.getContainingArchiveString());
                            } else {
                                subject.setAttribute(3, String.valueOf(avp.getContainingArchiveString()) + "#virtual#/" + child.path);
                            }
                        } else {
                            subject.setAttribute(0, "universal.VirtualFileObject");
                            String name2 = child.name;
                            String path3 = avp.getContainingArchiveString();
                            if (!child.path.equals("")) {
                                path3 = String.valueOf(path3) + "#virtual#/" + child.path;
                            }
                            subject.setAttribute(2, name2);
                            subject.setAttribute(3, path3);
                        }
                        subject.setAttribute(4, this.setProperties(child));
                        status.setAttribute(4, "success");
                        break block27;
                    }
                    UniversalServerUtilities.logWarning(CLASSNAME, "object does not exist");
                    subject.setAttribute(4, this.setProperties(child));
                    status.setAttribute(4, "failed with does not exist");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                subject.setAttribute(0, "universal.FilterObject");
                subject.setAttribute(4, this.setProperties(fileobj));
                status.setAttribute(4, "failed with does not exist");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement getFileElement(DataElement subject, File file) {
        String fileName = file.getName();
        int i = 0;
        while (i < subject.getNestedSize()) {
            DataElement child = subject.get(i);
            if (child.getName().equals(fileName)) {
                String type = subject.getType();
                boolean isfile = file.isFile();
                if (isfile) {
                    return child;
                }
                if (type.equals("universal.FolderObject")) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    protected String getClassificationString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 10) {
            return null;
        }
        return str[10];
    }

    protected String getFilterString(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 1) {
            return str[1];
        }
        System.out.println("problem with properties:" + s);
        return "*";
    }

    protected boolean getShowHiddenFlag(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens > 2) {
            return new Boolean(str[2]);
        }
        System.out.println("show hidden flag problem:" + s);
        return true;
    }

    protected int getDepth(String s) {
        String[] str = s.split("\\|");
        int tokens = str.length;
        if (tokens < 4) {
            return 1;
        }
        return new Integer(str[3]);
    }

    protected DataElement handleDownload(DataElement theElement, DataElement status) {
        UniversalDownloadHandler downloadThread = new UniversalDownloadHandler(this._dataStore, this, theElement, status);
        downloadThread.start();
        this.updateCancellableThreads(status.getParent(), downloadThread);
        return status;
    }

    protected DataElement handleQueryEncoding(DataElement subject, DataElement status) {
        String encoding = System.getProperty("file.encoding");
        subject.setAttribute(3, encoding);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected DataElement handleQueryUnusedPort(DataElement subject, DataElement status) {
        int port = -1;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            UniversalServerUtilities.logError(CLASSNAME, "Can not get unused port", e);
            port = -1;
        }
        String portNum = String.valueOf(port);
        subject.setAttribute(3, portNum);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement statusDone(DataElement status) {
        status.setAttribute(2, DataStoreResources.model_done);
        this._dataStore.refresh(status);
        return status;
    }

    public DataElement statusCancelled(DataElement status) {
        status.setAttribute(2, "cancelled");
        this._dataStore.refresh(status);
        return status;
    }

    public void load() {
        this.deUFSnode = this._dataStore.createObject(this._minerData, "universal.node", "universal.node");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.temp");
        this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.filters");
        this.deUFSuploadlog = this._dataStore.createObject(this.deUFSnode, "universal.node", "universal.uploadlog");
        UniversalByteStreamHandler universalHandler = new UniversalByteStreamHandler(this._dataStore, this.deUFSuploadlog);
        this._dataStore.registerByteStreamHandler((IByteStreamHandler)universalHandler);
        this._dataStore.refresh(this._minerData);
        this._dataStore.refresh(this.deUFSuploadlog);
    }

    public void finish() {
        super.finish();
    }

    protected DataElement handleQueryClassName(DataElement subject, DataElement status) {
        String filename = String.valueOf(subject.getAttribute(3)) + File.separatorChar + subject.getName();
        try {
            ClassFileParser parser = new ClassFileParser(this.getInputStreamForFile(filename));
            String name = parser.getPackageName();
            if (name != null) {
                this._dataStore.createObject(status, "qualifiedClassName", name);
            } else {
                this._dataStore.createObject(status, "qualifiedClassName", "null");
            }
        }
        catch (IOException iOException) {
            this._dataStore.createObject(status, "qualifiedClassName", "null");
        }
        return this.statusDone(status);
    }

    protected DataElement handleQueryQualifiedClassName(DataElement subject, DataElement status) {
        String parentPath = subject.getAttribute(3);
        String sep = File.separator;
        boolean isParentArchive = ArchiveHandlerManager.getInstance().isRegisteredArchive(parentPath);
        boolean isParentVirtual = ArchiveHandlerManager.isVirtual((String)parentPath);
        if (isParentVirtual) {
            sep = "/";
        }
        String filePath = null;
        if (!isParentArchive) {
            if (!parentPath.endsWith(sep)) {
                parentPath = String.valueOf(parentPath) + sep;
            }
            filePath = String.valueOf(parentPath) + subject.getName();
        } else {
            filePath = String.valueOf(parentPath) + "#virtual#/" + subject.getName();
        }
        try {
            String className = null;
            if (!isParentArchive && !isParentVirtual) {
                className = ClassFileUtil.getInstance().getQualifiedClassName(filePath);
            } else {
                int jdx;
                String execJava;
                String classification = SystemFileClassifier.getInstance().classifyFile(filePath);
                int idx = classification.indexOf(execJava = "executable(java:");
                if (idx != -1 && (jdx = classification.indexOf(")", idx += execJava.length())) != -1) {
                    if (jdx > idx) {
                        className = classification.substring(idx, jdx);
                    } else if (jdx == idx) {
                        className = "";
                    }
                }
            }
            if (className != null) {
                this._dataStore.createObject(status, "fullClassName", className);
            } else {
                this._dataStore.createObject(status, "fullClassName", "null");
            }
        }
        catch (IOException iOException) {
            UniversalServerUtilities.logError(CLASSNAME, "I/O error occured trying to read class file " + filePath, null);
            this._dataStore.createObject(status, "fullClassName", "null");
        }
        return this.statusDone(status);
    }

    public DataElement handleGetOSType(DataElement subject, DataElement status) {
        String osType = System.getProperty("os.name").toLowerCase();
        status.setAttribute(4, osType);
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    protected InputStream getInputStreamForFile(String filename) throws IOException {
        File file = new File(filename);
        return file.toURL().openStream();
    }

    public void extendSchema(DataElement schemaRoot) {
        this._dataStore.find(schemaRoot, 2, DataStoreResources.model_root, 1);
        this.createObjectDescriptor(schemaRoot, "universal.node");
        DataElement tempnode = this.createObjectDescriptor(schemaRoot, "universal.temp");
        DataElement UniversalFilter = this.createObjectDescriptor(schemaRoot, "universal.FilterObject");
        FileDescriptors._deUniversalFileObject = this.createObjectDescriptor(schemaRoot, "universal.FileObject");
        FileDescriptors._deUniversalFolderObject = this.createObjectDescriptor(schemaRoot, "universal.FolderObject");
        FileDescriptors._deUniversalArchiveFileObject = this.createObjectDescriptor(schemaRoot, "universal.ArchiveFileObject");
        FileDescriptors._deUniversalVirtualFileObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFileObject");
        FileDescriptors._deUniversalVirtualFolderObject = this.createObjectDescriptor(schemaRoot, "universal.VirtualFolderObject");
        this._dataStore.refresh(schemaRoot);
        DataElement cancellable = this._dataStore.find(schemaRoot, 2, DataStoreResources.model_Cancellable, 1);
        DataElement queryAllFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllFilterDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFilesFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesFilterDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFolderFilterDescriptor = this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderFilterDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this.createCommandDescriptor(UniversalFilter, "Filter", "C_QUERY_ROOTS");
        DataElement queryAllDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFilesDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFolderDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryAllArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_ALL");
        this._dataStore.createReference(cancellable, queryAllArchiveDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFilesArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FILES");
        this._dataStore.createReference(cancellable, queryFilesArchiveDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement queryFolderArchiveDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "Filter", "C_QUERY_VIEW_FOLDERS");
        this._dataStore.createReference(cancellable, queryFolderArchiveDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this.createCommandDescriptor(UniversalFilter, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(UniversalFilter, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(UniversalFilter, "GetRemoteObject", "C_QUERY_GET_REMOTE_OBJECT");
        this.createCommandDescriptor(UniversalFilter, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(UniversalFilter, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(UniversalFilter, "SetLastModified", "C_SET_LASTMODIFIED");
        this._dataStore.createReference(FileDescriptors._deUniversalFileObject, FileDescriptors._deUniversalArchiveFileObject, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this._dataStore.createReference(FileDescriptors._deUniversalFolderObject, FileDescriptors._deUniversalArchiveFileObject, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this._dataStore.createReference(FileDescriptors._deUniversalFileObject, FileDescriptors._deUniversalVirtualFileObject, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this._dataStore.createReference(FileDescriptors._deUniversalFolderObject, FileDescriptors._deUniversalVirtualFolderObject, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement searchDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Search", "C_SEARCH");
        this._dataStore.createReference(cancellable, searchDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(tempnode, "Filter", "C_CREATE_TEMP");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Delete", "C_DELETE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "DeleteBatch", "C_DELETE_BATCH");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Rename", "C_RENAME");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetAdvanceProperty", "C_QUERY_ADVANCE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Delete", "C_DELETE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "DeleteBatch", "C_DELETE_BATCH");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Rename", "C_RENAME");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Copy", "C_COPY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CopyBatch", "C_COPY_BATCH");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "SetReadOnly", "C_SET_READONLY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "SetLastModified", "C_SET_LASTMODIFIED");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetBasicProperty", "C_QUERY_BASIC_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetcanWriteProperty", "C_QUERY_CAN_WRITE_PROPERTY");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetFileClassifications", "C_QUERY_FILE_CLASSIFICATIONS");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetFolderClassifications", "C_QUERY_FILE_CLASSIFICATION");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "Exists", "C_QUERY_EXISTS");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CreateNewFile", "C_CREATE_FILE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "CreateNewFolder", "C_CREATE_FOLDER");
        this.createCommandDescriptor(FileDescriptors._deUniversalFolderObject, "GetOSType", "C_GET_OSTYPE");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetOSType", "C_GET_OSTYPE");
        DataElement downloadDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, downloadDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        DataElement adownloadDescriptor = this.createCommandDescriptor(FileDescriptors._deUniversalArchiveFileObject, "DownloadFile", "C_DOWNLOAD_FILE");
        this._dataStore.createReference(cancellable, adownloadDescriptor, DataStoreResources.model_abstracts, DataStoreResources.model_abstracted_by);
        this.createCommandDescriptor(tempnode, "SystemEncoding", "C_SYSTEM_ENCODING");
        this.createCommandDescriptor(tempnode, "UnusedPort", "C_QUERY_UNUSED_PORT");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetQualifiedClassName", "C_QUERY_CLASSNAME");
        this.createCommandDescriptor(FileDescriptors._deUniversalFileObject, "GetFullClassName", "C_QUERY_QUALIFIED_CLASSNAME");
    }

    private AbsoluteVirtualPath getAbsoluteVirtualPath(DataElement subject) {
        StringBuffer path = new StringBuffer(subject.getAttribute(3));
        if (ArchiveHandlerManager.getInstance().isArchive(new File(path.toString()))) {
            path.append("#virtual#/");
        } else {
            path.append('/');
        }
        path.append(subject.getName());
        return this.getAbsoluteVirtualPath(path.toString());
    }

    public AbsoluteVirtualPath getAbsoluteVirtualPath(String path) {
        AbsoluteVirtualPath vp = new AbsoluteVirtualPath(path);
        return vp;
    }

    public DataElement handleDeleteFromArchive(DataElement subject, DataElement status) {
        String type = subject.getType();
        DataElement deObj = null;
        AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(subject);
        if (vpath != null) {
            ISystemArchiveHandler handler = this._archiveHandlerManager.getRegisteredHandler(new File(vpath.getContainingArchiveString()));
            if (handler == null || !handler.delete(vpath.getVirtualPart())) {
                status.setAttribute(4, "failed|" + vpath.toString());
                this._dataStore.refresh(subject);
                return this.statusDone(status);
            }
            if (type.equals("universal.VirtualFileObject")) {
                deObj = this._dataStore.find(subject, 2, subject.getName(), 1);
                this._dataStore.deleteObject(subject, deObj);
                status.setAttribute(4, "success");
            } else if (type.equals("universal.VirtualFolderObject")) {
                this._dataStore.deleteObjects(subject);
                DataElement parent = subject.getParent();
                this._dataStore.deleteObject(parent, subject);
                this._dataStore.refresh(parent);
                status.setAttribute(4, "success");
            }
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleQueryAllArchive(DataElement subject, DataElement attributes, DataElement status, boolean caseSensitive, boolean foldersOnly) {
        ArchiveQueryThread queryThread = new ArchiveQueryThread(subject, attributes, caseSensitive, foldersOnly, this.showHidden, this._isWindows, status);
        queryThread.start();
        this.updateCancellableThreads(status.getParent(), queryThread);
        return status;
    }

    public ISystemArchiveHandler getArchiveHandlerFor(String archivePath) {
        File file = new File(archivePath);
        return this._archiveHandlerManager.getRegisteredHandler(file);
    }

    public DataElement handleCreateVirtualFile(DataElement subject, DataElement status, String type) {
        AbsoluteVirtualPath vpath = null;
        vpath = type.equals("universal.FilterObject") ? this.getAbsoluteVirtualPath(subject.getValue()) : this.getAbsoluteVirtualPath(subject);
        ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
        if (handler == null) {
            status.setAttribute(4, "failed");
            return this.statusDone(status);
        }
        handler.getVirtualFile(vpath.getVirtualPart());
        handler.createFile(vpath.getVirtualPart());
        status.setAttribute(4, "success");
        if (type.equals("universal.FilterObject")) {
            String fullName = subject.getValue();
            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
            subject.setAttribute(2, name);
            subject.setAttribute(3, path);
            subject.setAttribute(0, "universal.VirtualFileObject");
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    public DataElement handleCreateVirtualFolder(DataElement subject, DataElement status, String type) {
        AbsoluteVirtualPath vpath = null;
        vpath = type.equals("universal.FilterObject") ? this.getAbsoluteVirtualPath(subject.getValue()) : this.getAbsoluteVirtualPath(subject);
        ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
        if (handler == null) {
            status.setAttribute(4, "failed");
            return this.statusDone(status);
        }
        handler.getVirtualFile(vpath.getVirtualPart());
        handler.createFolder(vpath.getVirtualPart());
        status.setAttribute(4, "success");
        if (type.equals("universal.FilterObject")) {
            String fullName = subject.getValue();
            String name = fullName.substring(fullName.lastIndexOf(File.separatorChar) + 1, fullName.length());
            String path = fullName.substring(0, fullName.lastIndexOf(File.separatorChar));
            subject.setAttribute(2, name);
            subject.setAttribute(3, path);
            subject.setAttribute(0, "universal.VirtualFolderObject");
        }
        this._dataStore.refresh(subject);
        return this.statusDone(status);
    }

    private File getFileFor(DataElement element) {
        File result = null;
        String type = element.getType();
        if (type.equals("universal.FilterObject")) {
            result = new File(element.getName());
        } else if (type.equals("universal.FileObject") || type.equals("universal.FolderObject") || type.equals("universal.ArchiveFileObject")) {
            StringBuffer buf = new StringBuffer(element.getAttribute(3));
            buf.append(File.separatorChar);
            buf.append(element.getName());
            result = new File(buf.toString());
        }
        return result;
    }

    public DataElement handleCopy(DataElement targetFolder, DataElement sourceFile, DataElement nameObj, DataElement status) {
        String goodFullName;
        String newName = nameObj.getName();
        String targetType = targetFolder.getType();
        String srcType = sourceFile.getType();
        File srcFile = null;
        VirtualChild child = null;
        if ("universal.FilterObject" == srcType && ArchiveHandlerManager.isVirtual((String)sourceFile.getValue()) && (child = this._archiveHandlerManager.getVirtualObject(goodFullName = ArchiveHandlerManager.cleanUpVirtualPath((String)sourceFile.getValue()))).exists()) {
            srcType = child.isDirectory ? "universal.VirtualFolderObject" : "universal.VirtualFileObject";
        }
        if (targetType.equals("universal.ArchiveFileObject") || targetType.equals("universal.VirtualFolderObject")) {
            boolean result;
            AbsoluteVirtualPath vpath = this.getAbsoluteVirtualPath(targetFolder);
            ISystemArchiveHandler handler = this.getArchiveHandlerFor(vpath.getContainingArchiveString());
            if (handler == null) {
                status.setAttribute(4, "failed");
                return this.statusDone(status);
            }
            if (srcType.equals("universal.FileObject") || srcType.equals("universal.FolderObject") || srcType.equals("universal.ArchiveFileObject")) {
                srcFile = this.getFileFor(sourceFile);
            } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
                ISystemArchiveHandler shandler = null;
                if (child == null) {
                    AbsoluteVirtualPath svpath = this.getAbsoluteVirtualPath(sourceFile);
                    shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                    if (shandler == null) {
                        status.setAttribute(4, "failed");
                        return this.statusDone(status);
                    }
                    child = shandler.getVirtualFile(svpath.getVirtualPart());
                } else {
                    shandler = child.getHandler();
                }
                srcFile = child.getExtractedFile();
            }
            String virtualContainer = "";
            if (targetType.equals("universal.VirtualFolderObject")) {
                virtualContainer = vpath.getVirtualPart();
            }
            if (result = handler.add(srcFile, virtualContainer, newName)) {
                status.setAttribute(4, "success");
            } else {
                status.setAttribute(4, "failed");
            }
        } else if (srcType.equals("universal.VirtualFileObject") || srcType.equals("universal.VirtualFolderObject")) {
            ISystemArchiveHandler shandler = null;
            AbsoluteVirtualPath svpath = null;
            if (child == null) {
                svpath = this.getAbsoluteVirtualPath(sourceFile);
                shandler = this.getArchiveHandlerFor(svpath.getContainingArchiveString());
                if (shandler == null) {
                    status.setAttribute(4, "failed");
                    return this.statusDone(status);
                }
                child = shandler.getVirtualFile(svpath.getVirtualPart());
            } else {
                shandler = child.getHandler();
                svpath = this.getAbsoluteVirtualPath(sourceFile.getValue());
            }
            File parentDir = this.getFileFor(targetFolder);
            File destination = new File(parentDir, newName);
            if (child.isDirectory) {
                shandler.extractVirtualDirectory(svpath.getVirtualPart(), parentDir, destination);
            } else {
                shandler.extractVirtualFile(svpath.getVirtualPart(), destination);
            }
        } else {
            File tgtFolder = this.getFileFor(targetFolder);
            srcFile = this.getFileFor(sourceFile);
            boolean folderCopy = srcFile.isDirectory();
            String src = srcFile.getAbsolutePath();
            String tgt = String.valueOf(tgtFolder.getAbsolutePath()) + File.separatorChar + newName;
            File tgtFile = new File(tgt);
            if (tgtFile.exists() && tgtFile.isDirectory() && newName.equals(srcFile.getName()) && !this._isWindows) {
                tgt = tgtFolder.getAbsolutePath();
            }
            this.doCopyCommand(this.enQuote(src), this.enQuote(tgt), folderCopy, status);
        }
        return this.statusDone(status);
    }

    public String setProperties(File fileObj, boolean doArchiveProperties) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.lastModified();
        long size = fileObj.length();
        boolean hidden = fileObj.isHidden();
        boolean canWrite = fileObj.canWrite();
        boolean canRead = fileObj.canRead();
        boolean isArchive = false;
        String comment = isArchive ? ArchiveHandlerManager.getInstance().getComment(fileObj) : " ";
        long compressedSize = size;
        String compressionMethod = " ";
        double compressionRatio = 0.0;
        long expandedSize = isArchive ? ArchiveHandlerManager.getInstance().getExpandedSize(fileObj) : size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        String buf = buffer.toString();
        return buf;
    }

    public String setProperties(VirtualChild fileObj) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.getTimeStamp();
        long size = fileObj.getSize();
        boolean hidden = false;
        boolean canWrite = fileObj.getContainingArchive().canWrite();
        boolean canRead = fileObj.getContainingArchive().canRead();
        String comment = fileObj.getComment();
        if (comment.equals("")) {
            comment = " ";
        }
        long compressedSize = fileObj.getCompressedSize();
        String compressionMethod = fileObj.getCompressionMethod();
        if (compressionMethod.equals("")) {
            compressionMethod = " ";
        }
        double compressionRatio = fileObj.getCompressionRatio();
        long expandedSize = size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        return buffer.toString();
    }

    public String setProperties(File fileObj) {
        return this.setProperties(fileObj, false);
    }

    protected String enQuote(String s) {
        if (this._isWindows) {
            return String.valueOf('\"') + s + '\"';
        }
        return PathUtility.enQuoteUnix((String)s);
    }

    public String getVersion() {
        return "7.0.0";
    }
}

