/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterPoolName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterPoolAdapter
extends AbstractSystemViewAdapter {
    protected String translatedType;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        ISubSystemConfigurationAdapter adapter;
        IAction[] actions;
        ISystemFilterPool pool = (ISystemFilterPool)selection.getFirstElement();
        ISubSystemConfiguration ssFactory = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilterPool)pool);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((actions = (adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)).getFilterPoolActions(menu, selection, shell, menuGroup, ssFactory, pool)) != null) {
            int idx = 0;
            while (idx < actions.length) {
                IAction action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor poolImage = null;
        ISystemFilterPool pool = (ISystemFilterPool)element;
        if (pool.getProvider() != null) {
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = pool.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter((Class)clazz);
            poolImage = adapter.getSystemFilterPoolImage(pool);
        }
        if (poolImage == null) {
            poolImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterpoolIcon");
        }
        return poolImage;
    }

    public String getText(Object element) {
        return ((ISystemFilterPool)element).getName();
    }

    public String getName(Object element) {
        return ((ISystemFilterPool)element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilterPool filterPool = (ISystemFilterPool)element;
        return String.valueOf(filterPool.getSystemFilterPoolManager().getName()) + "." + filterPool.getName();
    }

    public String getType(Object element) {
        if (this.translatedType == null) {
            this.translatedType = SystemViewResources.RESID_PROPERTY_FILTERPOOL_TYPE_VALUE;
        }
        return this.translatedType;
    }

    public Object getParent(Object element) {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        ISubSystemConfiguration ssParentFactory = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilterPool)fp);
        return ssParentFactory.getSubSystems(false)[0];
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        return fp.getSystemFilters();
    }

    public boolean hasChildren(IAdaptable element) {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        return fp.getSystemFilterCount() > 0;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[3];
            int idx = 0;
            SystemViewFilterPoolAdapter.propertyDescriptorArray[idx] = SystemViewFilterPoolAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPOOL_TOOLTIP);
            SystemViewFilterPoolAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.profile", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_PARENTPROFILE_TOOLTIP);
            SystemViewFilterPoolAdapter.propertyDescriptorArray[++idx] = SystemViewFilterPoolAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterRelatedConnection", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_RELATEDCONNECTION_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilterPool pool = (ISystemFilterPool)this.propertySourceInput;
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            return pool.getName();
        }
        if (name.equals("org.eclipse.rse.ui.profile")) {
            return pool.getSystemFilterPoolManager().getName();
        }
        if (name.equals("org.eclipse.rse.ui.filterRelatedConnection")) {
            return pool.getOwningParentName() == null ? this.getTranslatedNotApplicable() : pool.getOwningParentName();
        }
        return null;
    }

    public boolean canDelete(Object element) {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        return fp.isDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilterPool(fp);
        return true;
    }

    public boolean canRename(Object element) {
        if (!this.canDelete(element)) {
            return false;
        }
        ISystemFilterPool fp = (ISystemFilterPool)element;
        return !fp.isNonRenamable();
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        ISystemFilterPoolManager fpMgr = fp.getSystemFilterPoolManager();
        fpMgr.renameSystemFilterPool(fp, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilterPool fp = (ISystemFilterPool)element;
        ISystemFilterPoolManager mgr = fp.getSystemFilterPoolManager();
        Vector v = mgr.getSystemFilterPoolNamesVector();
        ValidatorFilterPoolName nameValidator = new ValidatorFilterPoolName(v);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        String mgrName = ((ISystemFilterPool)element).getSystemFilterPoolManager().getName();
        return (String.valueOf(mgrName) + "." + newName).toUpperCase();
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

