/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterStringAdapter
extends AbstractSystemViewAdapter {
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        ISystemFilterString filterString = this.getFilterString(selection.getFirstElement());
        if (filterString.getParentSystemFilter().isTransient()) {
            return;
        }
    }

    private ISystemFilterString getFilterString(Object element) {
        return (ISystemFilterString)element;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor filterImage = null;
        ISystemFilterString filterString = this.getFilterString(element);
        if (filterString.getProvider() != null) {
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = filterString.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter((Class)clazz);
            filterImage = adapter.getSystemFilterStringImage(filterString);
        }
        if (filterImage == null) {
            filterImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterstringIcon");
        }
        return filterImage;
    }

    public String getText(Object element) {
        return this.getFilterString(element).getString();
    }

    public String getName(Object element) {
        return this.getFilterString(element).getString();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilterString filterString = this.getFilterString(element);
        ISystemFilter filter = filterString.getParentSystemFilter();
        return String.valueOf(filter.getSystemFilterPoolManager().getName()) + "." + filter.getParentFilterPool().getName() + "." + filter.getName() + "." + filterString.getString();
    }

    public String getType(Object element) {
        return SystemResources.RESID_PP_FILTERSTRING_TYPE_VALUE;
    }

    public Object getParent(Object element) {
        ISystemFilterString filterString = this.getFilterString(element);
        return filterString.getParentSystemFilter();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return null;
    }

    public boolean hasChildren(IAdaptable element) {
        return false;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[3];
            SystemViewFilterStringAdapter.propertyDescriptorArray[0] = SystemViewFilterStringAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_TOOLTIP);
            SystemViewFilterStringAdapter.propertyDescriptorArray[1] = SystemViewFilterStringAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParent", SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_TOOLTIP);
            SystemViewFilterStringAdapter.propertyDescriptorArray[2] = SystemViewFilterStringAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterString", SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilterString filterString = this.getFilterString(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterString")) {
            return filterString.getString();
        }
        if (name.equals("org.eclipse.rse.ui.filterParent")) {
            return filterString.getParentSystemFilter().getName();
        }
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            if (filterString.getParentSystemFilter().isTransient()) {
                return this.getTranslatedNotApplicable();
            }
            ISystemFilterPool parent = filterString.getParentSystemFilter().getParentFilterPool();
            if (parent != null) {
                return parent.getName();
            }
            return null;
        }
        return null;
    }

    public boolean showDelete(Object element) {
        return !this.getFilterString(element).getParentSystemFilter().isTransient();
    }

    public boolean canDelete(Object element) {
        return true;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilterString filterString = this.getFilterString(element);
        ISystemFilter filter = filterString.getParentSystemFilter();
        ISystemFilterPoolManager fpMgr = filterString.getSystemFilterPoolManager();
        Vector strings = filter.getSystemFiltersVector();
        String[] filterStrings = new String[strings.size() - 1];
        int idx = 0;
        while (idx < filterStrings.length) {
            filterStrings[idx] = ((ISystemFilterString)strings.elementAt(idx)).toString();
            ++idx;
        }
        strings.remove(filterString);
        fpMgr.updateSystemFilter(filter, filter.getName(), filterStrings);
        return true;
    }

    public boolean showRename(Object element) {
        return false;
    }

    public boolean canRename(Object element) {
        return false;
    }

    public boolean doRename(Shell shell, Object element, String name) throws Exception {
        return true;
    }

    public boolean showRefresh(Object element) {
        return false;
    }

    public boolean showOpenViewActions(Object element) {
        return false;
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

